/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.gui;

import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.gui.MachineMenuCommon;
import aztech.modern_industrialization.network.machines.MachineComponentSyncPacket;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;

public class MachineMenuServer
extends MachineMenuCommon {
    public final MachineBlockEntity blockEntity;
    protected final List trackedData;

    public MachineMenuServer(int syncId, Inventory playerInventory, MachineBlockEntity blockEntity, MachineGuiParameters guiParams) {
        super(syncId, playerInventory, blockEntity.getInventory(), guiParams, blockEntity.guiComponents);
        this.blockEntity = blockEntity;
        this.trackedData = new ArrayList();
        for (GuiComponent.Server component : blockEntity.guiComponents) {
            this.trackedData.add(component.copyData());
        }
    }

    @Override
    public void broadcastChanges() {
        super.broadcastChanges();
        for (int i = 0; i < this.blockEntity.guiComponents.size(); ++i) {
            GuiComponent.Server component = this.blockEntity.guiComponents.get(i);
            if (!component.needsSync(this.trackedData.get(i))) continue;
            RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), this.blockEntity.getLevel().registryAccess());
            component.writeCurrentData(buf);
            byte[] bytes = new byte[buf.writerIndex()];
            buf.readBytes(bytes);
            new MachineComponentSyncPacket(this.containerId, i, bytes).sendToClient((ServerPlayer)this.playerInventory.player);
            this.trackedData.set(i, component.copyData());
            buf.release();
        }
    }

    public boolean stillValid(Player player) {
        BlockPos pos = this.blockEntity.getBlockPos();
        if (player.level().getBlockEntity(pos) != this.blockEntity) {
            return false;
        }
        return player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0;
    }

    @Override
    public void readClientComponentSyncData(int componentIndex, RegistryFriendlyByteBuf buf) {
        throw new UnsupportedOperationException("Data can only be read on the client side!");
    }
}

