/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.items.RedstoneControlModuleItem;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.DropableComponent;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class RedstoneControlComponent
implements IComponent.ServerOnly,
DropableComponent {
    public static final ResourceLocation ID = MI.id("redstone_control");
    private ItemStack controlModule = ItemStack.EMPTY;

    public boolean doAllowNormalOperation(MachineBlockEntity machine) {
        if (this.controlModule.isEmpty()) {
            return true;
        }
        return RedstoneControlModuleItem.isRequiresLowSignal(this.controlModule) != machine.hasRedstoneHighSignal();
    }

    @Override
    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("redstoneModuleStack", this.controlModule.saveOptional(registries));
    }

    @Override
    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
        this.controlModule = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("redstoneModuleStack"));
    }

    public ItemInteractionResult onUse(MachineBlockEntity be, Player player, InteractionHand hand) {
        ItemStack stackInHand = player.getItemInHand(hand);
        if (stackInHand.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (MIItem.REDSTONE_CONTROL_MODULE.is(stackInHand) && this.controlModule.isEmpty()) {
            this.controlModule = stackInHand.copy();
            this.controlModule.setCount(1);
            stackInHand.shrink(1);
            be.setChanged();
            return ItemInteractionResult.sidedSuccess((boolean)player.level().isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public ItemStack getDrop() {
        return this.controlModule;
    }

    public void setStackServer(MachineBlockEntity be, ItemStack stack) {
        this.controlModule = stack;
        be.setChanged();
        be.sync();
    }
}

