/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.api.datamaps.FluidFuel;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.components.SteamHeaterComponent;
import aztech.modern_industrialization.machines.components.TemperatureComponent;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.util.ItemStackHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class FuelBurningComponent
implements IComponent {
    public final long maxEuProduction;
    public final long euPerDegree;
    public final TemperatureComponent temperature;
    private final long burningEuMultiplier;
    public static final long EU_PER_BURN_TICK = 20L;
    private long burningEuBuffer;

    public FuelBurningComponent(TemperatureComponent temperature, long maxEuProduction, long euPerDegree, long burningEuMultiplier) {
        this.temperature = temperature;
        this.maxEuProduction = maxEuProduction;
        this.euPerDegree = euPerDegree;
        this.burningEuMultiplier = burningEuMultiplier;
    }

    public FuelBurningComponent(TemperatureComponent temperature, long maxEuProduction, long euPerDegree) {
        this(temperature, maxEuProduction, euPerDegree, 1L);
    }

    public FuelBurningComponent(SteamHeaterComponent steamHeater, long burningEuMultiplier) {
        this(steamHeater, steamHeater.maxEuProduction, steamHeater.euPerDegree, burningEuMultiplier);
    }

    public FuelBurningComponent(SteamHeaterComponent steamHeater) {
        this(steamHeater, steamHeater.maxEuProduction, steamHeater.euPerDegree, 1L);
    }

    public boolean isBurning() {
        return this.burningEuBuffer > 0L;
    }

    public void disable() {
        this.burningEuBuffer = 0L;
    }

    public double getBurningProgress() {
        return Math.min(1.0, (double)this.burningEuBuffer / (double)(100L * this.maxEuProduction));
    }

    public void tick(List<ConfigurableItemStack> itemInputs, List<ConfigurableFluidStack> fluidInputs) {
        long maxEuInsertion = Math.min(this.burningEuBuffer, this.maxEuProduction);
        if ((maxEuInsertion = Math.min(maxEuInsertion, (long)Math.floor((double)this.euPerDegree * (this.temperature.temperatureMax - this.temperature.getTemperature())))) > 0L) {
            this.burningEuBuffer -= maxEuInsertion;
            this.temperature.increaseTemperature((double)maxEuInsertion / (double)this.euPerDegree);
        } else if (this.burningEuBuffer == 0L) {
            this.temperature.decreaseTemperature(1.0);
        }
        block0: while (this.burningEuBuffer < this.maxEuProduction) {
            for (ConfigurableItemStack configurableItemStack : itemInputs) {
                int fuelTime;
                ItemStack fuel = ((ItemVariant)configurableItemStack.getResource()).toStack((int)configurableItemStack.getAmount());
                if (!ItemStackHelper.consumeFuel(configurableItemStack, true) || (fuelTime = fuel.getBurnTime(null)) <= 0) continue;
                this.burningEuBuffer += (long)fuelTime * 20L * this.burningEuMultiplier;
                ItemStackHelper.consumeFuel(configurableItemStack, false);
                continue block0;
            }
        }
        block2: while (this.burningEuBuffer < 100L * this.maxEuProduction) {
            for (ConfigurableFluidStack configurableFluidStack : fluidInputs) {
                long mbConsumedMax;
                long mbConsumed;
                long euPerMb;
                if (configurableFluidStack.isEmpty() || (euPerMb = (long)FluidFuel.getEu(((FluidVariant)configurableFluidStack.getResource()).getFluid()) * this.burningEuMultiplier) == 0L || (mbConsumed = Math.min(mbConsumedMax = (100L * this.maxEuProduction - this.burningEuBuffer) / euPerMb, configurableFluidStack.getAmount())) <= 0L) continue;
                configurableFluidStack.decrement(mbConsumed);
                this.burningEuBuffer += mbConsumed * euPerMb;
                continue block2;
            }
        }
    }

    @Override
    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putLong("burningEuBuffer", this.burningEuBuffer);
    }

    @Override
    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
        this.burningEuBuffer = tag.getLong("burningEuBuffer");
    }

    public List<Component> getTooltips() {
        ArrayList<Component> returnList = new ArrayList<Component>();
        returnList.add((Component)new MITooltips.Line(MIText.MaxEuProductionSteam).arg(this.maxEuProduction, MITooltips.EU_PER_TICK_PARSER).arg(MIFluids.STEAM).build());
        if (this.burningEuMultiplier == 2L) {
            returnList.add((Component)new MITooltips.Line(MIText.DoubleFluidFuelEfficiency).build());
        }
        return returnList;
    }
}

