/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.multiblocks;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.components.FuelBurningComponent;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.MultiblockInventoryComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.components.SteamHeaterComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.ProgressBar;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.guicomponents.TemperatureBar;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.util.Tickable;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.material.Fluids;

public class SteamBoilerMultiblockBlockEntity
extends MultiblockMachineBlockEntity
implements Tickable {
    private ShapeMatcher shapeMatcher;
    private final ShapeTemplate shapeTemplate;
    private final IsActiveComponent isActiveComponent;
    private final RedstoneControlComponent redstoneControl;
    private final MultiblockInventoryComponent inventory;
    private final SteamHeaterComponent steamHeater;
    private final FuelBurningComponent fuelBurning;
    public final boolean highPressure;

    public SteamBoilerMultiblockBlockEntity(BEP bep, ShapeTemplate shapeTemplate, String name, long maxEuProduction, boolean highPressure) {
        super(bep, new MachineGuiParameters.Builder(name, false).build(), new OrientationComponent.Params(false, false, false));
        this.highPressure = highPressure;
        this.isActiveComponent = new IsActiveComponent();
        this.shapeTemplate = shapeTemplate;
        this.inventory = new MultiblockInventoryComponent();
        this.redstoneControl = new RedstoneControlComponent();
        this.steamHeater = new SteamHeaterComponent(2500.0, maxEuProduction, maxEuProduction / 32L, !highPressure, highPressure, true);
        this.fuelBurning = new FuelBurningComponent(this.steamHeater, 2L);
        this.registerComponents(this.isActiveComponent, this.steamHeater, this.fuelBurning, this.redstoneControl);
        ProgressBar.Parameters PROGRESS_BAR = new ProgressBar.Parameters(82, 30, "furnace", true);
        TemperatureBar.Parameters TEMPERATURE_BAR = new TemperatureBar.Parameters(42, 55, 2500);
        this.registerGuiComponent(new ProgressBar.Server(PROGRESS_BAR, () -> Float.valueOf((float)this.fuelBurning.getBurningProgress())));
        this.registerGuiComponent(new TemperatureBar.Server(TEMPERATURE_BAR, () -> (int)this.steamHeater.getTemperature()));
        this.registerGuiComponent(new SlotPanel.Server(this).withRedstoneControl(this.redstoneControl));
    }

    protected final void link() {
        if (this.shapeMatcher == null) {
            this.shapeMatcher = new ShapeMatcher(this.level, this.worldPosition, this.orientation.facingDirection, this.shapeTemplate);
            this.shapeMatcher.registerListeners(this.level);
        }
        if (this.shapeMatcher.needsRematch()) {
            this.shapeValid.shapeValid = false;
            this.shapeMatcher.rematch(this.level);
            if (this.shapeMatcher.isMatchSuccessful()) {
                this.inventory.rebuild(this.shapeMatcher);
                this.shapeValid.shapeValid = true;
            }
            if (this.shapeValid.update()) {
                this.sync(false);
            }
        }
    }

    @Override
    public final void unlink() {
        if (this.shapeMatcher != null) {
            this.shapeMatcher.unlinkHatches();
            this.shapeMatcher.unregisterListeners(this.level);
            this.shapeMatcher = null;
        }
    }

    @Override
    public ShapeTemplate getActiveShape() {
        return this.shapeTemplate;
    }

    @Override
    public MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    @Override
    protected MachineModelClientData getMachineModelData() {
        return new MachineModelClientData(null, this.orientation.facingDirection).active(this.isActiveComponent.isActive);
    }

    @Override
    public void tick() {
        if (!this.level.isClientSide) {
            this.link();
            if (this.shapeValid.shapeValid) {
                if (this.redstoneControl.doAllowNormalOperation(this)) {
                    this.steamHeater.tick(this.inventory.getFluidInputs(), this.inventory.getFluidOutputs());
                    this.fuelBurning.tick(this.inventory.getItemInputs(), this.inventory.getFluidInputs());
                    this.isActiveComponent.updateActive(this.fuelBurning.isBurning(), this);
                } else {
                    this.isActiveComponent.updateActive(false, this);
                }
            } else {
                this.fuelBurning.disable();
                this.steamHeater.decreaseTemperature(1.0);
                this.isActiveComponent.updateActive(false, this);
            }
            this.setChanged();
        }
    }

    @Override
    public List<Component> getTooltips() {
        List<Component> tooltips = this.fuelBurning.getTooltips();
        tooltips.add((Component)new MITooltips.Line(MIText.ContinuousOperation).build());
        if (this.highPressure) {
            tooltips.add((Component)new MITooltips.Line(MIText.AcceptLowOrHighPressure).arg(MIFluids.HIGH_PRESSURE_WATER).arg(MIFluids.HIGH_PRESSURE_HEAVY_WATER).build());
        } else {
            tooltips.add((Component)new MITooltips.Line(MIText.AcceptLowOrHighPressure).arg(Fluids.WATER).arg(MIFluids.HEAVY_WATER).build());
        }
        return tooltips;
    }
}

