/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.multiblocks;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.compat.rei.machines.ReiMachineRecipes;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.blockentities.hatches.NuclearHatch;
import aztech.modern_industrialization.machines.components.ActiveShapeComponent;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.NuclearEfficiencyHistoryComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.NuclearReactorGui;
import aztech.modern_industrialization.machines.guicomponents.ShapeSelection;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.HatchFlags;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.multiblocks.SimpleMember;
import aztech.modern_industrialization.nuclear.NuclearGrid;
import aztech.modern_industrialization.nuclear.NuclearGridHelper;
import aztech.modern_industrialization.util.Tickable;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Direction;

public class NuclearReactorMultiblockBlockEntity
extends MultiblockMachineBlockEntity
implements Tickable {
    private static final ShapeTemplate[] shapeTemplates = new ShapeTemplate[4];
    private static final boolean[][][] gridLayout = new boolean[4][][];
    private final ActiveShapeComponent activeShape = new ActiveShapeComponent(shapeTemplates);
    private final RedstoneControlComponent redstoneControl;
    private final IsActiveComponent isActive;
    private final NuclearEfficiencyHistoryComponent efficiencyHistory = new NuclearEfficiencyHistoryComponent();
    private ShapeMatcher shapeMatcher;
    private NuclearGrid nuclearGrid;
    private Supplier<NuclearReactorGui.Data> dataSupplier;

    public NuclearReactorMultiblockBlockEntity(BEP bep) {
        super(bep, new MachineGuiParameters.Builder("nuclear_reactor", false).backgroundHeight(256).build(), new OrientationComponent.Params(false, false, false));
        this.isActive = new IsActiveComponent();
        this.redstoneControl = new RedstoneControlComponent();
        this.registerComponents(this.activeShape, this.isActive, this.efficiencyHistory, this.redstoneControl);
        this.registerGuiComponent(new NuclearReactorGui.Server(this::sendData), new SlotPanel.Server(this).withRedstoneControl(this.redstoneControl));
        this.registerGuiComponent(new ShapeSelection.Server(new ShapeSelection.Behavior(){

            @Override
            public void handleClick(int clickedLine, int delta) {
                NuclearReactorMultiblockBlockEntity.this.activeShape.incrementShape(NuclearReactorMultiblockBlockEntity.this, delta);
            }

            @Override
            public int getCurrentIndex(int line) {
                return NuclearReactorMultiblockBlockEntity.this.activeShape.getActiveShapeIndex();
            }
        }, new ShapeSelection.LineInfo(4, List.of(MIText.ShapeTextSmall.text(), MIText.ShapeTextMedium.text(), MIText.ShapeTextLarge.text(), MIText.ShapeTextExtreme.text()), true)));
    }

    public NuclearReactorGui.Data sendData() {
        if (this.shapeValid.shapeValid) {
            return this.dataSupplier.get();
        }
        return new NuclearReactorGui.Data(false, 0, 0, null, 0.0, 0.0);
    }

    @Override
    public MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    @Override
    protected final MachineModelClientData getMachineModelData() {
        return new MachineModelClientData(null, this.orientation.facingDirection).active(this.isActive.isActive);
    }

    @Override
    public void tick() {
        if (!this.level.isClientSide) {
            this.link();
            if (this.shapeValid.shapeValid) {
                if (this.redstoneControl.doAllowNormalOperation(this)) {
                    this.isActive.updateActive(NuclearGridHelper.simulate(this.nuclearGrid, this.efficiencyHistory), this);
                } else {
                    this.isActive.updateActive(false, this);
                }
                this.efficiencyHistory.tick();
            } else {
                this.isActive.updateActive(false, this);
                this.efficiencyHistory.clear();
            }
        }
    }

    protected void onSuccessfulMatch(ShapeMatcher shapeMatcher) {
        this.shapeValid.shapeValid = true;
        int size = gridLayout[this.activeShape.getActiveShapeIndex()].length;
        NuclearHatch[][] hatchesGrid = new NuclearHatch[size][size];
        for (HatchBlockEntity hatch : shapeMatcher.getMatchedHatches()) {
            int x0 = hatch.getBlockPos().getX() - this.getBlockPos().getX();
            int z0 = hatch.getBlockPos().getZ() - this.getBlockPos().getZ();
            if (this.orientation.facingDirection == Direction.NORTH) {
                x = size / 2 + x0;
                y = z0;
            } else if (this.orientation.facingDirection == Direction.SOUTH) {
                x = size / 2 - x0;
                y = -z0;
            } else if (this.orientation.facingDirection == Direction.EAST) {
                x = size / 2 + z0;
                y = -x0;
            } else {
                x = size / 2 - z0;
                y = x0;
            }
            hatchesGrid[x][y] = (NuclearHatch)hatch;
        }
        this.nuclearGrid = new NuclearGrid(size, size, hatchesGrid);
        this.dataSupplier = () -> {
            Optional[] tilesData = new Optional[size * size];
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < size; ++j) {
                    int x = size - 1 - i;
                    int y = size - 1 - j;
                    int index = NuclearReactorGui.Data.toIndex(i, j, size);
                    tilesData[index] = Optional.ofNullable(hatchesGrid[x][y]);
                }
            }
            return new NuclearReactorGui.Data(true, size, size, tilesData, this.efficiencyHistory.getAverage(NuclearEfficiencyHistoryComponent.Type.euProduction), this.efficiencyHistory.getAverage(NuclearEfficiencyHistoryComponent.Type.euFuelConsumption));
        };
    }

    @Override
    public ShapeTemplate getActiveShape() {
        return this.activeShape.getActiveShape();
    }

    protected final void link() {
        if (this.shapeMatcher == null) {
            this.shapeMatcher = new ShapeMatcher(this.level, this.worldPosition, this.orientation.facingDirection, this.getActiveShape());
            this.shapeMatcher.registerListeners(this.level);
        }
        if (this.shapeMatcher.needsRematch()) {
            this.shapeValid.shapeValid = false;
            this.nuclearGrid = null;
            this.shapeMatcher.rematch(this.level);
            if (this.shapeMatcher.isMatchSuccessful()) {
                this.shapeValid.shapeValid = true;
                this.onSuccessfulMatch(this.shapeMatcher);
            }
            if (this.shapeValid.update()) {
                this.sync(false);
            }
        }
    }

    @Override
    public final void unlink() {
        if (this.shapeMatcher != null) {
            this.shapeMatcher.unlinkHatches();
            this.shapeMatcher.unregisterListeners(this.level);
            this.shapeMatcher = null;
        }
    }

    public static void registerReiShapes() {
        for (ShapeTemplate shapeTemplate : shapeTemplates) {
            ReiMachineRecipes.registerMultiblockShape("nuclear_reactor", shapeTemplate);
        }
    }

    static {
        SimpleMember casing = SimpleMember.forBlock((Supplier)MIBlock.BLOCK_DEFINITIONS.get(MI.id("nuclear_casing")));
        SimpleMember pipe = SimpleMember.forBlock((Supplier)MIBlock.BLOCK_DEFINITIONS.get(MI.id("nuclear_alloy_machine_casing_pipe")));
        HatchFlags top = new HatchFlags.Builder().with(HatchType.NUCLEAR_FLUID, HatchType.NUCLEAR_ITEM).build();
        for (int i = 0; i < 4; ++i) {
            ShapeTemplate.Builder builder = new ShapeTemplate.Builder(MachineCasings.NUCLEAR);
            NuclearReactorMultiblockBlockEntity.gridLayout[i] = new boolean[5 + 2 * i][5 + 2 * i];
            for (int x = -2 - i; x <= 2 + i; ++x) {
                int xAbs = Math.abs(x);
                int minZ = i != 3 ? (xAbs == 0 ? 0 : xAbs - 1) : (xAbs <= 1 ? 0 : xAbs - 2);
                int maxZ = 2 * (2 + i) - minZ;
                for (int z = minZ; z <= maxZ; ++z) {
                    NuclearReactorMultiblockBlockEntity.gridLayout[i][2 + i + x][z] = true;
                    if (z != minZ && z != maxZ && xAbs != 2 + i) {
                        builder.add(x, -1, z, casing, null);
                        builder.add(x, 0, z, pipe, null);
                        builder.add(x, 1, z, pipe, null);
                        builder.add(x, 2, z, pipe, null);
                        builder.add(x, 3, z, casing, top);
                        continue;
                    }
                    builder.add(x, -1, z, casing, null);
                    if (x != 0 || z != 0) {
                        builder.add(x, 0, z, casing, null);
                    }
                    builder.add(x, 1, z, casing, null);
                    builder.add(x, 2, z, casing, null);
                    builder.add(x, 3, z, casing, null);
                }
            }
            NuclearReactorMultiblockBlockEntity.shapeTemplates[i] = builder.build();
        }
    }
}

