/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.multiblocks;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MICapabilities;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.api.machine.holder.FluidStorageComponentHolder;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.blockentities.hatches.LargeTankHatch;
import aztech.modern_industrialization.machines.components.ActiveShapeComponent;
import aztech.modern_industrialization.machines.components.FluidStorageComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.LargeTankFluidDisplay;
import aztech.modern_industrialization.machines.guicomponents.ShapeSelection;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.HatchFlags;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.multiblocks.SimpleMember;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.util.Tickable;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.EmptyFluidHandler;
import org.jetbrains.annotations.Nullable;

public class LargeTankMultiblockBlockEntity
extends MultiblockMachineBlockEntity
implements Tickable,
FluidStorageComponentHolder {
    private static final int[] X_SIZES = new int[]{3, 5, 7};
    private static final int[] Y_SIZES = new int[]{3, 4, 5, 6, 7};
    private static final int[] Z_SIZES = new int[]{3, 4, 5, 6, 7};
    public static final long BUCKET_PER_STRUCTURE_BLOCK = 64L;
    private static final ShapeTemplate[] shapeTemplates = new ShapeTemplate[75];
    @Nullable
    private ShapeMatcher shapeMatcher = null;
    private final ActiveShapeComponent activeShape = new ActiveShapeComponent(shapeTemplates);
    private final FluidStorageComponent fluidStorage = new FluidStorageComponent();
    private LargeTankFluidDisplay.Data oldFluidData;

    private static int getXComponent(int shapeIndex) {
        return shapeIndex / 25;
    }

    private static int getYComponent(int shapeIndex) {
        return shapeIndex % 25 / 5;
    }

    private static int getZComponent(int shapeIndex) {
        return shapeIndex % 25 % 5;
    }

    private static ShapeSelection.LineInfo createLineInfo(int[] sizes, MIText baseText) {
        return new ShapeSelection.LineInfo(sizes.length, IntStream.of(sizes).mapToObj(xva$0 -> baseText.text(xva$0)).toList(), false);
    }

    public static void registerFluidAPI(BlockEntityType<?> bet) {
        MICapabilities.onEvent(event -> event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, bet, (be, direction) -> {
            LargeTankMultiblockBlockEntity tank = (LargeTankMultiblockBlockEntity)be;
            if (tank.isShapeValid()) {
                return tank.fluidStorage.getFluidHandler();
            }
            return EmptyFluidHandler.INSTANCE;
        }));
    }

    private static ShapeTemplate buildShape(int index) {
        int sizeX = X_SIZES[LargeTankMultiblockBlockEntity.getXComponent(index)];
        int sizeY = Y_SIZES[LargeTankMultiblockBlockEntity.getYComponent(index)];
        int sizeZ = Z_SIZES[LargeTankMultiblockBlockEntity.getZComponent(index)];
        ShapeTemplate.Builder templateBuilder = new ShapeTemplate.Builder(MachineCasings.STEEL);
        SimpleMember steelCasing = SimpleMember.forBlock((Supplier)MIBlock.BLOCK_DEFINITIONS.get(MI.id("steel_machine_casing")));
        SimpleMember glass = SimpleMember.forBlock(() -> Blocks.GLASS);
        HatchFlags hatchFlags = new HatchFlags.Builder().with(HatchType.LARGE_TANK).build();
        for (int x = -sizeX / 2; x <= sizeX / 2; ++x) {
            for (int y = -1; y < sizeY - 1; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    int lim = 0;
                    if (x == -sizeX / 2 || x == sizeX / 2) {
                        ++lim;
                    }
                    if (y == -1 || y == sizeY - 2) {
                        ++lim;
                    }
                    if (z == 0 || z == sizeZ - 1) {
                        ++lim;
                    }
                    if (x == 0 && y == 0 && z == 0) continue;
                    if (lim == 1) {
                        templateBuilder.add(x, y, z, glass, hatchFlags);
                        continue;
                    }
                    if (lim < 2) continue;
                    templateBuilder.add(x, y, z, steelCasing, hatchFlags);
                }
            }
        }
        return templateBuilder.build();
    }

    public LargeTankMultiblockBlockEntity(BEP bep) {
        super(bep, new MachineGuiParameters.Builder("large_tank", false).build(), new OrientationComponent.Params(false, false, false));
        this.registerComponents(this.activeShape, this.fluidStorage);
        this.registerGuiComponent(new ShapeSelection.Server(new ShapeSelection.Behavior(){

            @Override
            public void handleClick(int clickedLine, int delta) {
                int shape = LargeTankMultiblockBlockEntity.this.activeShape.getActiveShapeIndex();
                int activeX = LargeTankMultiblockBlockEntity.getXComponent(shape);
                int activeY = LargeTankMultiblockBlockEntity.getYComponent(shape);
                int activeZ = LargeTankMultiblockBlockEntity.getZComponent(shape);
                if (clickedLine == 0) {
                    activeX = Mth.clamp((int)(activeX + delta), (int)0, (int)(X_SIZES.length - 1));
                } else if (clickedLine == 1) {
                    activeY = Mth.clamp((int)(activeY + delta), (int)0, (int)(Y_SIZES.length - 1));
                } else {
                    activeZ = Mth.clamp((int)(activeZ + delta), (int)0, (int)(Z_SIZES.length - 1));
                }
                int newShape = activeZ + activeY * 5 + activeX * 25;
                LargeTankMultiblockBlockEntity.this.activeShape.setShape(LargeTankMultiblockBlockEntity.this, newShape);
            }

            @Override
            public int getCurrentIndex(int line) {
                int shape = LargeTankMultiblockBlockEntity.this.activeShape.getActiveShapeIndex();
                return switch (line) {
                    case 0 -> LargeTankMultiblockBlockEntity.getXComponent(shape);
                    case 1 -> LargeTankMultiblockBlockEntity.getYComponent(shape);
                    default -> LargeTankMultiblockBlockEntity.getZComponent(shape);
                };
            }
        }, LargeTankMultiblockBlockEntity.createLineInfo(X_SIZES, MIText.ShapeTextWidth), LargeTankMultiblockBlockEntity.createLineInfo(Y_SIZES, MIText.ShapeTextHeight), LargeTankMultiblockBlockEntity.createLineInfo(Z_SIZES, MIText.ShapeTextDepth)));
        this.registerGuiComponent(new LargeTankFluidDisplay.Server(this::getFluidData));
    }

    public LargeTankFluidDisplay.Data getFluidData() {
        return new LargeTankFluidDisplay.Data(this.fluidStorage.getFluid(), this.fluidStorage.getAmount(), this.fluidStorage.getCapacity());
    }

    @Override
    public MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    @Override
    public ShapeTemplate getActiveShape() {
        return this.activeShape.getActiveShape();
    }

    @Override
    public FluidStorageComponent getFluidStorageComponent() {
        return this.fluidStorage;
    }

    @Override
    protected MachineModelClientData getMachineModelData() {
        return new MachineModelClientData(null, this.orientation.facingDirection);
    }

    protected final void link() {
        if (this.shapeMatcher == null) {
            this.shapeMatcher = new ShapeMatcher(this.level, this.worldPosition, this.orientation.facingDirection, this.getActiveShape());
            this.shapeMatcher.registerListeners(this.level);
        }
        if (this.shapeMatcher.needsRematch()) {
            this.shapeValid.shapeValid = false;
            this.shapeMatcher.rematch(this.level);
            if (this.shapeMatcher.isMatchSuccessful()) {
                this.shapeValid.shapeValid = true;
                this.onMatchSuccessful();
            }
            if (this.shapeValid.update()) {
                this.sync(false);
            }
        }
    }

    @Override
    public final void unlink() {
        if (this.shapeMatcher != null) {
            this.shapeMatcher.unlinkHatches();
            this.shapeMatcher.unregisterListeners(this.level);
            this.shapeMatcher = null;
        }
    }

    @Override
    public void tick() {
        if (!this.level.isClientSide) {
            this.link();
            this.setChanged();
            if (!this.getFluidData().equals(this.oldFluidData)) {
                this.oldFluidData = this.getFluidData();
                this.sync(false);
            }
        }
    }

    public static long getCapacityFromComponents(int xIndex, int yIndex, int zIndex) {
        int sizeX = X_SIZES[xIndex];
        int sizeY = Y_SIZES[yIndex];
        int sizeZ = Z_SIZES[zIndex];
        int volume = sizeX * sizeY * sizeZ;
        return (long)volume * 64L * 1000L;
    }

    private void onMatchSuccessful() {
        int index = this.activeShape.getActiveShapeIndex();
        long capacity = LargeTankMultiblockBlockEntity.getCapacityFromComponents(LargeTankMultiblockBlockEntity.getXComponent(index), LargeTankMultiblockBlockEntity.getYComponent(index), LargeTankMultiblockBlockEntity.getZComponent(index));
        this.fluidStorage.setCapacity(capacity);
        for (HatchBlockEntity hatch : this.shapeMatcher.getMatchedHatches()) {
            if (!(hatch instanceof LargeTankHatch)) continue;
            LargeTankHatch tankHatch = (LargeTankHatch)hatch;
            tankHatch.setController(this);
        }
    }

    public IFluidHandler getExposedFluidHandler() {
        if (this.isShapeValid()) {
            return this.fluidStorage.getFluidHandler();
        }
        return EmptyFluidHandler.INSTANCE;
    }

    public FluidVariant getFluid() {
        return this.fluidStorage.getFluid();
    }

    public double getFullnessFraction() {
        return (double)this.fluidStorage.getAmount() / (double)this.fluidStorage.getCapacity();
    }

    public int[] getCornerPosition() {
        int i;
        int index = this.activeShape.getActiveShapeIndex();
        int sizeX = X_SIZES[LargeTankMultiblockBlockEntity.getXComponent(index)];
        int sizeY = Y_SIZES[LargeTankMultiblockBlockEntity.getYComponent(index)];
        int sizeZ = Z_SIZES[LargeTankMultiblockBlockEntity.getZComponent(index)];
        BlockPos[] corners = new BlockPos[]{ShapeMatcher.toWorldPos(this.getBlockPos(), this.orientation.facingDirection, new BlockPos(-sizeX / 2 + 1, 0, 1)), ShapeMatcher.toWorldPos(this.getBlockPos(), this.orientation.facingDirection, new BlockPos(sizeX / 2 - 1, sizeY - 3, sizeZ - 2))};
        int[] cornerPosition = new int[6];
        for (i = 0; i < 3; ++i) {
            cornerPosition[i] = Integer.MIN_VALUE;
            cornerPosition[i + 3] = Integer.MAX_VALUE;
        }
        for (i = 0; i < 2; ++i) {
            cornerPosition[0] = Math.max(corners[i].getX() - this.getBlockPos().getX(), cornerPosition[0]);
            cornerPosition[1] = Math.max(corners[i].getY() - this.getBlockPos().getY(), cornerPosition[1]);
            cornerPosition[2] = Math.max(corners[i].getZ() - this.getBlockPos().getZ(), cornerPosition[2]);
            cornerPosition[3] = Math.min(corners[i].getX() - this.getBlockPos().getX(), cornerPosition[3]);
            cornerPosition[4] = Math.min(corners[i].getY() - this.getBlockPos().getY(), cornerPosition[4]);
            cornerPosition[5] = Math.min(corners[i].getZ() - this.getBlockPos().getZ(), cornerPosition[5]);
        }
        return cornerPosition;
    }

    @Override
    public List<Component> getTooltips() {
        return List.of(new MITooltips.Line(MIText.LargeTankTooltips).arg(64L).build());
    }

    static {
        for (int i = 0; i < shapeTemplates.length; ++i) {
            LargeTankMultiblockBlockEntity.shapeTemplates[i] = LargeTankMultiblockBlockEntity.buildShape(i);
        }
    }
}

