/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities;

import aztech.modern_industrialization.MICapabilities;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.api.machine.holder.EnergyComponentHolder;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.blockentities.AbstractWaterPumpBlockEntity;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Simulation;
import java.util.Collections;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class ElectricWaterPumpBlockEntity
extends AbstractWaterPumpBlockEntity
implements EnergyComponentHolder {
    private final MIInventory inventory;
    private final EnergyComponent energy;
    private final MIEnergyStorage insertable;
    private final RedstoneControlComponent redstoneControl;

    public ElectricWaterPumpBlockEntity(BEP bep) {
        super(bep, "electric_water_pump");
        long capacity = 32000L;
        this.inventory = new MIInventory(Collections.emptyList(), Collections.singletonList(ConfigurableFluidStack.lockedOutputSlot(capacity, (Fluid)Fluids.WATER)), SlotPositions.empty(), new SlotPositions.Builder().addSlot(110, 30).build());
        this.energy = new EnergyComponent((BlockEntity)this, 3200L);
        this.insertable = this.energy.buildInsertable(tier -> tier == CableTier.LV);
        this.redstoneControl = new RedstoneControlComponent();
        this.registerComponents(this.energy, this.inventory, this.redstoneControl);
        GuiComponent.Server[] serverArray = new GuiComponent.Server[2];
        serverArray[0] = new EnergyBar.Server(new EnergyBar.Parameters(18, 32), this.energy::getEu, this.energy::getCapacity);
        serverArray[1] = new SlotPanel.Server(this).withRedstoneControl(this.redstoneControl);
        this.registerGuiComponent(serverArray);
    }

    @Override
    protected long consumeEu(long max) {
        if (this.redstoneControl.doAllowNormalOperation(this)) {
            return this.energy.consumeEu(max, Simulation.ACT);
        }
        return 0L;
    }

    @Override
    protected int getWaterMultiplier() {
        return 16;
    }

    @Override
    public MIInventory getInventory() {
        return this.inventory;
    }

    @Override
    protected MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData();
        data.isActive = this.isActiveComponent.isActive;
        this.orientation.writeModelData(data);
        return data;
    }

    @Override
    public EnergyComponent getEnergyComponent() {
        return this.energy;
    }

    public static void registerEnergyApi(BlockEntityType<?> bet) {
        MICapabilities.onEvent(event -> event.registerBlockEntity(EnergyApi.SIDED, bet, (be, direction) -> ((ElectricWaterPumpBlockEntity)be).insertable));
    }
}

