/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items.armor;

import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.items.armor.GraviChestPlateItem;
import aztech.modern_industrialization.items.armor.QuantumArmorItem;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class MIArmorEffects {
    private MIArmorEffects() {
    }

    public static boolean quantumArmorPreventsDamage(LivingEntity entity) {
        int parts = 0;
        for (QuantumArmorItem item : QuantumArmorItem.ITEMS) {
            if (entity.getItemBySlot(item.getType().getSlot()).getItem() != item) continue;
            ++parts;
        }
        return ThreadLocalRandom.current().nextDouble() < (double)parts / 4.0;
    }

    public static boolean allowFlight(Player player) {
        ItemStack chest = player.getItemBySlot(EquipmentSlot.CHEST);
        return MIArmorEffects.allowFlight(chest);
    }

    public static boolean allowFlight(ItemStack chest) {
        GraviChestPlateItem gsp;
        Item item = chest.getItem();
        if (item instanceof GraviChestPlateItem && (gsp = (GraviChestPlateItem)item).isActivated(chest) && gsp.getEnergy(chest) > 0L) {
            return true;
        }
        return chest.getItem() == MIItem.QUANTUM_CHESTPLATE.asItem();
    }

    public static boolean canTankFlyIntoWall(ItemStack helmet) {
        return helmet.getItem() == MIItem.RUBBER_HELMET.asItem() || helmet.getItem() == MIItem.QUANTUM_HELMET.asItem();
    }

    public static boolean canTankFall(ItemStack boots) {
        return boots.getItem() == MIItem.RUBBER_BOOTS.asItem() || boots.getItem() == MIItem.QUANTUM_BOOTS.asItem();
    }

    public static void init() {
        NeoForge.EVENT_BUS.addListener(PlayerTickEvent.Pre.class, event -> {
            Player player = event.getEntity();
            if (!player.level().isClientSide() && MIArmorEffects.allowFlight(player)) {
                player.getAbilities().mayfly = true;
                player.onUpdateAbilities();
            }
        });
        NeoForge.EVENT_BUS.addListener(LivingEquipmentChangeEvent.class, event -> {
            LivingEntity patt0$temp;
            if (event.getSlot() == EquipmentSlot.CHEST && MIArmorEffects.allowFlight(event.getFrom()) && !MIArmorEffects.allowFlight(event.getTo()) && (patt0$temp = event.getEntity()) instanceof Player) {
                Player player = (Player)patt0$temp;
                player.getAbilities().mayfly = false;
                player.getAbilities().flying = false;
                player.onUpdateAbilities();
            }
        });
        NeoForge.EVENT_BUS.addListener(LivingIncomingDamageEvent.class, event -> {
            if (MIArmorEffects.quantumArmorPreventsDamage(event.getEntity())) {
                event.setCanceled(true);
            }
        });
        NeoForge.EVENT_BUS.addListener(LivingIncomingDamageEvent.class, event -> {
            ItemStack head;
            LivingEntity entity = event.getEntity();
            DamageSource source = event.getContainer().getSource();
            float amount = event.getContainer().getOriginalDamage();
            ItemStack tankingStack = null;
            EquipmentSlot es = null;
            if (source.is(DamageTypes.FLY_INTO_WALL)) {
                es = EquipmentSlot.HEAD;
                head = entity.getItemBySlot(es);
                if (MIArmorEffects.canTankFlyIntoWall(head)) {
                    tankingStack = head;
                }
            } else if (source.is(DamageTypes.FALL) && MIArmorEffects.canTankFall(head = entity.getItemBySlot(es = EquipmentSlot.FEET))) {
                tankingStack = head;
            }
            if (tankingStack != null) {
                int intAmount = (int)Math.ceil(amount);
                tankingStack.hurtAndBreak(intAmount, entity, es);
                event.setCanceled(true);
            }
        });
    }
}

