/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items.armor;

import aztech.modern_industrialization.MIComponents;
import aztech.modern_industrialization.api.datamaps.FluidFuel;
import aztech.modern_industrialization.fluid.MIFluid;
import aztech.modern_industrialization.items.FluidFuelItemHelper;
import aztech.modern_industrialization.items.armor.ActivatableChestItem;
import aztech.modern_industrialization.items.armor.MIArmorMaterials;
import aztech.modern_industrialization.items.armor.MIKeyMap;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.util.ObfuscationReflectionHelper;

public class JetpackItem
extends ArmorItem
implements ActivatableChestItem {
    public static final int CAPACITY = 8000;

    public JetpackItem(Item.Properties settings) {
        super(MIArmorMaterials.DIESEL_JETPACK, ArmorItem.Type.CHESTPLATE, settings.stacksTo(1).rarity(Rarity.UNCOMMON).component(MIComponents.ACTIVATED.get(), (Object)false));
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return this.isActivated(stack) && FluidFuelItemHelper.getAmount(stack) > 0;
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        return true;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        Player player;
        if (entity instanceof Player && stack == (player = (Player)entity).getItemBySlot(EquipmentSlot.CHEST)) {
            this.tickArmor(stack, player);
        }
    }

    private void tickArmor(ItemStack stack, Player player) {
        if (this.isActivated(stack) && !player.onGround()) {
            FluidVariant fluid = FluidFuelItemHelper.getFluid(stack);
            long amount = FluidFuelItemHelper.getAmount(stack);
            if (amount > 0L) {
                FluidFuelItemHelper.decrement(stack);
                if (MIKeyMap.isHoldingUp(player)) {
                    FluidFuelItemHelper.decrement(stack);
                    if (player.isFallFlying()) {
                        Vec3 playerFacing = player.getLookAngle();
                        Vec3 playerVelocity = player.getDeltaMovement();
                        double maxSpeed = Math.sqrt((double)FluidFuel.getEu(fluid.getFluid()) / 200.0);
                        double attenuationFactor = 0.5;
                        player.setDeltaMovement(playerVelocity.scale(attenuationFactor).add(playerFacing.scale(maxSpeed)));
                    } else {
                        double maxSpeed = Math.sqrt((double)FluidFuel.getEu(fluid.getFluid()) / 200.0);
                        double acceleration = 0.25;
                        Vec3 v = player.getDeltaMovement();
                        if (v.y < maxSpeed) {
                            player.setDeltaMovement(v.x, Math.min(maxSpeed, v.y + acceleration), v.z);
                        }
                        if (!player.level().isClientSide()) {
                            player.fallDistance = 0.0f;
                        }
                    }
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        ObfuscationReflectionHelper.setPrivateValue(ServerGamePacketListenerImpl.class, (Object)serverPlayer.connection, (Object)0, (String)"aboveGroundTickCount");
                    }
                }
            }
        }
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        return (int)Math.round(this.getDurabilityBarProgress(stack) * 13.0);
    }

    public double getDurabilityBarProgress(ItemStack stack) {
        return (double)FluidFuelItemHelper.getAmount(stack) / 8000.0;
    }

    public boolean hasDurabilityBar(ItemStack itemStack) {
        return true;
    }

    public int getBarColor(ItemStack stack) {
        Fluid fluid = FluidFuelItemHelper.getFluid(stack).getFluid();
        if (fluid instanceof MIFluid) {
            MIFluid cf = (MIFluid)fluid;
            return cf.color;
        }
        return 0;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        FluidFuelItemHelper.appendTooltip(stack, tooltip, 8000L);
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return ItemAttributeModifiers.EMPTY;
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        return false;
    }
}

