/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items.armor;

import aztech.modern_industrialization.items.armor.ActivatableChestItem;
import aztech.modern_industrialization.items.armor.MIKeyMap;
import aztech.modern_industrialization.network.armor.ActivateChestPacket;
import aztech.modern_industrialization.network.armor.UpdateKeysPacket;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;

public class ClientKeyHandler {
    private static boolean up = false;
    public static KeyMapping keyActivate = new KeyMapping("key.modern_industrialization.activate", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 86, "modern_industrialization");

    public static void onEndTick(Minecraft client) {
        ClientKeyHandler.updateState(client);
        ClientKeyHandler.updateKeyMap(client);
    }

    public static void updateState(Minecraft client) {
        if (client.player == null) {
            return;
        }
        ItemStack chest = client.player.getItemBySlot(EquipmentSlot.CHEST);
        Item item = chest.getItem();
        if (item instanceof ActivatableChestItem) {
            ActivatableChestItem activatable = (ActivatableChestItem)item;
            while (keyActivate.consumeClick()) {
                boolean activated = !activatable.isActivated(chest);
                ActivateChestPacket.activateChest((Player)client.player, activated);
                new ActivateChestPacket(activated).sendToServer();
            }
        }
    }

    public static void updateKeyMap(Minecraft client) {
        Options settings = client.options;
        if (client.getConnection() == null) {
            return;
        }
        boolean upNow = settings.keyJump.isDown();
        if (upNow != up) {
            up = upNow;
            MIKeyMap.update((Player)client.player, up);
            new UpdateKeysPacket(up).sendToServer();
        }
    }
}

