/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.debug;

import aztech.modern_industrialization.MIConfig;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.api.PipeNetworkManager;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.impl.PipeNetworks;
import aztech.modern_industrialization.stats.PlayerStatisticsData;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

public class DebugCommands {
    private static final SuggestionProvider<CommandSourceStack> PIPE_TYPES_SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggestResource(PipeNetworkType.getTypes().keySet().stream(), (SuggestionsBuilder)builder);

    public static void init() {
        NeoForge.EVENT_BUS.addListener(RegisterCommandsEvent.class, event -> {
            if (!MIConfig.getConfig().enableDebugCommands) {
                return;
            }
            event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"mi").requires(source -> source.hasPermission(4))).then(Commands.literal((String)"pipes").then(((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.literal((String)"clear").executes(ctx -> DebugCommands.clearPipes((CommandSourceStack)ctx.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"pos"))))).then(Commands.literal((String)"add_ghost").then(Commands.argument((String)"pipe_type", (ArgumentType)ResourceLocationArgument.id()).suggests(PIPE_TYPES_SUGGESTION_PROVIDER).executes(ctx -> DebugCommands.addGhostPipe((CommandSourceStack)ctx.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"pos"), ResourceLocationArgument.getId((CommandContext)ctx, (String)"pipe_type")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"machines").then(Commands.literal((String)"claim_all").executes(ctx -> DebugCommands.claimMachines(((CommandSourceStack)ctx.getSource()).getPlayerOrException())))).then(Commands.literal((String)"dump_stats").executes(ctx -> DebugCommands.dumpStats(((CommandSourceStack)ctx.getSource()).getPlayerOrException())))).then(Commands.literal((String)"build_multiblock").then(Commands.argument((String)"controller_pos", (ArgumentType)BlockPosArgument.blockPos()).executes(ctx -> DebugCommands.buildMultiblock((CommandSourceStack)ctx.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"controller_pos")))))));
        });
    }

    private static int clearPipes(CommandSourceStack src, BlockPos pos) {
        if (src.getLevel().getBlockState(pos).is((Block)MIPipes.BLOCK_PIPE.get())) {
            src.getLevel().setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
        PipeNetworks networks = PipeNetworks.get(src.getLevel());
        for (PipeNetworkType type : PipeNetworkType.getTypes().values()) {
            PipeNetworkManager manager = networks.getManager(type);
            if (!manager.hasNode(pos)) continue;
            manager.removeNode(pos);
            src.sendSuccess(() -> Component.literal((String)"Successfully removed pipe of type %s at position %s.".formatted(type.getIdentifier(), pos)), true);
        }
        return 1;
    }

    private static int addGhostPipe(CommandSourceStack src, BlockPos pos, ResourceLocation pipeType) throws CommandSyntaxException {
        PipeNetworkType type = PipeNetworkType.get(pipeType);
        if (type == null) {
            throw new SimpleCommandExceptionType((Message)Component.literal((String)("Unknown pipe network type: " + String.valueOf(pipeType)))).create();
        }
        PipeNetworks networks = PipeNetworks.get(src.getLevel());
        PipeNetworkManager manager = networks.getManager(type);
        if (!manager.hasNode(pos)) {
            manager.addNode(type.getNodeCtor().get(), pos, MIPipes.INSTANCE.getPipeItem((PipeNetworkType)type).defaultData.clone());
            src.sendSuccess(() -> Component.literal((String)"Successfully added pipe of type %s at position %s.".formatted(type.getIdentifier(), pos)), true);
        } else {
            src.sendSuccess(() -> Component.literal((String)"Failed to add pipe of type %s at position %s as it already existed.".formatted(type.getIdentifier(), pos)), true);
        }
        return 1;
    }

    private static int claimMachines(ServerPlayer player) {
        for (ServerLevel level : player.server.getAllLevels()) {
            ServerChunkCache chunkSource = level.getChunkSource();
            for (Long pos : chunkSource.chunkMap.updatingChunkMap.keySet()) {
                LevelChunk chunk = chunkSource.getChunk(ChunkPos.getX((long)pos), ChunkPos.getZ((long)pos), false);
                if (chunk == null) continue;
                for (BlockEntity be : chunk.getBlockEntities().values()) {
                    if (!(be instanceof MachineBlockEntity)) continue;
                    MachineBlockEntity machine = (MachineBlockEntity)be;
                    machine.placedBy.onPlaced((LivingEntity)player);
                    machine.setChanged();
                }
            }
        }
        return 1;
    }

    private static int dumpStats(ServerPlayer player) {
        player.displayClientMessage((Component)Component.literal((String)PlayerStatisticsData.get(player.server).get((Player)player).toTag().toString()), false);
        return 1;
    }

    private static int buildMultiblock(CommandSourceStack src, BlockPos controllerPos) {
        BlockEntity be = src.getLevel().getBlockEntity(controllerPos);
        if (be instanceof MultiblockMachineBlockEntity) {
            MultiblockMachineBlockEntity multiblock = (MultiblockMachineBlockEntity)be;
            ShapeTemplate shape = multiblock.getActiveShape();
            ShapeMatcher shapeMatcher = new ShapeMatcher((Level)src.getLevel(), controllerPos, multiblock.orientation.facingDirection, shape);
            int updatedBlocks = shapeMatcher.buildMultiblock((Level)src.getLevel());
            src.sendSuccess(() -> Component.literal((String)"Successfully built multiblock at position %s. %d blocks updated.".formatted(controllerPos, updatedBlocks)), true);
        } else {
            src.sendFailure((Component)Component.literal((String)"Block at position %s is not a multiblock controller.".formatted(controllerPos)));
        }
        return 1;
    }
}

