/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.usage;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.compat.viewer.abstraction.ViewerCategory;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.nuclear.FluidNuclearComponent;
import aztech.modern_industrialization.nuclear.INeutronBehaviour;
import aztech.modern_industrialization.nuclear.INuclearComponent;
import aztech.modern_industrialization.nuclear.NuclearComponentItem;
import aztech.modern_industrialization.nuclear.NuclearFuel;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import aztech.modern_industrialization.util.Rectangle;
import aztech.modern_industrialization.util.TextHelper;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class ThermalInteractionCategory
extends ViewerCategory<Recipe> {
    private final int centerX;
    private final int px;
    private final int py;

    protected ThermalInteractionCategory() {
        super(Recipe.class, MI.id("thermal_interaction"), (Component)MIText.ThermalInteraction.text(), new ViewerCategory.Icon.Texture(MachineScreen.SLOT_ATLAS, 145, 1), 150, 100);
        this.centerX = this.width / 2;
        this.px = this.centerX - 9;
        this.py = 22;
    }

    @Override
    public void buildWorkstations(ViewerCategory.WorkstationConsumer consumer) {
        consumer.accept("nuclear_reactor");
    }

    @Override
    public void buildRecipes(RecipeManager recipeManager, RegistryAccess registryAccess, Consumer<Recipe> consumer) {
        BuiltInRegistries.ITEM.stream().filter(item -> item instanceof NuclearComponentItem).forEach(item -> {
            NuclearComponentItem component = (NuclearComponentItem)item;
            consumer.accept(new Recipe(component, CategoryType.THERMAL_PROPERTIES));
            if (item instanceof NuclearFuel) {
                consumer.accept(new Recipe(component, CategoryType.NEUTRON_EFFICIENCY));
            }
        });
        for (Fluid fluid : BuiltInRegistries.FLUID) {
            FluidNuclearComponent component;
            if (!fluid.isSource(fluid.defaultFluidState()) || fluid == Fluids.EMPTY || (component = FluidNuclearComponent.get(fluid)) == null) continue;
            consumer.accept(new Recipe(component, CategoryType.THERMAL_PROPERTIES));
        }
        for (final String s : new String[]{"item", "fluid"}) {
            consumer.accept(new Recipe(new INuclearComponent<ItemVariant>(){

                @Override
                public double getHeatConduction() {
                    return 0.01;
                }

                @Override
                public INeutronBehaviour getNeutronBehaviour() {
                    return null;
                }

                @Override
                public int getMaxTemperature() {
                    return 3250;
                }

                @Override
                public ItemVariant getVariant() {
                    return ItemVariant.of((ItemLike)BuiltInRegistries.ITEM.get(MI.id(String.format("nuclear_%s_hatch", s))));
                }
            }, CategoryType.THERMAL_PROPERTIES));
        }
    }

    @Override
    public void buildLayout(Recipe recipe, ViewerCategory.LayoutBuilder builder) {
        builder.inputSlot(this.px, 22).variant((TransferVariant<?>)recipe.nuclearComponent.getVariant());
    }

    @Override
    public void buildWidgets(Recipe recipe, ViewerCategory.WidgetList widgets) {
        widgets.text((Component)(switch (recipe.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> MIText.NeutronProductionTemperatureEffect.text();
            case 1 -> MIText.ThermalInteraction.text();
        }), this.centerX, 8.0f, ViewerCategory.TextAlign.CENTER, false, true, null);
        switch (recipe.type.ordinal()) {
            case 0: {
                NuclearFuel nuclearComponent = (NuclearFuel)recipe.nuclearComponent;
                Rectangle area = new Rectangle(10, 45, this.width - 20, this.height - 50);
                widgets.rectangle(area, -7631989);
                int py = this.height - 14;
                widgets.text((Component)Component.literal((String)"0\u00b0C"), 11.0f, py, ViewerCategory.TextAlign.LEFT, true, false, null);
                widgets.text((Component)Component.literal((String)String.format("%d\u00b0C", nuclearComponent.tempLimitLow)), this.centerX, py, ViewerCategory.TextAlign.CENTER, true, false, null);
                widgets.text((Component)Component.literal((String)String.format("%d\u00b0C", nuclearComponent.tempLimitHigh)), this.width - 10, py, ViewerCategory.TextAlign.RIGHT, true, false, null);
                widgets.drawable(guiGraphics -> {
                    int i;
                    Screen helper = Minecraft.getInstance().screen;
                    for (i = 1; i < area.w() / 2; ++i) {
                        guiGraphics.blit(MachineScreen.SLOT_ATLAS, area.x() + i, area.y() + 4, 0, 255, 1, 1);
                    }
                    for (i = area.w() / 2; i < area.w() - 1; ++i) {
                        double f = ((double)i - (double)area.w() / 2.0) / ((double)area.w() - (double)area.w() / 2.0);
                        int y = (int)((1.0 - f) * (double)(area.y() + 4) + f * (double)(area.y() + area.h() - 14));
                        guiGraphics.blit(MachineScreen.SLOT_ATLAS, area.x() + i, y, 0, 255, 1, 1);
                    }
                });
                widgets.text((Component)Component.literal((String)String.format("%.1f", nuclearComponent.neutronMultiplicationFactor)), 11.0f, area.y() + 2, ViewerCategory.TextAlign.LEFT, false, false, null);
                widgets.text((Component)Component.literal((String)"0"), this.width - 10, py - 10, ViewerCategory.TextAlign.RIGHT, false, false, null);
                break;
            }
            case 1: {
                INuclearComponent<?> nuclearComponent = recipe.nuclearComponent;
                int centerX = this.width / 2;
                int centerY = this.height / 2;
                MutableComponent heatConduction = MIText.HeatConduction.text(String.format("%d", (int)(1000.0 * nuclearComponent.getHeatConduction()))).setStyle(TextHelper.HEAT_CONDUCTION);
                widgets.text((Component)heatConduction, centerX, centerY, ViewerCategory.TextAlign.CENTER, false, false, null);
                int maxTemperature = nuclearComponent.getMaxTemperature();
                if (maxTemperature == Integer.MAX_VALUE) break;
                MutableComponent maxTemp = MIText.MaxTemp.text(maxTemperature).setStyle(TextHelper.MAX_TEMP_TEXT);
                widgets.text((Component)maxTemp, centerX, centerY + 12, ViewerCategory.TextAlign.CENTER, false, false, null);
            }
        }
    }

    protected record Recipe(INuclearComponent<?> nuclearComponent, CategoryType type) {
    }

    static enum CategoryType {
        NEUTRON_EFFICIENCY,
        THERMAL_PROPERTIES;

    }
}

