/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.impl.jei;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.compat.viewer.abstraction.ViewerCategory;
import aztech.modern_industrialization.compat.viewer.impl.jei.JeiSlotUtil;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

class ViewerCategoryJei<D>
implements IRecipeCategory<D> {
    private final IJeiHelpers helpers;
    public final ViewerCategory<D> wrapped;
    public final RecipeType<D> recipeType;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable itemSlot;
    private final IDrawable fluidSlot;

    public ViewerCategoryJei(IJeiHelpers helpers, final ViewerCategory<D> wrapped) {
        IDrawable iDrawable;
        this.helpers = helpers;
        this.wrapped = wrapped;
        this.recipeType = RecipeType.create((String)wrapped.id.getNamespace(), (String)wrapped.id.getPath(), wrapped.dataClass);
        this.background = helpers.getGuiHelper().createBlankDrawable(wrapped.width - 8, wrapped.height - 8);
        ViewerCategory.Icon icon = wrapped.icon;
        if (icon instanceof ViewerCategory.Icon.Stack) {
            ViewerCategory.Icon.Stack stack = (ViewerCategory.Icon.Stack)icon;
            iDrawable = helpers.getGuiHelper().createDrawableItemStack(stack.stack());
        } else {
            iDrawable = new IDrawable(){

                public int getWidth() {
                    return 18;
                }

                public int getHeight() {
                    return 18;
                }

                public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
                    ViewerCategory.Icon.Texture texture = (ViewerCategory.Icon.Texture)wrapped.icon;
                    guiGraphics.blit(texture.loc(), xOffset - 1, yOffset - 1, 0, (float)texture.u(), (float)texture.v(), 18, 18, 256, 256);
                }
            };
        }
        this.icon = iDrawable;
        this.itemSlot = helpers.getGuiHelper().getSlotDrawable();
        this.fluidSlot = helpers.getGuiHelper().createDrawable(MachineScreen.SLOT_ATLAS, 18, 0, 18, 18);
    }

    public RecipeType<D> getRecipeType() {
        return this.recipeType;
    }

    public Component getTitle() {
        return this.wrapped.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(final IRecipeLayoutBuilder builder, D recipe, IFocusGroup focuses) {
        this.wrapped.buildLayout(recipe, new ViewerCategory.LayoutBuilder(){

            @Override
            public ViewerCategory.SlotBuilder inputSlot(int x, int y) {
                return this.slot(RecipeIngredientRole.INPUT, x, y);
            }

            @Override
            public ViewerCategory.SlotBuilder outputSlot(int x, int y) {
                return this.slot(RecipeIngredientRole.OUTPUT, x, y);
            }

            @Override
            public void invisibleOutput(ItemStack stack) {
                builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(stack);
            }

            private ViewerCategory.SlotBuilder slot(RecipeIngredientRole role, int x, int y) {
                final IRecipeSlotBuilder slotBuilder = builder.addSlot(role, x - 4, y - 4);
                slotBuilder.setBackground(ViewerCategoryJei.this.itemSlot, -1, -1);
                return new ViewerCategory.SlotBuilder(){

                    @Override
                    public ViewerCategory.SlotBuilder variant(TransferVariant<?> variant) {
                        if (variant instanceof ItemVariant) {
                            ItemVariant item = (ItemVariant)variant;
                            this.item(item.toStack());
                        } else if (variant instanceof FluidVariant) {
                            FluidVariant fluid = (FluidVariant)variant;
                            if (!fluid.isBlank()) {
                                slotBuilder.addFluidStack(fluid.getFluid(), 1L, fluid.getComponentsPatch());
                            }
                            JeiSlotUtil.overrideFluidRenderer(slotBuilder);
                            slotBuilder.setBackground(ViewerCategoryJei.this.fluidSlot, -1, -1);
                        } else {
                            throw new IllegalArgumentException("Unknown variant type: " + String.valueOf(variant.getClass()));
                        }
                        return this;
                    }

                    @Override
                    public ViewerCategory.SlotBuilder fluid(FluidVariant fluid, long amount, float probability) {
                        slotBuilder.addFluidStack(fluid.getFluid(), amount, fluid.getComponentsPatch());
                        JeiSlotUtil.overrideFluidRenderer(slotBuilder);
                        JeiSlotUtil.customizeTooltip(slotBuilder, probability);
                        slotBuilder.setBackground(ViewerCategoryJei.this.fluidSlot, -1, -1);
                        return this;
                    }

                    private ViewerCategory.SlotBuilder items(List<ItemStack> stacks, float probability) {
                        slotBuilder.addItemStacks(stacks);
                        JeiSlotUtil.customizeTooltip(slotBuilder, probability);
                        return this;
                    }

                    @Override
                    public ViewerCategory.SlotBuilder item(ItemStack stack, float probability) {
                        return this.items(List.of(stack), probability);
                    }

                    @Override
                    public ViewerCategory.SlotBuilder ingredient(Ingredient ingredient, long amount, float probability) {
                        return this.items(Stream.of(ingredient.getItems()).map(i -> {
                            ItemStack cp = i.copy();
                            cp.setCount((int)amount);
                            return cp;
                        }).toList(), probability);
                    }

                    @Override
                    public ViewerCategory.SlotBuilder removeBackground() {
                        slotBuilder.setBackground((IDrawable)ViewerCategoryJei.this.helpers.getGuiHelper().createBlankDrawable(0, 0), 0, 0);
                        return this;
                    }

                    @Override
                    public ViewerCategory.SlotBuilder markCatalyst() {
                        return this;
                    }
                };
            }
        });
    }

    public void draw(D recipe, IRecipeSlotsView recipeSlotsView, final GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.pose().translate(-4.0f, -4.0f, 0.0f);
        this.wrapped.buildWidgets(recipe, new ViewerCategory.WidgetList(){

            @Override
            public void text(Component text, float x, float y, ViewerCategory.TextAlign align, boolean shadow, boolean overrideColor, @Nullable Component tooltip) {
                Font font = Minecraft.getInstance().font;
                int width = font.width((FormattedText)text);
                float alignedX = switch (align) {
                    default -> throw new MatchException(null, null);
                    case ViewerCategory.TextAlign.LEFT -> x;
                    case ViewerCategory.TextAlign.CENTER -> x - (float)width / 2.0f;
                    case ViewerCategory.TextAlign.RIGHT -> x - (float)width;
                };
                guiGraphics.drawString(font, text, (int)alignedX, (int)y, overrideColor ? -12566464 : -1, shadow);
            }

            @Override
            public void arrow(int x, int y) {
                this.texture(MI.id("textures/gui/jei/arrow.png"), x, y, 0, 17, 24, 17);
            }

            @Override
            public void texture(ResourceLocation loc, int x, int y, int u, int v, int width, int height) {
                IDrawableStatic drawable = ViewerCategoryJei.this.helpers.getGuiHelper().createDrawable(loc, u, v, width, height);
                drawable.draw(guiGraphics, x, y);
            }

            @Override
            public void drawable(Consumer<GuiGraphics> widget) {
                widget.accept(guiGraphics);
            }

            @Override
            public void item(double x, double y, double w, double h, ItemLike item) {
                guiGraphics.pose().pushPose();
                IDrawable drawable = ViewerCategoryJei.this.helpers.getGuiHelper().createDrawableItemStack(item.asItem().getDefaultInstance());
                guiGraphics.pose().translate(x, y, 0.0);
                guiGraphics.pose().scale((float)w / 16.0f, (float)h / 16.0f, 0.0f);
                drawable.draw(guiGraphics);
                guiGraphics.pose().popPose();
            }

            @Override
            public void tooltip(int x, int y, int w, int h, List<Component> tooltip) {
            }
        });
    }

    public List<Component> getTooltipStrings(D recipe, IRecipeSlotsView recipeSlotsView, double jeiMouseX, double jeiMouseY) {
        final double mouseX = jeiMouseX + 4.0;
        final double mouseY = jeiMouseY + 4.0;
        final ArrayList<Component> tooltips = new ArrayList<Component>();
        this.wrapped.buildWidgets(recipe, new ViewerCategory.WidgetList(){

            @Override
            public void text(Component text, float x, float y, ViewerCategory.TextAlign align, boolean shadow, boolean overrideColor, @Nullable Component tooltip) {
                if (tooltip != null) {
                    Font font = Minecraft.getInstance().font;
                    if ((double)x <= mouseX && (double)y <= mouseY && mouseX <= (double)(x + (float)font.width((FormattedText)text))) {
                        Objects.requireNonNull(font);
                        if (mouseY <= (double)(y + 9.0f)) {
                            tooltips.add(tooltip);
                        }
                    }
                }
            }

            @Override
            public void arrow(int x, int y) {
            }

            @Override
            public void texture(ResourceLocation loc, int x, int y, int u, int v, int width, int height) {
            }

            @Override
            public void drawable(Consumer<GuiGraphics> widget) {
            }

            @Override
            public void item(double x, double y, double w, double h, ItemLike item) {
            }

            @Override
            public void tooltip(int x, int y, int w, int h, List<Component> tooltip) {
                if ((double)x <= mouseX && (double)y <= mouseY && mouseX <= (double)(x + w) && mouseY <= (double)(y + h)) {
                    tooltips.addAll(tooltip);
                }
            }
        });
        return tooltips;
    }
}

