/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.impl.jei;

import aztech.modern_industrialization.compat.rei.machines.ReiMachineRecipes;
import aztech.modern_industrialization.compat.viewer.impl.MachineScreenPredicateTest;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.machines.gui.MachineMenuClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.util.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

record MachineGuiContainerHandler(IIngredientManager ingredientManager, Supplier<IJeiRuntime> jeiRuntime) implements IGuiContainerHandler<MachineScreen>
{
    public List<Rect2i> getGuiExtraAreas(MachineScreen screen) {
        return screen.getExtraBoxes().stream().map(r -> new Rect2i(r.x(), r.y(), r.w(), r.h())).toList();
    }

    public Collection<IGuiClickableArea> getGuiClickableAreas(MachineScreen screen, double guiMouseX, double guiMouseY) {
        MachineMenuClient screenHandler = (MachineMenuClient)screen.getMenu();
        String blockId = screenHandler.guiParams.blockId;
        List categories = ReiMachineRecipes.machineToClickAreaCategory.getOrDefault(blockId, Collections.emptyList());
        final Rectangle rectangle = ReiMachineRecipes.machineToClickArea.get(blockId);
        if (categories.size() > 0 && rectangle != null && MachineGuiContainerHandler.contains(rectangle, guiMouseX, guiMouseY)) {
            boolean foundSome = false;
            final ArrayList<RecipeType> result = new ArrayList<RecipeType>();
            for (ReiMachineRecipes.ClickAreaCategory cac : categories) {
                IRecipeManager recipeManager;
                RecipeType recipeType;
                if (!MachineScreenPredicateTest.test(cac.predicate, screen) || (recipeType = (RecipeType)(recipeManager = this.jeiRuntime.get().getRecipeManager()).getRecipeType(cac.category).orElse(null)) == null || !recipeManager.createRecipeLookup(recipeType).get().anyMatch(t -> true)) continue;
                result.add(recipeType);
                foundSome = true;
            }
            if (foundSome) {
                return List.of(new IGuiClickableArea(){

                    public Rect2i getArea() {
                        return new Rect2i(rectangle.x(), rectangle.y(), rectangle.w(), rectangle.h());
                    }

                    public void onClick(IFocusFactory focusFactory, IRecipesGui recipesGui) {
                        recipesGui.showTypes((List)result);
                    }
                });
            }
        }
        return Collections.emptyList();
    }

    public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(MachineScreen screen, double mouseX, double mouseY) {
        Slot slot = screen.getFocusedSlot();
        Object maybeIngredient = this.getIngredientUnderMouse(slot);
        return Optional.ofNullable(maybeIngredient).map(arg_0 -> ((IIngredientManager)this.ingredientManager).createTypedIngredient(arg_0)).flatMap(ingredient -> ingredient.map(MachineGuiContainerHandler.slotArea(screen, slot)));
    }

    @Nullable
    public Object getIngredientUnderMouse(Slot slot) {
        ConfigurableItemStack stack;
        if (slot instanceof ConfigurableFluidStack.ConfigurableFluidSlot) {
            Fluid fluid;
            IPlatformFluidHelper fluidHelper = this.jeiRuntime.get().getJeiHelpers().getPlatformFluidHelper();
            ConfigurableFluidStack stack2 = ((ConfigurableFluidStack.ConfigurableFluidSlot)slot).getConfStack();
            if (stack2.getAmount() > 0L) {
                FluidVariant fluid2 = (FluidVariant)stack2.getResource();
                if (!fluid2.isBlank()) {
                    return fluid2.toStack(1);
                }
            } else if (stack2.getLockedInstance() != null && (fluid = (Fluid)stack2.getLockedInstance()) != null) {
                return new FluidStack(fluid, 1);
            }
        } else if (slot instanceof ConfigurableItemStack.ConfigurableItemSlot && (stack = ((ConfigurableItemStack.ConfigurableItemSlot)slot).getConfStack()).getLockedInstance() != null) {
            return ((Item)stack.getLockedInstance()).getDefaultInstance();
        }
        return null;
    }

    private static <T> Function<ITypedIngredient<T>, IClickableIngredient<T>> slotArea(MachineScreen screen, Slot slot) {
        Rect2i area = new Rect2i(screen.x() + slot.x, screen.y() + slot.y, 16, 16);
        return ing -> new IClickableIngredient<T>((ITypedIngredient)ing, area){
            final /* synthetic */ ITypedIngredient val$ing;
            final /* synthetic */ Rect2i val$area;
            {
                this.val$ing = iTypedIngredient;
                this.val$area = rect2i;
            }

            public ITypedIngredient<T> getTypedIngredient() {
                return this.val$ing;
            }

            public Rect2i getArea() {
                return this.val$area;
            }
        };
    }

    private static boolean contains(Rectangle rectangle, double x, double y) {
        return (double)rectangle.x() <= x && x <= (double)(rectangle.x() + rectangle.w()) && (double)rectangle.y() <= y && y <= (double)(rectangle.y() + rectangle.h());
    }
}

