/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.rei.machines;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.compat.rei.machines.MachineCategoryParams;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.util.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;

public class ReiMachineRecipes {
    public static final Map<String, MachineCategoryParams> categories = new TreeMap<String, MachineCategoryParams>();
    public static final Map<String, List<ClickAreaCategory>> machineToClickAreaCategory = new HashMap<String, List<ClickAreaCategory>>();
    public static final Map<String, Rectangle> machineToClickArea = new HashMap<String, Rectangle>();
    public static final List<Tuple<String, ShapeTemplate>> multiblockShapes = new ArrayList<Tuple<String, ShapeTemplate>>();

    public static void registerCategory(String machine, MachineCategoryParams params) {
        if (categories.put(machine, params) != null) {
            throw new IllegalStateException("Machine was already registered: " + machine);
        }
    }

    public static void registerWorkstation(String machine, ResourceLocation item) {
        MachineCategoryParams params = categories.get(machine);
        if (params == null) {
            throw new NullPointerException("Machine params may not be null for machine " + machine);
        }
        params.workstations.add(item);
    }

    public static void registerRecipeCategoryForMachine(String machine, String category) {
        ReiMachineRecipes.registerRecipeCategoryForMachine(machine, category, MachineScreenPredicate.ANY);
    }

    public static void registerRecipeCategoryForMachine(String machine, String category, MachineScreenPredicate screenPredicate) {
        machineToClickAreaCategory.computeIfAbsent(machine, k -> new ArrayList()).add(new ClickAreaCategory(MI.id(category), screenPredicate));
    }

    public static void registerMachineClickArea(String machine, Rectangle clickArea) {
        machineToClickArea.put(machine, clickArea);
    }

    public static void registerMultiblockShape(String machine, ShapeTemplate shapeTemplate) {
        multiblockShapes.add((Tuple<String, ShapeTemplate>)new Tuple((Object)machine, (Object)shapeTemplate));
    }

    public static enum MachineScreenPredicate {
        ANY,
        MULTIBLOCK;

    }

    public static class ClickAreaCategory {
        public final ResourceLocation category;
        public final MachineScreenPredicate predicate;

        ClickAreaCategory(ResourceLocation category, MachineScreenPredicate predicate) {
            this.category = category;
            this.predicate = predicate;
        }
    }
}

