/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.api.energy;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIConfig;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import dev.technici4n.grandpower.api.DelegatingEnergyStorage;
import dev.technici4n.grandpower.api.ILongEnergyStorage;
import dev.technici4n.grandpower.api.LimitingEnergyStorage;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.ApiStatus;

public class EnergyApi {
    public static final BlockCapability<MIEnergyStorage, Direction> SIDED = BlockCapability.createSided((ResourceLocation)MI.id("sided_mi_energy_storage"), MIEnergyStorage.class);
    public static final ItemCapability<ILongEnergyStorage, Void> ITEM = ItemCapability.createVoid((ResourceLocation)MI.id("energy_storage"), ILongEnergyStorage.class);
    private static final ThreadLocal<Boolean> IN_COMPAT = ThreadLocal.withInitial(() -> false);
    public static final MIEnergyStorage CREATIVE = new MIEnergyStorage.NoInsert(){

        @Override
        public boolean canConnect(CableTier cableTier) {
            return true;
        }

        public long extract(long maxAmount, boolean simulate) {
            return maxAmount;
        }

        public boolean canExtract() {
            return true;
        }

        public long getAmount() {
            return Long.MAX_VALUE;
        }

        public long getCapacity() {
            return Long.MAX_VALUE;
        }
    };
    public static final MIEnergyStorage EMPTY = new EmptyStorage();

    @ApiStatus.Internal
    public static void init(RegisterCapabilitiesEvent event, Block[] allBlocks, Item[] allItems) {
        if (MIConfig.getConfig().enableBidirectionalEnergyCompat) {
            event.registerBlock(ILongEnergyStorage.BLOCK, (world, pos, state, blockEntity, context) -> {
                if (IN_COMPAT.get().booleanValue()) {
                    return null;
                }
                IN_COMPAT.set(true);
                try {
                    ILongEnergyStorage iLongEnergyStorage = (ILongEnergyStorage)world.getCapability(SIDED, pos, state, blockEntity, context);
                    return iLongEnergyStorage;
                }
                finally {
                    IN_COMPAT.set(false);
                }
            }, allBlocks);
            event.registerBlock(SIDED, (world, pos, state, blockEntity, context) -> {
                if (IN_COMPAT.get().booleanValue()) {
                    return null;
                }
                IN_COMPAT.set(true);
                try {
                    ILongEnergyStorage trStorage = (ILongEnergyStorage)world.getCapability(ILongEnergyStorage.BLOCK, pos, state, blockEntity, context);
                    WrappedTrStorage wrappedTrStorage = trStorage == null ? null : new WrappedTrStorage(trStorage);
                    return wrappedTrStorage;
                }
                finally {
                    IN_COMPAT.set(false);
                }
            }, allBlocks);
            event.registerItem(ILongEnergyStorage.ITEM, (stack, ignored) -> {
                if (IN_COMPAT.get().booleanValue()) {
                    return null;
                }
                IN_COMPAT.set(true);
                try {
                    ILongEnergyStorage iLongEnergyStorage = (ILongEnergyStorage)stack.getCapability(ITEM);
                    return iLongEnergyStorage;
                }
                finally {
                    IN_COMPAT.set(false);
                }
            }, (ItemLike[])allItems);
            event.registerItem(ITEM, (stack, ctx) -> {
                if (IN_COMPAT.get().booleanValue()) {
                    return null;
                }
                IN_COMPAT.set(true);
                try {
                    ILongEnergyStorage iLongEnergyStorage = (ILongEnergyStorage)stack.getCapability(ILongEnergyStorage.ITEM);
                    return iLongEnergyStorage;
                }
                finally {
                    IN_COMPAT.set(false);
                }
            }, (ItemLike[])allItems);
        } else {
            event.registerBlock(SIDED, (world, pos, state, blockEntity, context) -> {
                ILongEnergyStorage trStorage = (ILongEnergyStorage)world.getCapability(ILongEnergyStorage.BLOCK, pos, state, blockEntity, context);
                return trStorage == null || !trStorage.canReceive() ? null : new InsertOnlyTrStorage(trStorage);
            }, allBlocks);
            event.registerItem(ITEM, (stack, ctx) -> {
                if (IN_COMPAT.get().booleanValue()) {
                    return null;
                }
                IN_COMPAT.set(true);
                try {
                    ILongEnergyStorage trStorage = (ILongEnergyStorage)stack.getCapability(ILongEnergyStorage.ITEM);
                    LimitingEnergyStorage limitingEnergyStorage = trStorage == null || !trStorage.canReceive() ? null : new LimitingEnergyStorage(trStorage, Long.MAX_VALUE, 0L);
                    return limitingEnergyStorage;
                }
                finally {
                    IN_COMPAT.set(false);
                }
            }, (ItemLike[])allItems);
            event.registerItem(ILongEnergyStorage.ITEM, (stack, ctx) -> {
                if (IN_COMPAT.get().booleanValue()) {
                    return null;
                }
                IN_COMPAT.set(true);
                try {
                    ILongEnergyStorage miStorage = (ILongEnergyStorage)stack.getCapability(ITEM);
                    LimitingEnergyStorage limitingEnergyStorage = miStorage == null || !miStorage.canExtract() ? null : new LimitingEnergyStorage(miStorage, 0L, Long.MAX_VALUE);
                    return limitingEnergyStorage;
                }
                finally {
                    IN_COMPAT.set(false);
                }
            }, (ItemLike[])allItems);
        }
    }

    private record InsertOnlyTrStorage(ILongEnergyStorage trStorage) implements MIEnergyStorage.NoExtract
    {
        @Override
        public boolean canConnect(CableTier cableTier) {
            return true;
        }

        public long receive(long maxAmount, boolean simulate) {
            return this.trStorage.receive(maxAmount, simulate);
        }

        public boolean canReceive() {
            return this.trStorage.canReceive();
        }

        public long getAmount() {
            return this.trStorage.getAmount();
        }

        public long getCapacity() {
            return this.trStorage.getCapacity();
        }
    }

    private static class WrappedTrStorage
    extends DelegatingEnergyStorage
    implements MIEnergyStorage {
        public WrappedTrStorage(ILongEnergyStorage backingStorage) {
            super(backingStorage);
        }

        @Override
        public boolean canConnect(CableTier cableTier) {
            return true;
        }
    }

    private static class EmptyStorage
    implements MIEnergyStorage.NoInsert,
    MIEnergyStorage.NoExtract {
        private EmptyStorage() {
        }

        @Override
        public boolean canConnect(CableTier cableTier) {
            return false;
        }

        public long getAmount() {
            return 0L;
        }

        public long getCapacity() {
            return 0L;
        }
    }
}

