/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.blocks.creativestorageunit.CreativeStorageUnitBlockEntity;
import aztech.modern_industrialization.blocks.forgehammer.ForgeHammerRecipe;
import aztech.modern_industrialization.blocks.forgehammer.ForgeHammerScreenHandler;
import aztech.modern_industrialization.blocks.storage.barrel.CreativeBarrelBlockEntity;
import aztech.modern_industrialization.blocks.storage.tank.creativetank.CreativeTankBlockEntity;
import aztech.modern_industrialization.compat.ae2.AECompatCondition;
import aztech.modern_industrialization.machines.gui.MachineMenuCommon;
import aztech.modern_industrialization.proxy.CommonProxy;
import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.MapCodec;
import java.util.Comparator;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class MIRegistries {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"modern_industrialization");
    public static final Supplier<BlockEntityType<CreativeBarrelBlockEntity>> CREATIVE_BARREL_BE = BLOCK_ENTITIES.register("creative_barrel", () -> BlockEntityType.Builder.of(CreativeBarrelBlockEntity::new, (Block[])new Block[]{MIBlock.CREATIVE_BARREL.get()}).build(null));
    public static final Supplier<BlockEntityType<CreativeTankBlockEntity>> CREATIVE_TANK_BE = BLOCK_ENTITIES.register("creative_tank", () -> BlockEntityType.Builder.of(CreativeTankBlockEntity::new, (Block[])new Block[]{MIBlock.CREATIVE_TANK.get()}).build(null));
    public static final Supplier<BlockEntityType<CreativeStorageUnitBlockEntity>> CREATIVE_STORAGE_UNIT_BE = BLOCK_ENTITIES.register("creative_storage_unit", () -> BlockEntityType.Builder.of(CreativeStorageUnitBlockEntity::new, (Block[])new Block[]{MIBlock.CREATIVE_STORAGE_UNIT.get()}).build(null));
    public static final DeferredRegister<MapCodec<? extends ICondition>> CONDITIONS = DeferredRegister.create((Registry)NeoForgeRegistries.CONDITION_SERIALIZERS, (String)"modern_industrialization");
    public static final Supplier<MapCodec<AECompatCondition>> AE_COMPAT_CONDITION = CONDITIONS.register("ae_compat_loaded", () -> AECompatCondition.CODEC);
    public static final DeferredRegister<MenuType<?>> MENUS = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"modern_industrialization");
    public static final Supplier<MenuType<ForgeHammerScreenHandler>> FORGE_HAMMER_MENU = MENUS.register("forge_hammer", () -> new MenuType(ForgeHammerScreenHandler::new, FeatureFlags.VANILLA_SET));
    public static final Supplier<MenuType<? extends MachineMenuCommon>> MACHINE_MENU = () -> ((DeferredHolder)MENUS.register("machine", () -> IMenuTypeExtension.create(CommonProxy.INSTANCE::createClientMachineMenu))).get();
    public static final DeferredRegister<PoiType> POIS = DeferredRegister.create((ResourceKey)Registries.POINT_OF_INTEREST_TYPE, (String)"modern_industrialization");
    public static final DeferredHolder<PoiType, PoiType> INDUSTRIALIST_POI = POIS.register("industrialist", () -> new PoiType(Set.copyOf(MIBlock.FORGE_HAMMER.asBlock().getStateDefinition().getPossibleStates()), 1, 1));
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"modern_industrialization");
    public static final Supplier<RecipeSerializer<ForgeHammerRecipe>> FORGE_HAMMER_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("forge_hammer", ForgeHammerRecipe.Serializer::new);
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)"modern_industrialization");
    public static final Supplier<RecipeType<ForgeHammerRecipe>> FORGE_HAMMER_RECIPE_TYPE = RECIPE_TYPES.register("forge_hammer", () -> RecipeType.simple((ResourceLocation)MI.id("forge_hammer")));
    private static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"modern_industrialization");
    private static final Supplier<CreativeModeTab> TAB = TABS.register("general", () -> CreativeModeTab.builder().title((Component)MIText.ModernIndustrialization.text()).icon(() -> MIBlock.FORGE_HAMMER.asItem().getDefaultInstance()).displayItems((params, output) -> MIItem.ITEM_DEFINITIONS.values().stream().sorted(Comparator.comparing(e -> e.sortOrder)).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0))).build());
    public static final DeferredRegister<VillagerProfession> VILLAGER_PROFESSIONS = DeferredRegister.create((ResourceKey)Registries.VILLAGER_PROFESSION, (String)"modern_industrialization");
    public static final Supplier<VillagerProfession> INDUSTRIALIST = VILLAGER_PROFESSIONS.register("industrialist", () -> new VillagerProfession(INDUSTRIALIST_POI.getId().toString(), e -> e.is(INDUSTRIALIST_POI.getId()), e -> e.is(INDUSTRIALIST_POI.getId()), ImmutableSet.of(), ImmutableSet.of(), SoundEvents.VILLAGER_WORK_TOOLSMITH));

    static void init(IEventBus modBus) {
        BLOCK_ENTITIES.register(modBus);
        CONDITIONS.register(modBus);
        MENUS.register(modBus);
        POIS.register(modBus);
        RECIPE_SERIALIZERS.register(modBus);
        RECIPE_TYPES.register(modBus);
        TABS.register(modBus);
        VILLAGER_PROFESSIONS.register(modBus);
    }
}

