/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization;

import aztech.modern_industrialization.MIAdvancementTriggers;
import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MICapabilities;
import aztech.modern_industrialization.MIComponents;
import aztech.modern_industrialization.MIConfig;
import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MIRegistries;
import aztech.modern_industrialization.MITags;
import aztech.modern_industrialization.MIVillager;
import aztech.modern_industrialization.api.datamaps.MIDataMaps;
import aztech.modern_industrialization.blocks.WrenchableBlockEntity;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelBlock;
import aztech.modern_industrialization.compat.ae2.MIAEAddon;
import aztech.modern_industrialization.compat.kubejs.KubeJSProxy;
import aztech.modern_industrialization.datagen.MIDatagenServer;
import aztech.modern_industrialization.debug.DebugCommands;
import aztech.modern_industrialization.definition.BlockDefinition;
import aztech.modern_industrialization.definition.ItemDefinition;
import aztech.modern_industrialization.items.SteamDrillHooks;
import aztech.modern_industrialization.items.armor.MIArmorEffects;
import aztech.modern_industrialization.items.armor.MIArmorMaterials;
import aztech.modern_industrialization.items.armor.MIKeyMap;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.init.MultiblockHatches;
import aztech.modern_industrialization.machines.init.MultiblockMachines;
import aztech.modern_industrialization.machines.init.SingleBlockCraftingMachines;
import aztech.modern_industrialization.machines.init.SingleBlockSpecialMachines;
import aztech.modern_industrialization.machines.multiblocks.world.ChunkEventListeners;
import aztech.modern_industrialization.materials.MIMaterials;
import aztech.modern_industrialization.misc.autotest.MIAutoTesting;
import aztech.modern_industrialization.misc.guidebook.GuidebookEvents;
import aztech.modern_industrialization.network.MIPackets;
import aztech.modern_industrialization.nuclear.FluidNuclearComponent;
import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.proxy.CommonProxy;
import aztech.modern_industrialization.stats.PlayerStatisticsData;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="modern_industrialization")
public class MI {
    public static final String ID = "modern_industrialization";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Modern Industrialization");

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)path);
    }

    public MI(IEventBus modBus) {
        MIAdvancementTriggers.init(modBus);
        MIComponents.init(modBus);
        MIFluids.init(modBus);
        MIBlock.init(modBus);
        MIItem.init(modBus);
        MIRegistries.init(modBus);
        MIArmorMaterials.init(modBus);
        MIMaterials.init();
        MIMachineRecipeTypes.init();
        SingleBlockCraftingMachines.init();
        SingleBlockSpecialMachines.init();
        MultiblockHatches.init();
        MultiblockMachines.init();
        KubeJSProxy.instance.fireRegisterMachinesEvent();
        MIPipes.INSTANCE.setup();
        CommonProxy.initEvents();
        ChunkEventListeners.init();
        DebugCommands.init();
        GuidebookEvents.init();
        MIArmorEffects.init();
        if (System.getProperty("modern_industrialization.autoTest") != null) {
            MIAutoTesting.init();
        }
        NeoForge.EVENT_BUS.addListener(PlayerEvent.PlayerChangedDimensionEvent.class, event -> MIKeyMap.clear(event.getEntity()));
        NeoForge.EVENT_BUS.addListener(PlayerEvent.PlayerLoggedOutEvent.class, event -> MIKeyMap.clear(event.getEntity()));
        NeoForge.EVENT_BUS.addListener(PlayerEvent.PlayerLoggedInEvent.class, event -> {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            MinecraftServer server = Objects.requireNonNull(player.getServer());
            PlayerStatisticsData.get(server).get((Player)player).onPlayerJoin(player);
        });
        NeoForge.EVENT_BUS.addListener(VillagerTradesEvent.class, MIVillager::init);
        NeoForge.EVENT_BUS.addListener(PlayerInteractEvent.RightClickBlock.class, event -> {
            WrenchableBlockEntity wrenchable;
            BlockEntity patt0$temp;
            if (event.getUseBlock().isFalse()) {
                return;
            }
            InteractionHand hand = event.getHand();
            BlockHitResult hitResult = event.getHitVec();
            Player player = event.getEntity();
            Level world = event.getLevel();
            if (player.isSpectator() || !event.getLevel().mayInteract(player, hitResult.getBlockPos())) {
                return;
            }
            if (player.getItemInHand(hand).is(MITags.WRENCHES) && (patt0$temp = world.getBlockEntity(hitResult.getBlockPos())) instanceof WrenchableBlockEntity && (wrenchable = (WrenchableBlockEntity)patt0$temp).useWrench(player, hand, hitResult)) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.sidedSuccess((boolean)world.isClientSide()));
            }
        });
        BarrelBlock.setupBarrelEvents();
        SteamDrillHooks.init();
        modBus.addListener(FMLCommonSetupEvent.class, event -> {
            MIBlock.BLOCK_DEFINITIONS.values().forEach(BlockDefinition::onRegister);
            MIItem.ITEM_DEFINITIONS.values().forEach(ItemDefinition::onRegister);
            FluidNuclearComponent.init();
        });
        modBus.addListener(GatherDataEvent.class, event -> MIDatagenServer.configure(event.getGenerator(), event.getExistingFileHelper(), event.getLookupProvider(), event.includeServer(), false));
        modBus.addListener(RegisterCapabilitiesEvent.class, MICapabilities::init);
        modBus.addListener(RegisterPayloadHandlersEvent.class, MIPackets::init);
        modBus.addListener(RegisterDataMapTypesEvent.class, event -> {
            event.register(MIDataMaps.FLUID_FUELS);
            event.register(MIDataMaps.ITEM_PIPE_UPGRADES);
        });
        if (MIConfig.loadAe2Compat()) {
            MIAEAddon.init(modBus);
        }
        LOGGER.info("Modern Industrialization setup done!");
    }
}

