/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbchunks.api.ClaimResult;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.client.gui.ChunkScreen;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import java.util.EnumMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public record ChunkChangeResponsePacket(int totalChunks, int changedChunks, EnumMap<ClaimResult.StandardProblem, Integer> problems) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ChunkChangeResponsePacket> TYPE = new CustomPacketPayload.Type(FTBChunksAPI.rl("chunk_change_response_packet"));
    public static final StreamCodec<FriendlyByteBuf, ChunkChangeResponsePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ChunkChangeResponsePacket::totalChunks, (StreamCodec)ByteBufCodecs.VAR_INT, ChunkChangeResponsePacket::changedChunks, (StreamCodec)ByteBufCodecs.map(i -> new EnumMap(ClaimResult.StandardProblem.class), (StreamCodec)NetworkHelper.enumStreamCodec(ClaimResult.StandardProblem.class), (StreamCodec)ByteBufCodecs.VAR_INT), ChunkChangeResponsePacket::problems, ChunkChangeResponsePacket::new);

    public CustomPacketPayload.Type<ChunkChangeResponsePacket> type() {
        return TYPE;
    }

    public static void handle(ChunkChangeResponsePacket message, NetworkManager.PacketContext context) {
        context.queue(() -> ChunkScreen.notifyChunkUpdates(message.totalChunks, message.changedChunks, message.problems));
    }
}

