/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.util.UndashedUuid;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.api.ChunkTeamData;
import dev.ftb.mods.ftbchunks.api.ClaimResult;
import dev.ftb.mods.ftbchunks.api.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.ChunkTeamDataImpl;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkImpl;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManagerImpl;
import dev.ftb.mods.ftbchunks.net.AddWaypointPacket;
import dev.ftb.mods.ftbchunks.net.LoadedChunkViewPacket;
import dev.ftb.mods.ftbchunks.net.RequestBlockColorPacket;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import dev.ftb.mods.ftbteams.data.TeamArgumentProvider;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntMaps;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.UUID;
import java.util.function.ToIntBiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ColorArgument;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FTBChunksCommands {
    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext registry, Commands.CommandSelection selection) {
        LiteralCommandNode command = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ftbchunks").then(((LiteralArgumentBuilder)Commands.literal((String)"claim").executes(context -> FTBChunksCommands.claim((CommandSourceStack)context.getSource(), FTBChunksCommands.selfTeam((CommandSourceStack)context.getSource()), 0))).then(FTBChunksCommands.radiusArg().executes(context -> FTBChunksCommands.claim((CommandSourceStack)context.getSource(), FTBChunksCommands.selfTeam((CommandSourceStack)context.getSource()), FTBChunksCommands.getRadiusArg((CommandContext<CommandSourceStack>)context)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"unclaim").executes(context -> FTBChunksCommands.unclaim((CommandSourceStack)context.getSource(), FTBChunksCommands.selfTeam((CommandSourceStack)context.getSource()), 0))).then(FTBChunksCommands.radiusArg().executes(context -> FTBChunksCommands.unclaim((CommandSourceStack)context.getSource(), FTBChunksCommands.selfTeam((CommandSourceStack)context.getSource()), FTBChunksCommands.getRadiusArg((CommandContext<CommandSourceStack>)context)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"load").executes(context -> FTBChunksCommands.load((CommandSourceStack)context.getSource(), 0))).then(FTBChunksCommands.radiusArg().executes(context -> FTBChunksCommands.load((CommandSourceStack)context.getSource(), FTBChunksCommands.getRadiusArg((CommandContext<CommandSourceStack>)context)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"unload").executes(context -> FTBChunksCommands.unload((CommandSourceStack)context.getSource(), 0))).then(FTBChunksCommands.radiusArg().executes(context -> FTBChunksCommands.unload((CommandSourceStack)context.getSource(), FTBChunksCommands.getRadiusArg((CommandContext<CommandSourceStack>)context)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"unclaim_all").executes(context -> FTBChunksCommands.unclaimAll((CommandSourceStack)context.getSource(), FTBChunksCommands.selfTeam((CommandSourceStack)context.getSource())))).then(FTBChunksCommands.forTeam(FTBChunksCommands::unclaimAll)))).then(((LiteralArgumentBuilder)Commands.literal((String)"unload_all").executes(context -> FTBChunksCommands.unloadAll((CommandSourceStack)context.getSource(), FTBChunksCommands.selfTeam((CommandSourceStack)context.getSource())))).then(FTBChunksCommands.forTeam(FTBChunksCommands::unloadAll)))).then(((LiteralArgumentBuilder)Commands.literal((String)"info").executes(context -> FTBChunksCommands.info((CommandSourceStack)context.getSource(), new ChunkDimPos((Level)((CommandSourceStack)context.getSource()).getLevel(), BlockPos.containing((Position)((CommandSourceStack)context.getSource()).getPosition()))))).then(Commands.argument((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)Commands.argument((String)"z", (ArgumentType)IntegerArgumentType.integer()).executes(context -> FTBChunksCommands.info((CommandSourceStack)context.getSource(), new ChunkDimPos((Level)((CommandSourceStack)context.getSource()).getLevel(), new BlockPos(IntegerArgumentType.getInteger((CommandContext)context, (String)"x"), 0, IntegerArgumentType.getInteger((CommandContext)context, (String)"z")))))).then(FTBChunksCommands.dimArg().executes(context -> FTBChunksCommands.info((CommandSourceStack)context.getSource(), new ChunkDimPos(FTBChunksCommands.getDimArg((CommandContext<CommandSourceStack>)context).dimension(), IntegerArgumentType.getInteger((CommandContext)context, (String)"x") >> 4, IntegerArgumentType.getInteger((CommandContext)context, (String)"z") >> 4)))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"admin").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"bypass_protection").executes(context -> FTBChunksCommands.bypassProtection((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"extra_claim_chunks").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.literal((String)"get").executes(context -> FTBChunksCommands.getExtraClaimChunks((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"))))).then(Commands.literal((String)"set").then(Commands.argument((String)"number", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> FTBChunksCommands.setExtraClaimChunks((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"number"), false))))).then(Commands.literal((String)"add").then(Commands.argument((String)"number", (ArgumentType)IntegerArgumentType.integer()).executes(context -> FTBChunksCommands.setExtraClaimChunks((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"number"), true))))))).then(Commands.literal((String)"extra_force_load_chunks").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.literal((String)"get").executes(context -> FTBChunksCommands.getExtraForceLoadChunks((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"))))).then(Commands.literal((String)"set").then(Commands.argument((String)"number", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> FTBChunksCommands.setExtraForceLoadChunks((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"number"), false))))).then(Commands.literal((String)"add").then(Commands.argument((String)"number", (ArgumentType)IntegerArgumentType.integer()).executes(context -> FTBChunksCommands.setExtraForceLoadChunks((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"number"), true))))))).then(Commands.literal((String)"claim_as").then(((RequiredArgumentBuilder)Commands.argument((String)"team", (ArgumentType)TeamArgument.create()).executes(context -> FTBChunksCommands.claim((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team"), 0))).then(((RequiredArgumentBuilder)FTBChunksCommands.radiusArg().executes(context -> FTBChunksCommands.claim((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team"), FTBChunksCommands.getRadiusArg((CommandContext<CommandSourceStack>)context)))).then(((RequiredArgumentBuilder)FTBChunksCommands.anchorArg().executes(context -> FTBChunksCommands.claim((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team"), FTBChunksCommands.getRadiusArg((CommandContext<CommandSourceStack>)context), FTBChunksCommands.getAnchorArg((CommandContext<CommandSourceStack>)context), (Level)((CommandSourceStack)context.getSource()).getLevel()))).then(FTBChunksCommands.dimArg().executes(context -> FTBChunksCommands.claim((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team"), FTBChunksCommands.getRadiusArg((CommandContext<CommandSourceStack>)context), FTBChunksCommands.getAnchorArg((CommandContext<CommandSourceStack>)context), (Level)FTBChunksCommands.getDimArg((CommandContext<CommandSourceStack>)context))))))))).then(Commands.literal((String)"unclaim_as").then(((RequiredArgumentBuilder)Commands.argument((String)"team", (ArgumentType)TeamArgument.create()).executes(context -> FTBChunksCommands.unclaim((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team"), 0))).then(((RequiredArgumentBuilder)FTBChunksCommands.radiusArg().executes(context -> FTBChunksCommands.unclaim((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team"), FTBChunksCommands.getRadiusArg((CommandContext<CommandSourceStack>)context)))).then(((RequiredArgumentBuilder)FTBChunksCommands.anchorArg().executes(context -> FTBChunksCommands.unclaim((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team"), FTBChunksCommands.getRadiusArg((CommandContext<CommandSourceStack>)context), FTBChunksCommands.getAnchorArg((CommandContext<CommandSourceStack>)context), (Level)((CommandSourceStack)context.getSource()).getLevel()))).then(FTBChunksCommands.dimArg().executes(context -> FTBChunksCommands.unclaim((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team"), FTBChunksCommands.getRadiusArg((CommandContext<CommandSourceStack>)context), FTBChunksCommands.getAnchorArg((CommandContext<CommandSourceStack>)context), (Level)FTBChunksCommands.getDimArg((CommandContext<CommandSourceStack>)context))))))))).then(Commands.literal((String)"unclaim_everything").executes(context -> FTBChunksCommands.unclaimEverything((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"unload_everything").executes(context -> FTBChunksCommands.unloadEverything((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"view_loaded_chunks").executes(context -> FTBChunksCommands.viewLoadedChunks((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getLevel()))).then(((LiteralArgumentBuilder)Commands.literal((String)"reset").executes(context -> FTBChunksCommands.resetLoadedChunks((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getLevel()))).then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(context -> FTBChunksCommands.resetLoadedChunks((CommandSourceStack)context.getSource(), DimensionArgument.getDimension((CommandContext)context, (String)"dimension")))))).then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(context -> FTBChunksCommands.viewLoadedChunks((CommandSourceStack)context.getSource(), DimensionArgument.getDimension((CommandContext)context, (String)"dimension"))))))).then(Commands.literal((String)"block_color").executes(context -> {
            NetworkManager.sendToPlayer((ServerPlayer)((CommandSourceStack)context.getSource()).getPlayerOrException(), (CustomPacketPayload)new RequestBlockColorPacket());
            return 1;
        }))).then(Commands.literal((String)"waypoint").then(Commands.literal((String)"add").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.argument((String)"position", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> FTBChunksCommands.addWaypoint((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"position")))).then(Commands.argument((String)"color", (ArgumentType)ColorArgument.color()).executes(context -> FTBChunksCommands.addWaypoint((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"position"), ColorArgument.getColor((CommandContext)context, (String)"color")))))))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"chunks").redirect((CommandNode)command));
    }

    private static int addWaypoint(CommandSourceStack source, String name, BlockPos position, ChatFormatting color) throws CommandSyntaxException {
        if (color.getColor() != null) {
            NetworkManager.sendToPlayer((ServerPlayer)source.getPlayerOrException(), (CustomPacketPayload)new AddWaypointPacket(name, position, color.getColor()));
        }
        return 1;
    }

    private static int addWaypoint(CommandSourceStack source, String name, BlockPos position) throws CommandSyntaxException {
        int idx = source.getPlayerOrException().getRandom().nextInt(ChatFormatting.values().length);
        return FTBChunksCommands.addWaypoint(source, name, position, ChatFormatting.values()[idx]);
    }

    private static int bypassProtection(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        ClaimedChunkManagerImpl manager = FTBChunksCommands.claimManager();
        manager.setBypassProtection(player.getUUID(), !manager.getBypassProtection(player.getUUID()));
        source.sendSuccess(() -> Component.literal((String)("bypass_protection = " + manager.getBypassProtection(player.getUUID()))), true);
        return 1;
    }

    private static void forEachChunk(CommandSourceStack source, int r, ChunkCallback callback) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        Team team = (Team)FTBTeamsAPI.api().getManager().getTeamForPlayer(player).orElseThrow(() -> TeamArgument.TEAM_NOT_FOUND.create((Object)player.getId()));
        FTBChunksCommands.forEachChunk(team, (Level)source.getLevel(), FTBChunksCommands.toColumn(source.getPosition()), r, callback);
    }

    private static void forEachChunk(Team team, Level level, ColumnPos anchor, int r, ChunkCallback callback) throws CommandSyntaxException {
        ChunkTeamDataImpl data = FTBChunksCommands.claimManager().getOrCreateData(team);
        ResourceKey dimId = level.dimension();
        int ox = Mth.floor((float)anchor.x()) >> 4;
        int oz = Mth.floor((float)anchor.z()) >> 4;
        ArrayList<ChunkDimPos> list = new ArrayList<ChunkDimPos>();
        for (int z = -(r >>= 4); z <= r; ++z) {
            for (int x = -r; x <= r; ++x) {
                list.add(new ChunkDimPos(dimId, ox + x, oz + z));
            }
        }
        list.sort(Comparator.comparingDouble(cdp -> MathUtils.distSq((double)ox, (double)oz, (double)cdp.x(), (double)cdp.z())));
        for (ChunkDimPos pos : list) {
            callback.accept(data, pos);
        }
    }

    private static int claim(CommandSourceStack source, Team team, int r) throws CommandSyntaxException {
        return FTBChunksCommands.claim(source, team, r, FTBChunksCommands.toColumn(source.getPosition()), (Level)source.getLevel());
    }

    private static int claim(CommandSourceStack source, Team team, int r, ColumnPos anchor, Level level) throws CommandSyntaxException {
        int[] success = new int[1];
        FTBChunksCommands.forEachChunk(team, level, anchor, r, (data, pos) -> {
            if (data.claim(source, pos, false).isSuccess()) {
                success[0] = success[0] + 1;
            }
        });
        source.sendSuccess(() -> Component.literal((String)("Claimed " + success[0] + " chunks!")), false);
        ChunkDimPos origin = new ChunkDimPos(level.dimension(), anchor.x() >> 4, anchor.z() >> 4);
        FTBChunks.LOGGER.info(source.getTextName() + " claimed " + success[0] + " chunks around " + String.valueOf(origin) + "for team " + team.getShortName());
        return success[0];
    }

    private static int unclaim(CommandSourceStack source, Team team, int r) throws CommandSyntaxException {
        return FTBChunksCommands.unclaim(source, team, r, FTBChunksCommands.toColumn(source.getPosition()), (Level)source.getLevel());
    }

    private static int unclaim(CommandSourceStack source, Team team, int r, ColumnPos anchor, Level level) throws CommandSyntaxException {
        int[] success = new int[1];
        FTBChunksCommands.forEachChunk(team, level, anchor, r, (data, pos) -> {
            if (data.unclaim(source, pos, false).isSuccess()) {
                success[0] = success[0] + 1;
            }
        });
        source.sendSuccess(() -> Component.literal((String)("Unclaimed " + success[0] + " chunks!")), false);
        ChunkDimPos origin = new ChunkDimPos(level.dimension(), anchor.x() >> 4, anchor.z() >> 4);
        FTBChunks.LOGGER.info(source.getTextName() + " unclaimed " + success[0] + " chunks around " + String.valueOf(origin) + "for team " + team.getShortName());
        return success[0];
    }

    private static int load(CommandSourceStack source, int r) throws CommandSyntaxException {
        int[] success = new int[1];
        FTBChunksCommands.forEachChunk(source, r, (data, pos) -> {
            ClaimResult result = data.forceLoad(source, pos, false);
            if (result.isSuccess()) {
                success[0] = success[0] + 1;
            }
        });
        source.sendSuccess(() -> Component.literal((String)("Loaded " + success[0] + " chunks!")), false);
        FTBChunks.LOGGER.info(source.getTextName() + " loaded " + success[0] + " chunks at " + String.valueOf(new ChunkDimPos((Entity)source.getPlayerOrException())));
        return success[0];
    }

    private static int unload(CommandSourceStack source, int r) throws CommandSyntaxException {
        int[] success = new int[1];
        FTBChunksCommands.forEachChunk(source, r, (data, pos) -> {
            if (data.unForceLoad(source, pos, false).isSuccess()) {
                success[0] = success[0] + 1;
            }
        });
        source.sendSuccess(() -> Component.literal((String)("Unloaded " + success[0] + " chunks!")), false);
        FTBChunks.LOGGER.info(source.getTextName() + " unloaded " + success[0] + " chunks at " + String.valueOf(new ChunkDimPos((Entity)source.getPlayerOrException())));
        return success[0];
    }

    private static int unclaimAll(CommandSourceStack source, Team team) {
        ChunkTeamDataImpl data = FTBChunksCommands.claimManager().getOrCreateData(team);
        for (ClaimedChunkImpl c : new ArrayList<ClaimedChunkImpl>(data.getClaimedChunks())) {
            data.unclaim(source, c.getPos(), false);
        }
        data.markDirty();
        return 1;
    }

    private static int unloadAll(CommandSourceStack source, Team team) {
        ChunkTeamDataImpl data = FTBChunksCommands.claimManager().getOrCreateData(team);
        for (ClaimedChunk claimedChunk : new ArrayList<ClaimedChunkImpl>(data.getClaimedChunks())) {
            data.unForceLoad(source, claimedChunk.getPos(), false);
        }
        data.markDirty();
        return 1;
    }

    private static int info(CommandSourceStack source, ChunkDimPos pos) {
        source.sendSuccess(() -> Component.literal((String)("Location: " + String.valueOf(pos))), true);
        ClaimedChunkImpl chunk = FTBChunksCommands.claimManager().getChunk(pos);
        if (chunk == null) {
            source.sendSuccess(() -> Component.literal((String)"Chunk not claimed!"), true);
            return 0;
        }
        source.sendSuccess(() -> Component.literal((String)"Owner: ").append(chunk.getTeamData().getTeam().getColoredName()).append(" / " + UndashedUuid.toString((UUID)chunk.getTeamData().getTeam().getId())), true);
        if (source.hasPermission(2)) {
            source.sendSuccess(() -> Component.literal((String)("Force Loaded: " + chunk.isForceLoaded())), true);
        }
        return 1;
    }

    private static int getExtraClaimChunks(CommandSourceStack source, ServerPlayer player) {
        ChunkTeamDataImpl personalData = FTBChunksCommands.claimManager().getPersonalData(player.getUUID());
        if (personalData == null) {
            source.sendFailure((Component)Component.literal((String)"can't get personal team data for ").append(player.getDisplayName()));
            return 0;
        }
        source.sendSuccess(() -> player.getDisplayName().copy().append("/extra_claim_chunks = " + personalData.getExtraClaimChunks()), false);
        return 1;
    }

    private static int setExtraClaimChunks(CommandSourceStack source, ServerPlayer player, int extra, boolean adding) {
        ChunkTeamDataImpl personalData = FTBChunksCommands.claimManager().getPersonalData(player.getUUID());
        if (personalData == null) {
            source.sendFailure((Component)Component.literal((String)"can't get personal team data for ").append(player.getDisplayName()));
            return 0;
        }
        personalData.setExtraClaimChunks(Math.max(0, extra + (adding ? personalData.getExtraClaimChunks() : 0)));
        personalData.markDirty();
        ChunkTeamDataImpl teamData = FTBChunksCommands.claimManager().getOrCreateData(player);
        teamData.updateLimits();
        SendGeneralDataPacket.send((ChunkTeamData)teamData, player);
        source.sendSuccess(() -> player.getDisplayName().copy().append("/extra_claim_chunks = " + personalData.getExtraClaimChunks()), false);
        return 1;
    }

    private static int getExtraForceLoadChunks(CommandSourceStack source, ServerPlayer player) {
        ChunkTeamDataImpl personalData = FTBChunksCommands.claimManager().getPersonalData(player.getUUID());
        if (personalData == null) {
            source.sendFailure((Component)Component.literal((String)"can't get personal team data for ").append(player.getDisplayName()));
            return 0;
        }
        source.sendSuccess(() -> player.getDisplayName().copy().append("/extra_force_load_chunks = " + personalData.getExtraForceLoadChunks()), false);
        return 1;
    }

    private static int setExtraForceLoadChunks(CommandSourceStack source, ServerPlayer player, int extra, boolean adding) {
        ChunkTeamDataImpl personalData = FTBChunksCommands.claimManager().getPersonalData(player.getUUID());
        if (personalData == null) {
            source.sendFailure((Component)Component.literal((String)"can't get personal team data for ").append(player.getDisplayName()));
            return 0;
        }
        personalData.setExtraForceLoadChunks(Math.max(0, extra + (adding ? personalData.getExtraForceLoadChunks() : 0)));
        personalData.markDirty();
        ChunkTeamDataImpl teamData = FTBChunksCommands.claimManager().getOrCreateData(player);
        teamData.updateLimits();
        SendGeneralDataPacket.send((ChunkTeamData)teamData, player);
        source.sendSuccess(() -> player.getDisplayName().copy().append("/extra_force_load_chunks = " + personalData.getExtraForceLoadChunks()), false);
        return 1;
    }

    private static int unclaimEverything(CommandSourceStack source) {
        for (ClaimedChunkImpl c : new ArrayList<ClaimedChunkImpl>(FTBChunksCommands.claimManager().getAllClaimedChunks())) {
            c.getTeamData().unclaim(source, c.getPos(), false);
            c.getTeamData().markDirty();
        }
        return 1;
    }

    private static int unloadEverything(CommandSourceStack source) {
        for (ClaimedChunkImpl c : new ArrayList<ClaimedChunkImpl>(FTBChunksCommands.claimManager().getAllClaimedChunks())) {
            c.getTeamData().unForceLoad(source, c.getPos(), false);
            c.getTeamData().markDirty();
        }
        return 1;
    }

    private static int viewLoadedChunks(CommandSourceStack source, ServerLevel level) throws CommandSyntaxException {
        long pos;
        Long2IntOpenHashMap chunks = new Long2IntOpenHashMap();
        for (ChunkHolder holder : level.getChunkSource().chunkMap.updatingChunkMap.values()) {
            chunks.put(holder.getPos().toLong(), 1);
        }
        Long2ObjectMap<UUID> map = FTBChunksCommands.claimManager().getForceLoadedChunks((ResourceKey<Level>)level.dimension());
        LongIterator longIterator = map.keySet().iterator();
        while (longIterator.hasNext()) {
            pos = (Long)longIterator.next();
            if (chunks.get(pos) != 1) continue;
            chunks.put(pos, 2);
        }
        longIterator = level.getForcedChunks().iterator();
        while (longIterator.hasNext()) {
            pos = (Long)longIterator.next();
            if (chunks.get(pos) != 1) continue;
            chunks.put(pos, 2);
        }
        source.sendSuccess(() -> Component.literal((String)String.format("Chunks Loaded: %d. Check the map to see loaded chunks", chunks.size())), false);
        NetworkManager.sendToPlayer((ServerPlayer)source.getPlayerOrException(), (CustomPacketPayload)new LoadedChunkViewPacket((ResourceKey<Level>)level.dimension(), (Long2IntMap)chunks));
        return 1;
    }

    private static int resetLoadedChunks(CommandSourceStack source, ServerLevel level) throws CommandSyntaxException {
        NetworkManager.sendToPlayer((ServerPlayer)source.getPlayerOrException(), (CustomPacketPayload)new LoadedChunkViewPacket((ResourceKey<Level>)level.dimension(), (Long2IntMap)Long2IntMaps.EMPTY_MAP));
        return 1;
    }

    private static RequiredArgumentBuilder<CommandSourceStack, Integer> radiusArg() {
        return Commands.argument((String)"radius_in_blocks", (ArgumentType)IntegerArgumentType.integer((int)0, (int)512));
    }

    private static int getRadiusArg(CommandContext<CommandSourceStack> context) {
        return IntegerArgumentType.getInteger(context, (String)"radius_in_blocks");
    }

    private static RequiredArgumentBuilder<CommandSourceStack, Coordinates> anchorArg() {
        return Commands.argument((String)"anchor", (ArgumentType)new ColumnPosArgument());
    }

    private static ColumnPos getAnchorArg(CommandContext<CommandSourceStack> context) {
        return ColumnPosArgument.getColumnPos(context, (String)"anchor");
    }

    private static RequiredArgumentBuilder<CommandSourceStack, ResourceLocation> dimArg() {
        return Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension());
    }

    private static ServerLevel getDimArg(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return DimensionArgument.getDimension(context, (String)"dimension");
    }

    private static RequiredArgumentBuilder<CommandSourceStack, TeamArgumentProvider> forTeam(ToIntBiFunction<CommandSourceStack, Team> callback) {
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"team", (ArgumentType)TeamArgument.create()).requires(source -> source.hasPermission(2))).executes(context -> callback.applyAsInt((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team")));
    }

    private static ColumnPos toColumn(Vec3 pos) {
        BlockPos blockPos = BlockPos.containing((Position)pos);
        return new ColumnPos(blockPos.getX(), blockPos.getZ());
    }

    private static Team selfTeam(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        return (Team)FTBTeamsAPI.api().getManager().getTeamForPlayer(player).orElseThrow(() -> TeamArgument.TEAM_NOT_FOUND.create((Object)player.getId()));
    }

    private static ClaimedChunkManagerImpl claimManager() {
        return ClaimedChunkManagerImpl.getInstance();
    }

    private static interface ChunkCallback {
        public void accept(ChunkTeamDataImpl var1, ChunkDimPos var2) throws CommandSyntaxException;
    }
}

