/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.darkmodeeverywhere.mixins;

import com.buuz135.darkmodeeverywhere.ClassUtil;
import com.buuz135.darkmodeeverywhere.ClientProxy;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GameRenderer.class})
public class GameRenderMixin {
    private static void replaceDefaultShaderWithSelectedShader(CallbackInfoReturnable<ShaderInstance> cir) {
        cir.setReturnValue((Object)ClientProxy.REGISTERED_SHADERS.get(ClientProxy.SELECTED_SHADER));
    }

    @Inject(method={"getPositionTexShader"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getPositionTexShader(CallbackInfoReturnable<ShaderInstance> cir) {
        if (ClientProxy.SELECTED_SHADER != null) {
            String callerClassName = ClassUtil.getCallerClassName();
            if (callerClassName == null) {
                GameRenderMixin.replaceDefaultShaderWithSelectedShader(cir);
                return;
            }
            boolean elementNameIsBlacklisted = ClientProxy.isElementNameBlacklisted(callerClassName);
            if (!elementNameIsBlacklisted) {
                GameRenderMixin.replaceDefaultShaderWithSelectedShader(cir);
            }
        }
    }
}

