/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.darkmodeeverywhere;

import com.buuz135.darkmodeeverywhere.ClientProxy;
import com.buuz135.darkmodeeverywhere.DarkModeEverywhere;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class ShaderConfig {
    private List<ShaderValue> shaders = new ArrayList<ShaderValue>();
    private int version = 1;
    private String selectedShader;
    private static final File configFilePath = new File("config" + File.separator + "darkmodeeverywhereshaders.json");

    public ShaderConfig() {
        this.shaders.add(new ShaderValue(ResourceLocation.fromNamespaceAndPath((String)"darkmodeeverywhere", (String)"perfect_dark"), "gui.darkmodeeverywhere.perfect_dark", 0xFFFFFF));
        this.shaders.add(new ShaderValue(ResourceLocation.fromNamespaceAndPath((String)"darkmodeeverywhere", (String)"less_perfect_dark"), "gui.darkmodeeverywhere.less_perfect_dark", 0xFFFFFF));
        this.shaders.add(new ShaderValue(ResourceLocation.fromNamespaceAndPath((String)"darkmodeeverywhere", (String)"toasted_light"), "gui.darkmodeeverywhere.toasted_light", 0xFFFFFF));
        this.selectedShader = null;
    }

    public List<ShaderValue> getShaders() {
        return this.shaders;
    }

    public void setSelectedShader(ResourceLocation resourceLocation) {
        this.selectedShader = resourceLocation == null ? null : resourceLocation.toString();
        DarkModeEverywhere.LOGGER.debug("Selected shader updated to {}", (Object)this.selectedShader);
        new Thread(ShaderConfig::createDefaultConfigFile).start();
    }

    public String getSelectedShader() {
        return this.selectedShader;
    }

    private static Gson createGson() {
        return new GsonBuilder().setPrettyPrinting().create();
    }

    public static void load() {
        if (!configFilePath.exists()) {
            ShaderConfig.createDefaultConfigFile();
        }
        Gson gson = ShaderConfig.createGson();
        try (FileReader reader = new FileReader(configFilePath);){
            ClientProxy.CONFIG = (ShaderConfig)gson.fromJson((Reader)reader, ShaderConfig.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            ShaderConfig.createDefaultConfigFile();
        }
    }

    private static void createDefaultConfigFile() {
        Gson gson = ShaderConfig.createGson();
        try (FileWriter fileWriter = new FileWriter(configFilePath);){
            gson.toJson((Object)ClientProxy.CONFIG, (Appendable)fileWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class ShaderValue {
        public ResourceLocation resourceLocation;
        public String displayName;
        public int darkColorReplacement;

        public ShaderValue(ResourceLocation resourceLocation, String displayName, int darkColorReplacement) {
            this.resourceLocation = resourceLocation;
            this.displayName = displayName;
            this.darkColorReplacement = darkColorReplacement;
        }
    }
}

