/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.darkmodeeverywhere;

import com.buuz135.darkmodeeverywhere.DarkConfig;
import com.buuz135.darkmodeeverywhere.DarkModeEverywhere;
import com.buuz135.darkmodeeverywhere.RenderedClassesTracker;
import com.buuz135.darkmodeeverywhere.ShaderConfig;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;

public class ClientProxy {
    public static Object2BooleanMap<String> BLACKLISTED_ELEMENTS = new Object2BooleanOpenHashMap();
    public static List<String> MODDED_BLACKLIST = new ArrayList<String>();
    public static ShaderConfig CONFIG = new ShaderConfig();
    public static Map<ResourceLocation, ShaderInstance> REGISTERED_SHADERS = new HashMap<ResourceLocation, ShaderInstance>();
    public static List<ResourceLocation> REGISTERED_SHADER_LOCATIONS = new ArrayList<ResourceLocation>();
    public static Map<ResourceLocation, ShaderConfig.ShaderValue> SHADER_VALUES = new HashMap<ResourceLocation, ShaderConfig.ShaderValue>();
    public static ResourceLocation SELECTED_SHADER = null;

    public ClientProxy(IEventBus modEventBus, ModContainer modContainer) {
        ShaderConfig.load();
        modEventBus.addListener(this::shaderRegister);
        modEventBus.addListener(this::onConfigReload);
        modEventBus.addListener(this::imcCallback);
        NeoForge.EVENT_BUS.addListener(this::openGui);
    }

    @SubscribeEvent
    public void shaderRegister(RegisterShadersEvent event) {
        REGISTERED_SHADERS = new HashMap<ResourceLocation, ShaderInstance>();
        REGISTERED_SHADER_LOCATIONS = new ArrayList<ResourceLocation>();
        SHADER_VALUES = new HashMap<ResourceLocation, ShaderConfig.ShaderValue>();
        for (ShaderConfig.ShaderValue shaderValue : CONFIG.getShaders()) {
            if (SHADER_VALUES.put(shaderValue.resourceLocation, shaderValue) != null) continue;
            try {
                event.registerShader(new ShaderInstance(event.getResourceProvider(), shaderValue.resourceLocation, DefaultVertexFormat.POSITION_TEX), shaderInstance -> {
                    DarkModeEverywhere.LOGGER.debug("Registered shader {}", (Object)shaderValue.resourceLocation);
                    REGISTERED_SHADERS.put(shaderValue.resourceLocation, (ShaderInstance)shaderInstance);
                    REGISTERED_SHADER_LOCATIONS.add(shaderValue.resourceLocation);
                });
            }
            catch (IOException e) {
                DarkModeEverywhere.LOGGER.trace("Failed to register shader", (Throwable)e);
            }
        }
        if (CONFIG.getSelectedShader() != null) {
            SELECTED_SHADER = ResourceLocation.parse((String)CONFIG.getSelectedShader());
        }
        RenderedClassesTracker.start();
    }

    @SubscribeEvent
    public void onConfigReload(ModConfigEvent.Reloading reloading) {
        BLACKLISTED_ELEMENTS.clear();
    }

    private static boolean blacklistContains(List<String> blacklist, String elementName) {
        return blacklist.stream().anyMatch(elementName::contains);
    }

    public static boolean isElementNameBlacklisted(String elementName) {
        return BLACKLISTED_ELEMENTS.computeIfAbsent((Object)elementName, name -> {
            DarkModeEverywhere.LOGGER.debug("Considering {} for element blacklist", name);
            RenderedClassesTracker.add(name);
            return ClientProxy.blacklistContains(MODDED_BLACKLIST, name) || ClientProxy.blacklistContains((List)DarkConfig.CLIENT.METHOD_SHADER_BLACKLIST.get(), name);
        });
    }

    @SubscribeEvent
    public void imcCallback(InterModProcessEvent event) {
        event.getIMCStream(string -> string.equals("dme-shaderblacklist")).forEach(imcMessage -> {
            Object patt0$temp = imcMessage.messageSupplier().get();
            if (patt0$temp instanceof String) {
                String classMethodBlacklist = (String)patt0$temp;
                MODDED_BLACKLIST.add(classMethodBlacklist);
            }
        });
    }

    private ResourceLocation getNextShaderResourceLocation() {
        if (Screen.hasShiftDown()) {
            return null;
        }
        if (SELECTED_SHADER == null) {
            return REGISTERED_SHADER_LOCATIONS.get(0);
        }
        int nextShaderIndex = REGISTERED_SHADER_LOCATIONS.indexOf(SELECTED_SHADER) + 1;
        if (nextShaderIndex >= REGISTERED_SHADERS.size()) {
            return null;
        }
        return REGISTERED_SHADER_LOCATIONS.get(nextShaderIndex);
    }

    private Tooltip getShaderSwitchButtonTooltip() {
        MutableComponent tooltipComponent = SELECTED_SHADER == null ? Component.translatable((String)"gui.darkmodeeverywhere.light_mode") : Component.translatable((String)ClientProxy.SHADER_VALUES.get((Object)ClientProxy.SELECTED_SHADER).displayName);
        tooltipComponent.append((Component)Component.literal((String)"\n"));
        tooltipComponent.append((Component)Component.translatable((String)"gui.tooltip.darkmodeeverywhere.shader_switch_tooltip").withStyle(ChatFormatting.GRAY));
        return Tooltip.create((Component)tooltipComponent);
    }

    @SubscribeEvent
    public void openGui(ScreenEvent.Init.Pre event) {
        if (event.getScreen() instanceof AbstractContainerScreen || ((Boolean)DarkConfig.CLIENT.SHOW_BUTTON_IN_TITLE_SCREEN.get()).booleanValue() && event.getScreen() instanceof TitleScreen) {
            int x = (Integer)DarkConfig.CLIENT.GUI_BUTTON_X_OFFSET.get();
            int y = (Integer)DarkConfig.CLIENT.GUI_BUTTON_Y_OFFSET.get();
            if (event.getScreen() instanceof TitleScreen) {
                x = (Integer)DarkConfig.CLIENT.TITLE_SCREEN_BUTTON_X_OFFSET.get();
                y = (Integer)DarkConfig.CLIENT.TITLE_SCREEN_BUTTON_Y_OFFSET.get();
            }
            Button.Builder buttonBuilder = Button.builder((Component)Component.translatable((String)"gui.darkmodeeverywhere.dark_mode"), button -> {
                SELECTED_SHADER = this.getNextShaderResourceLocation();
                CONFIG.setSelectedShader(SELECTED_SHADER);
                button.setTooltip(this.getShaderSwitchButtonTooltip());
            });
            buttonBuilder.pos(x, event.getScreen().height - 24 - y);
            buttonBuilder.size(60, 20);
            buttonBuilder.tooltip(this.getShaderSwitchButtonTooltip());
            Button button2 = buttonBuilder.build();
            event.addListener((GuiEventListener)button2);
        }
    }
}

