/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.neoforge;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import me.lucko.spark.common.platform.world.AbstractChunkInfo;
import me.lucko.spark.common.platform.world.CountMap;
import me.lucko.spark.common.platform.world.WorldInfoProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.entity.EntityLookup;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.entity.TransientEntitySectionManager;

public abstract class NeoForgeWorldInfoProvider
implements WorldInfoProvider {
    protected List<ForgeChunkInfo> getChunksFromCache(EntitySectionStorage<Entity> cache) {
        LongSet loadedChunks = cache.getAllChunksWithExistingSections();
        ArrayList<ForgeChunkInfo> list = new ArrayList<ForgeChunkInfo>(loadedChunks.size());
        LongIterator iterator = loadedChunks.iterator();
        while (iterator.hasNext()) {
            long chunkPos = iterator.nextLong();
            Stream sections = cache.getExistingSectionsInChunk(chunkPos);
            list.add(new ForgeChunkInfo(chunkPos, sections));
        }
        return list;
    }

    public static final class ForgeChunkInfo
    extends AbstractChunkInfo<EntityType<?>> {
        private final CountMap<EntityType<?>> entityCounts = new CountMap.Simple(new HashMap());

        ForgeChunkInfo(long chunkPos, Stream<EntitySection<Entity>> entities) {
            super(ChunkPos.getX((long)chunkPos), ChunkPos.getZ((long)chunkPos));
            entities.forEach(section -> {
                if (section.getStatus().isAccessible()) {
                    section.getEntities().forEach(entity -> this.entityCounts.increment(entity.getType()));
                }
            });
        }

        @Override
        public CountMap<EntityType<?>> getEntityCounts() {
            return this.entityCounts;
        }

        @Override
        public String entityTypeName(EntityType<?> type) {
            return EntityType.getKey(type).toString();
        }
    }

    public static final class Client
    extends NeoForgeWorldInfoProvider {
        private final Minecraft client;

        public Client(Minecraft client) {
            this.client = client;
        }

        @Override
        public WorldInfoProvider.CountsResult pollCounts() {
            ClientLevel level = this.client.level;
            if (level == null) {
                return null;
            }
            TransientEntitySectionManager entityManager = level.entityStorage;
            EntityLookup entityIndex = entityManager.entityStorage;
            int entities = entityIndex.count();
            int chunks = level.getChunkSource().getLoadedChunksCount();
            return new WorldInfoProvider.CountsResult(-1, entities, -1, chunks);
        }

        public WorldInfoProvider.ChunksResult<ForgeChunkInfo> pollChunks() {
            WorldInfoProvider.ChunksResult<ForgeChunkInfo> data = new WorldInfoProvider.ChunksResult<ForgeChunkInfo>();
            ClientLevel level = this.client.level;
            if (level == null) {
                return null;
            }
            TransientEntitySectionManager entityManager = level.entityStorage;
            EntitySectionStorage cache = entityManager.sectionStorage;
            List<ForgeChunkInfo> list = this.getChunksFromCache((EntitySectionStorage<Entity>)cache);
            data.put(level.dimension().location().getPath(), list);
            return data;
        }
    }

    public static final class Server
    extends NeoForgeWorldInfoProvider {
        private final MinecraftServer server;

        public Server(MinecraftServer server) {
            this.server = server;
        }

        @Override
        public WorldInfoProvider.CountsResult pollCounts() {
            int players = this.server.getPlayerCount();
            int entities = 0;
            int chunks = 0;
            for (ServerLevel level : this.server.getAllLevels()) {
                PersistentEntitySectionManager entityManager = level.entityManager;
                EntityLookup entityIndex = entityManager.visibleEntityStorage;
                entities += entityIndex.count();
                chunks += level.getChunkSource().getLoadedChunksCount();
            }
            return new WorldInfoProvider.CountsResult(players, entities, -1, chunks);
        }

        public WorldInfoProvider.ChunksResult<ForgeChunkInfo> pollChunks() {
            WorldInfoProvider.ChunksResult<ForgeChunkInfo> data = new WorldInfoProvider.ChunksResult<ForgeChunkInfo>();
            for (ServerLevel level : this.server.getAllLevels()) {
                PersistentEntitySectionManager entityManager = level.entityManager;
                EntitySectionStorage cache = entityManager.sectionStorage;
                List<ForgeChunkInfo> list = this.getChunksFromCache((EntitySectionStorage<Entity>)cache);
                data.put(level.dimension().location().getPath(), list);
            }
            return data;
        }
    }
}

