/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.neoforge;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import me.lucko.spark.common.platform.MetadataProvider;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;

public class NeoForgeExtraMetadataProvider
implements MetadataProvider {
    private final PackRepository resourcePackManager;

    public NeoForgeExtraMetadataProvider(PackRepository resourcePackManager) {
        this.resourcePackManager = resourcePackManager;
    }

    @Override
    public Map<String, JsonElement> get() {
        LinkedHashMap<String, JsonElement> metadata = new LinkedHashMap<String, JsonElement>();
        metadata.put("datapacks", this.datapackMetadata());
        return metadata;
    }

    private JsonElement datapackMetadata() {
        JsonObject datapacks = new JsonObject();
        for (Pack profile : this.resourcePackManager.getSelectedPacks()) {
            JsonObject obj = new JsonObject();
            obj.addProperty("name", profile.getTitle().getString());
            obj.addProperty("description", profile.getDescription().getString());
            obj.addProperty("source", NeoForgeExtraMetadataProvider.resourcePackSource(profile.getPackSource()));
            datapacks.add(profile.getId(), (JsonElement)obj);
        }
        return datapacks;
    }

    private static String resourcePackSource(PackSource source) {
        if (source == PackSource.DEFAULT) {
            return "none";
        }
        if (source == PackSource.BUILT_IN) {
            return "builtin";
        }
        if (source == PackSource.WORLD) {
            return "world";
        }
        if (source == PackSource.SERVER) {
            return "server";
        }
        return "unknown";
    }
}

