/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.world.height;

import java.util.function.IntSupplier;
import java.util.function.Supplier;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedEnumValue;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.resource.ore.OreAnchor;
import mekanism.common.world.height.AnchorType;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.Nullable;

public record ConfigurableVerticalAnchor(Supplier<AnchorType> anchorType, IntSupplier value) {
    public static ConfigurableVerticalAnchor create(IMekanismConfig config, ModConfigSpec.Builder builder, String path, String comment, OreAnchor defaultAnchor, @Nullable ConfigurableVerticalAnchor minAnchor) {
        builder.comment(comment).push(path);
        CachedEnumValue<AnchorType> type = CachedEnumValue.wrap(config, builder.comment(new String[]{"Type of anchor.", "Absolute -> y = value", "Above Bottom -> y = minY + value", "Below Top -> y = depth - 1 + minY - value"}).defineEnum("type", (Enum)defaultAnchor.type()));
        ModConfigSpec.Builder valueBuilder = builder.comment("Value used for calculating y for the anchor based on the type.");
        ModConfigSpec.ConfigValue value = minAnchor == null ? valueBuilder.define("value", (Object)defaultAnchor.value()) : valueBuilder.define("value", (Object)defaultAnchor.value(), o -> {
            if (o instanceof Integer) {
                Integer v = (Integer)o;
                return minAnchor.anchorType.get() != type.get() || v >= minAnchor.value.getAsInt();
            }
            return false;
        });
        builder.pop();
        return new ConfigurableVerticalAnchor(type, CachedIntValue.wrap(config, (ModConfigSpec.ConfigValue<Integer>)value));
    }

    public int resolveY(WorldGenerationContext context) {
        return this.anchorType.get().resolveY(context, this.value.getAsInt());
    }

    @Override
    public String toString() {
        return switch (this.anchorType.get()) {
            default -> throw new MatchException(null, null);
            case AnchorType.ABSOLUTE -> this.value.getAsInt() + " absolute";
            case AnchorType.ABOVE_BOTTOM -> this.value.getAsInt() + " above bottom";
            case AnchorType.BELOW_TOP -> this.value.getAsInt() + " below top";
        };
    }
}

