/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.heat.HeatAPI;
import mekanism.api.math.FloatingLong;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.energy.ResistiveHeaterEnergyContainer;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.heat.CachedAmbientTemperature;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.heat.HeatCapacitorHelper;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityResistiveHeater
extends TileEntityMekanism {
    public static final double HEAT_CAPACITY = 100.0;
    public static final double INVERSE_CONDUCTION_COEFFICIENT = 5.0;
    public static final double INVERSE_INSULATION_COEFFICIENT = 10.0;
    public static final FloatingLong BASE_USAGE = FloatingLong.createConst(100L);
    private float soundScale = 1.0f;
    private double lastEnvironmentLoss;
    private double lastTransferLoss;
    private FloatingLong clientEnergyUsed = FloatingLong.ZERO;
    private ResistiveHeaterEnergyContainer energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerHeatCapacitorWrapper.class, methodNames={"getTemperature"}, docPlaceholder="heater")
    BasicHeatCapacitor heatCapacitor;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy slot")
    EnergyInventorySlot energySlot;

    public TileEntityResistiveHeater(BlockPos pos, BlockState state) {
        super(MekanismBlocks.RESISTIVE_HEATER, pos, state);
    }

    @Override
    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = ResistiveHeaterEnergyContainer.input(this, listener);
        builder.addContainer(this.energyContainer, RelativeSide.LEFT, RelativeSide.RIGHT);
        return builder.build();
    }

    @Override
    @NotNull
    protected IHeatCapacitorHolder getInitialHeatCapacitors(IContentsListener listener, CachedAmbientTemperature ambientTemperature) {
        HeatCapacitorHelper builder = HeatCapacitorHelper.forSide(this::getDirection);
        this.heatCapacitor = BasicHeatCapacitor.create(100.0, 5.0, 10.0, ambientTemperature, listener);
        builder.addCapacitor(this.heatCapacitor);
        return builder.build();
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityResistiveHeater)this).getLevel(), listener, 15, 35);
        builder.addSlot(this.energySlot);
        return builder.build();
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        FloatingLong toUse = FloatingLong.ZERO;
        if (this.canFunction() && !(toUse = this.energyContainer.extract(this.energyContainer.getEnergyPerTick(), Action.SIMULATE, AutomationType.INTERNAL)).isZero()) {
            this.heatCapacitor.handleHeat(toUse.multiply(MekanismConfig.general.resistiveHeaterEfficiency.get()).doubleValue());
            this.energyContainer.extract(toUse, Action.EXECUTE, AutomationType.INTERNAL);
        }
        this.setActive(!toUse.isZero());
        this.clientEnergyUsed = toUse;
        HeatAPI.HeatTransfer transfer = this.simulate();
        this.lastEnvironmentLoss = transfer.environmentTransfer();
        this.lastTransferLoss = transfer.adjacentTransfer();
        float newSoundScale = toUse.divide(100000L).floatValue();
        if ((double)Math.abs(newSoundScale - this.soundScale) > 0.01) {
            this.soundScale = newSoundScale;
            sendUpdatePacket = true;
        }
        return sendUpdatePacket;
    }

    @NotNull
    @ComputerMethod
    public FloatingLong getEnergyUsed() {
        return this.clientEnergyUsed;
    }

    @ComputerMethod(nameOverride="getTransferLoss")
    public double getLastTransferLoss() {
        return this.lastTransferLoss;
    }

    @ComputerMethod(nameOverride="getEnvironmentalLoss")
    public double getLastEnvironmentLoss() {
        return this.lastEnvironmentLoss;
    }

    public void setEnergyUsageFromPacket(FloatingLong floatingLong) {
        this.energyContainer.updateEnergyUsage(floatingLong);
        this.markForSave();
    }

    @Override
    public float getVolume() {
        return Mth.sqrt((float)this.soundScale);
    }

    public MachineEnergyContainer<TileEntityResistiveHeater> getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    public CompoundTag getConfigurationData(HolderLookup.Provider provider, Player player) {
        CompoundTag data = super.getConfigurationData(provider, player);
        data.putString("energy_usage", this.energyContainer.getEnergyPerTick().toString());
        return data;
    }

    @Override
    public void setConfigurationData(HolderLookup.Provider provider, Player player, CompoundTag data) {
        super.setConfigurationData(provider, player, data);
        NBTUtils.setFloatingLongIfPresent(data, "energy_usage", this.energyContainer::updateEnergyUsage);
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableDouble.create(this::getLastTransferLoss, value -> {
            this.lastTransferLoss = value;
        }));
        container.track(SyncableDouble.create(this::getLastEnvironmentLoss, value -> {
            this.lastEnvironmentLoss = value;
        }));
        container.track(SyncableFloatingLong.create(this::getEnergyUsed, value -> {
            this.clientEnergyUsed = value;
        }));
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getReducedUpdateTag(provider);
        updateTag.putFloat("sound_scale", this.soundScale);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        NBTUtils.setFloatIfPresent(tag, "sound_scale", value -> {
            this.soundScale = value;
        });
    }

    @Override
    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        builder.set(MekanismDataComponents.ENERGY_USAGE, (Object)this.energyContainer.getEnergyPerTick());
        super.collectImplicitComponents(builder);
    }

    @Override
    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        this.energyContainer.updateEnergyUsage((FloatingLong)input.getOrDefault(MekanismDataComponents.ENERGY_USAGE, (Object)BASE_USAGE));
        super.applyImplicitComponents(input);
    }

    @ComputerMethod(methodDescription="Get the energy used in the last tick by the machine")
    FloatingLong getEnergyUsage() {
        return this.energyContainer.getEnergyPerTick();
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void setEnergyUsage(FloatingLong usage) throws ComputerException {
        this.validateSecurityIsPublic();
        this.setEnergyUsageFromPacket(usage);
    }
}

