/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.attachments.FilterAware;
import mekanism.common.attachments.OverflowAware;
import mekanism.common.base.MekFakePlayer;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MinerEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.filter.SortableFilterManager;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.miner.ThreadMinerSearch;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.container.sync.SyncableItemStack;
import mekanism.common.inventory.container.sync.SyncableRegistryEntry;
import mekanism.common.inventory.container.tile.DigitalMinerConfigContainer;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.item.gear.ItemAtomicDisassembler;
import mekanism.common.lib.chunkloading.IChunkLoader;
import mekanism.common.lib.inventory.Finder;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentChunkLoader;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.tile.interfaces.IHasVisualization;
import mekanism.common.tile.interfaces.ITileFilterHolder;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.StackUtils;
import mekanism.common.util.UpgradeUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityDigitalMiner
extends TileEntityMekanism
implements IChunkLoader,
IBoundingBlock,
ITileFilterHolder<MinerFilter<?>>,
IHasVisualization {
    public static final int DEFAULT_HEIGHT_RANGE = 60;
    public static final int DEFAULT_RADIUS = 10;
    private final SortableFilterManager<MinerFilter<?>> filterManager = new SortableFilterManager<MinerFilter>(MinerFilter.class, this::markForSave);
    private Long2ObjectMap<BitSet> oresToMine = Long2ObjectMaps.emptyMap();
    public ThreadMinerSearch searcher = new ThreadMinerSearch(this);
    @Nullable
    private @Nullable BlockCapabilityCache<IItemHandler, @Nullable Direction> pullInventory;
    @Nullable
    private @Nullable BlockCapabilityCache<IItemHandler, @Nullable Direction> selfEjectInventory;
    @Nullable
    private @Nullable BlockCapabilityCache<IItemHandler, @Nullable Direction> ejectInventory;
    private int radius;
    private boolean inverse;
    private boolean inverseRequiresReplacement;
    private Item inverseReplaceTarget = Items.AIR;
    private int minY;
    private int maxY = this.minY + 60;
    private boolean doEject = false;
    private boolean doPull = false;
    public ItemStack missingStack = ItemStack.EMPTY;
    private final Predicate<ItemStack> overflowCollector = this::trackOverflow;
    private final Object2IntMap<HashedItem> overflow = new Object2IntLinkedOpenHashMap();
    private boolean hasOverflow;
    private boolean recheckOverflow;
    private int delay;
    private int delayLength;
    private int cachedToMine;
    private boolean silkTouch;
    private boolean running;
    private int delayTicks;
    private boolean initCalc;
    private int numPowering;
    private boolean clientRendering;
    private final TileComponentChunkLoader<TileEntityDigitalMiner> chunkLoaderComponent;
    @Nullable
    private ChunkPos targetChunk;
    private MinerEnergyContainer energyContainer;
    private List<IInventorySlot> mainSlots;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy slot")
    EnergyInventorySlot energySlot;

    public TileEntityDigitalMiner(BlockPos pos, BlockState state) {
        super(MekanismBlocks.DIGITAL_MINER, pos, state);
        this.delayLength = MekanismConfig.general.minerTicksPerMine.get();
        this.initCalc = false;
        this.chunkLoaderComponent = new TileComponentChunkLoader<TileEntityDigitalMiner>(this);
        this.radius = 10;
    }

    @Override
    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = MinerEnergyContainer.input(this, listener);
        builder.addContainer(this.energyContainer, RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.BOTTOM);
        return builder.build();
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        this.mainSlots = new ArrayList<IInventorySlot>();
        IContentsListener mainSlotListener = () -> {
            listener.onContentsChanged();
            this.recheckOverflow = true;
        };
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection, side -> side == RelativeSide.TOP, side -> side == RelativeSide.BACK);
        BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canInsert = (stack, automationType) -> automationType != AutomationType.EXTERNAL || this.isReplaceTarget(stack.getItem());
        BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canExtract = (stack, automationType) -> automationType != AutomationType.EXTERNAL || !this.isReplaceTarget(stack.getItem());
        for (int slotY = 0; slotY < 3; ++slotY) {
            for (int slotX = 0; slotX < 9; ++slotX) {
                BasicInventorySlot slot = BasicInventorySlot.at(canExtract, canInsert, mainSlotListener, 8 + slotX * 18, 92 + slotY * 18);
                builder.addSlot(slot, RelativeSide.BACK, RelativeSide.TOP);
                this.mainSlots.add(slot);
            }
        }
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityDigitalMiner)this).getLevel(), listener, 152, 20);
        builder.addSlot(this.energySlot);
        return builder.build();
    }

    private void closeInvalidScreens() {
        if (this.getActive() && !this.playersUsing.isEmpty()) {
            for (Player player : new HashSet(this.playersUsing)) {
                if (!(player.containerMenu instanceof DigitalMinerConfigContainer)) continue;
                player.closeContainer();
            }
        }
    }

    @Override
    protected void onUpdateClient() {
        super.onUpdateClient();
        this.closeInvalidScreens();
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.closeInvalidScreens();
        if (!this.initCalc) {
            if (this.searcher.state == ThreadMinerSearch.State.FINISHED) {
                boolean prevRunning = this.running;
                this.reset();
                this.start();
                this.running = prevRunning;
            }
            this.initCalc = true;
        }
        this.energySlot.fillContainerOrConvert();
        if (this.recheckOverflow) {
            this.tryAddOverflow();
        }
        if (!this.hasOverflow && this.canFunction() && this.running && this.searcher.state == ThreadMinerSearch.State.FINISHED && !this.oresToMine.isEmpty()) {
            FloatingLong energyPerTick = this.energyContainer.getEnergyPerTick();
            if (this.energyContainer.extract(energyPerTick, Action.SIMULATE, AutomationType.INTERNAL).equals(energyPerTick)) {
                this.setActive(true);
                if (this.delay > 0) {
                    --this.delay;
                }
                this.energyContainer.extract(energyPerTick, Action.EXECUTE, AutomationType.INTERNAL);
                if (this.delay == 0) {
                    this.tryMineBlock();
                    this.delay = this.getDelay();
                }
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
        if (this.doEject && this.delayTicks == 0) {
            TransitRequest.TransitResponse response;
            IItemHandler ejectMap;
            Direction direction = this.getDirection();
            Direction oppositeDirection = direction.getOpposite();
            BlockPos ejectPos = this.getBlockPos().above().relative(oppositeDirection);
            if (this.selfEjectInventory == null) {
                this.selfEjectInventory = Capabilities.ITEM.createCache((ServerLevel)this.level, ejectPos, oppositeDirection);
            }
            IItemHandler ejectHandler = (IItemHandler)this.selfEjectInventory.getCapability();
            if (this.ejectInventory == null) {
                this.ejectInventory = Capabilities.ITEM.createCache((ServerLevel)this.level, ejectPos.relative(oppositeDirection), direction);
            }
            IItemHandler targetHandler = (IItemHandler)this.ejectInventory.getCapability();
            if (ejectHandler != null && targetHandler != null && !(ejectMap = InventoryUtils.getEjectItemMap(ejectHandler, this.mainSlots)).isEmpty() && !(response = ejectMap.eject(this, ejectPos, targetHandler, 0, LogisticalTransporterBase::getColor)).isEmpty()) {
                response.useAll();
            }
            this.delayTicks = 10;
        } else if (this.delayTicks > 0) {
            --this.delayTicks;
        }
        return sendUpdatePacket;
    }

    public void updateFromSearch(Long2ObjectMap<BitSet> oresToMine, int found) {
        this.oresToMine = oresToMine;
        this.cachedToMine = found;
        this.updateTargetChunk(null);
        this.markForSave();
    }

    public int getDelay() {
        return this.delayLength;
    }

    @ComputerMethod(methodDescription="Whether Silk Touch mode is enabled or not")
    public boolean getSilkTouch() {
        return this.silkTouch;
    }

    @ComputerMethod(methodDescription="Get the current radius configured (blocks)")
    public int getRadius() {
        return this.radius;
    }

    @ComputerMethod(methodDescription="Gets the configured minimum Y level for mining")
    public int getMinY() {
        return this.minY;
    }

    @ComputerMethod(methodDescription="Gets the configured maximum Y level for mining")
    public int getMaxY() {
        return this.maxY;
    }

    @ComputerMethod(nameOverride="getInverseMode", methodDescription="Whether Inverse Mode is enabled or not")
    public boolean getInverse() {
        return this.inverse;
    }

    @ComputerMethod(nameOverride="getInverseModeRequiresReplacement", methodDescription="Whether Inverse Mode Require Replacement is turned on")
    public boolean getInverseRequiresReplacement() {
        return this.inverseRequiresReplacement;
    }

    @ComputerMethod(nameOverride="getInverseModeReplaceTarget", methodDescription="Get the configured Replacement target item")
    public Item getInverseReplaceTarget() {
        return this.inverseReplaceTarget;
    }

    private void setSilkTouch(boolean newSilkTouch) {
        if (this.silkTouch != newSilkTouch) {
            this.silkTouch = newSilkTouch;
            if (this.hasLevel() && !this.isRemote()) {
                this.energyContainer.updateMinerEnergyPerTick();
            }
        }
    }

    public void toggleSilkTouch() {
        this.setSilkTouch(!this.getSilkTouch());
        this.markForSave();
    }

    public void toggleInverse() {
        this.inverse = !this.inverse;
        this.markForSave();
    }

    public void toggleInverseRequiresReplacement() {
        this.inverseRequiresReplacement = !this.inverseRequiresReplacement;
        this.markForSave();
    }

    public void setInverseReplaceTarget(Item target) {
        if (target != this.inverseReplaceTarget) {
            this.inverseReplaceTarget = target;
            this.markForSave();
        }
    }

    public void toggleAutoEject() {
        this.doEject = !this.doEject;
        this.markForSave();
    }

    public void toggleAutoPull() {
        this.doPull = !this.doPull;
        this.markForSave();
    }

    public void setRadiusFromPacket(int newRadius) {
        this.setRadius(Mth.clamp((int)newRadius, (int)0, (int)MekanismConfig.general.minerMaxRadius.get()));
        this.sendUpdatePacket();
        this.markForSave();
    }

    private void setRadius(int newRadius) {
        if (this.radius != newRadius && newRadius >= 0) {
            this.radius = newRadius;
            if (this.hasLevel() && !this.isRemote()) {
                this.energyContainer.updateMinerEnergyPerTick();
                this.getChunkLoader().refreshChunkTickets();
            }
        }
    }

    public void setMinYFromPacket(int newMinY) {
        if (this.level != null) {
            this.setMinY(Mth.clamp((int)newMinY, (int)this.level.getMinBuildHeight(), (int)this.getMaxY()));
            this.sendUpdatePacket();
            this.markForSave();
        }
    }

    private void setMinY(int newMinY) {
        if (this.minY != newMinY) {
            this.minY = newMinY;
            if (this.hasLevel() && !this.isRemote()) {
                this.energyContainer.updateMinerEnergyPerTick();
            }
        }
    }

    public void setMaxYFromPacket(int newMaxY) {
        if (this.level != null) {
            this.setMaxY(Mth.clamp((int)newMaxY, (int)this.getMinY(), (int)(this.level.getMaxBuildHeight() - 1)));
            this.sendUpdatePacket();
            this.markForSave();
        }
    }

    private void setMaxY(int newMaxY) {
        if (this.maxY != newMaxY) {
            this.maxY = newMaxY;
            if (this.hasLevel() && !this.isRemote()) {
                this.energyContainer.updateMinerEnergyPerTick();
            }
        }
    }

    private void tryMineBlock() {
        BlockPos startingPos = this.getStartingPos();
        int diameter = this.getDiameter();
        long target = this.targetChunk == null ? ChunkPos.INVALID_CHUNK_POS : this.targetChunk.toLong();
        ObjectIterator it = this.oresToMine.long2ObjectEntrySet().iterator();
        block0: while (it.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)it.next();
            long chunk = entry.getLongKey();
            BitSet chunkToMine = (BitSet)entry.getValue();
            ChunkPos currentChunk = null;
            if (target == chunk) {
                currentChunk = this.targetChunk;
            }
            int previous = chunkToMine.length() - 1;
            while (true) {
                BlockState state;
                BlockPos pos;
                Optional<BlockState> blockState;
                int index;
                if ((index = chunkToMine.previousSetBit(previous)) == -1) {
                    it.remove();
                    continue block0;
                }
                if (currentChunk == null) {
                    currentChunk = new ChunkPos(chunk);
                    this.updateTargetChunk(currentChunk);
                    target = chunk;
                }
                if ((blockState = WorldUtils.getBlockState((BlockGetter)this.level, pos = TileEntityDigitalMiner.getOffsetForIndex(startingPos, diameter, index))).isPresent() && !(state = blockState.get()).isAir() && !state.is(MekanismTags.Blocks.MINER_BLACKLIST)) {
                    MinerFilter matchingFilter = null;
                    for (MinerFilter filter : this.filterManager.getEnabledFilters()) {
                        if (!filter.canFilter(state)) continue;
                        matchingFilter = filter;
                        break;
                    }
                    if (this.inverse == (matchingFilter == null) && this.canMine(state, pos)) {
                        List<ItemStack> drops = this.getDrops((ServerLevel)this.level, state, pos);
                        if (this.canInsert(drops)) {
                            CommonWorldTickHandler.fallbackItemCollector = this.overflowCollector;
                            if (this.setReplace(state, pos, matchingFilter)) {
                                this.add(drops);
                                this.tryAddOverflow();
                                this.missingStack = ItemStack.EMPTY;
                                this.level.levelEvent(2001, pos, Block.getId((BlockState)state));
                                --this.cachedToMine;
                                chunkToMine.clear(index);
                                if (chunkToMine.isEmpty()) {
                                    it.remove();
                                    this.updateTargetChunk(null);
                                }
                            }
                            CommonWorldTickHandler.fallbackItemCollector = null;
                        }
                        return;
                    }
                }
                --this.cachedToMine;
                chunkToMine.clear(index);
                if (chunkToMine.isEmpty()) {
                    it.remove();
                    continue block0;
                }
                previous = index - 1;
            }
        }
        this.updateTargetChunk(null);
    }

    private boolean setReplace(BlockState state, BlockPos pos, @Nullable MinerFilter<?> filter) {
        ItemStack stack;
        Item replaceTarget;
        if (this.level == null) {
            return false;
        }
        if (filter == null) {
            replaceTarget = this.inverseReplaceTarget;
            stack = this.getReplace(replaceTarget, this::inverseReplaceTargetMatches);
        } else {
            replaceTarget = filter.replaceTarget;
            stack = this.getReplace(replaceTarget, filter::replaceTargetMatches);
        }
        if (stack.isEmpty()) {
            if (replaceTarget == Items.AIR || filter == null && !this.inverseRequiresReplacement || filter != null && !filter.requiresReplacement) {
                this.level.removeBlock(pos, false);
                this.level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of(null, (BlockState)state));
                return true;
            }
            this.missingStack = new ItemStack((ItemLike)replaceTarget);
            return false;
        }
        BlockState newState = this.getStateForPlacement(stack, pos);
        if (newState == null || !newState.canSurvive((LevelReader)this.level, pos)) {
            return false;
        }
        this.level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of(null, (BlockState)state));
        this.level.setBlockAndUpdate(pos, newState);
        this.level.gameEvent((Holder)GameEvent.BLOCK_PLACE, pos, GameEvent.Context.of(null, (BlockState)newState));
        return true;
    }

    private boolean canMine(BlockState state, BlockPos pos) {
        MekFakePlayer dummy = MekFakePlayer.setupFakePlayer((ServerLevel)this.level, this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ());
        dummy.setEmulatingUUID(this.getOwnerUUID());
        boolean canMine = !((BlockEvent.BreakEvent)NeoForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(this.level, pos, state, (Player)dummy))).isCanceled();
        dummy.cleanupFakePlayer((ServerLevel)this.level);
        return canMine;
    }

    private BlockState getStateForPlacement(ItemStack stack, BlockPos pos) {
        MekFakePlayer dummy = MekFakePlayer.setupFakePlayer((ServerLevel)this.level, this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ());
        dummy.setEmulatingUUID(this.getOwnerUUID());
        BlockState result = StackUtils.getStateForPlacement(stack, pos, (Player)dummy);
        dummy.cleanupFakePlayer((ServerLevel)this.level);
        return result;
    }

    private ItemStack getReplace(Item replaceTarget, Predicate<Item> replaceStackMatches) {
        if (replaceTarget == Items.AIR) {
            return ItemStack.EMPTY;
        }
        for (IInventorySlot slot : this.mainSlots) {
            ItemStack slotStack = slot.getStack();
            if (!replaceStackMatches.test(slotStack.getItem())) continue;
            MekanismUtils.logMismatchedStackSize(slot.shrinkStack(1, Action.EXECUTE), 1L);
            return slotStack.copyWithCount(1);
        }
        if ((replaceTarget == Items.COBBLESTONE || replaceTarget == Items.STONE) && this.upgradeComponent.isUpgradeInstalled(Upgrade.STONE_GENERATOR)) {
            return new ItemStack((ItemLike)replaceTarget);
        }
        if (this.doPull) {
            TransitRequest.TransitResponse response;
            TransitRequest request;
            IItemHandler pullInv;
            if (this.pullInventory == null) {
                this.pullInventory = Capabilities.ITEM.createCache((ServerLevel)this.level, this.getBlockPos().above(2), Direction.DOWN);
            }
            if ((pullInv = (IItemHandler)this.pullInventory.getCapability()) != null && !(request = TransitRequest.definedItem(pullInv, 1, Finder.item(replaceTarget))).isEmpty() && (response = request.createSimpleResponse()).useAll().isEmpty()) {
                return response.getStack().copyWithCount(1);
            }
        }
        return ItemStack.EMPTY;
    }

    @Override
    protected void invalidateDirectionCaches(Direction newDirection) {
        super.invalidateDirectionCaches(newDirection);
        this.ejectInventory = null;
        this.selfEjectInventory = null;
    }

    public boolean canInsert(List<ItemStack> toInsert) {
        if (toInsert.isEmpty()) {
            return true;
        }
        int slots = this.mainSlots.size();
        Int2ObjectOpenHashMap cachedStacks = new Int2ObjectOpenHashMap(slots);
        for (int i = 0; i < slots; ++i) {
            IInventorySlot slot = this.mainSlots.get(i);
            if (slot.isEmpty()) continue;
            cachedStacks.put(i, (Object)new ItemCount(slot.getStack(), slot.getCount()));
        }
        for (ItemStack stackToInsert : toInsert) {
            ItemStack stack = this.simulateInsert((Int2ObjectMap<ItemCount>)cachedStacks, slots, stackToInsert);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private ItemStack simulateInsert(Int2ObjectMap<ItemCount> cachedStacks, int slots, ItemStack stackToInsert) {
        int i;
        if (stackToInsert.isEmpty()) {
            return stackToInsert;
        }
        ItemStack stack = stackToInsert.copy();
        for (i = 0; i < slots; ++i) {
            IInventorySlot slot;
            int limit;
            ItemCount cachedItem = (ItemCount)cachedStacks.get(i);
            if (cachedItem == null || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)cachedItem.stack) || cachedItem.count >= (limit = (slot = this.mainSlots.get(i)).getLimit(stack))) continue;
            cachedItem.count += stack.getCount();
            if (cachedItem.count <= limit) {
                return ItemStack.EMPTY;
            }
            stack = stack.copyWithCount(cachedItem.count - limit);
            cachedItem.count = limit;
        }
        for (i = 0; i < slots; ++i) {
            if (cachedStacks.containsKey(i)) continue;
            IInventorySlot slot = this.mainSlots.get(i);
            int stackSize = stack.getCount();
            int remainderSize = (stack = slot.insertItem(stack, Action.SIMULATE, AutomationType.INTERNAL)).getCount();
            if (remainderSize >= stackSize) continue;
            cachedStacks.put(i, (Object)new ItemCount(stackToInsert, stackSize - remainderSize));
            if (!stack.isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return stack;
    }

    private void add(List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if ((stack = InventoryUtils.insertItem(this.mainSlots, stack, Action.EXECUTE, AutomationType.INTERNAL)).isEmpty()) continue;
            this.trackOverflow(stack);
        }
    }

    private boolean trackOverflow(ItemStack stack) {
        if (!stack.isEmpty()) {
            this.overflow.mergeInt((Object)HashedItem.create(stack), stack.getCount(), Integer::sum);
            this.hasOverflow = true;
            this.recheckOverflow = true;
            this.markForSave();
            return true;
        }
        return false;
    }

    private void tryAddOverflow() {
        if (this.hasOverflow) {
            boolean recheck = false;
            ObjectIterator iter = this.overflow.object2IntEntrySet().iterator();
            while (iter.hasNext()) {
                Object2IntMap.Entry entry = (Object2IntMap.Entry)iter.next();
                int amount = entry.getIntValue();
                ItemStack stack = ((HashedItem)entry.getKey()).createStack(amount);
                if ((stack = InventoryUtils.insertItem(this.mainSlots, stack, Action.EXECUTE, AutomationType.INTERNAL)).isEmpty()) {
                    iter.remove();
                    recheck = true;
                    continue;
                }
                if (stack.getCount() == amount) continue;
                entry.setValue(stack.getCount());
            }
            if (recheck) {
                this.hasOverflow = !this.overflow.isEmpty();
            }
        }
        this.recheckOverflow = false;
    }

    public void start() {
        if (this.getLevel() == null) {
            return;
        }
        if (this.searcher.state == ThreadMinerSearch.State.IDLE) {
            BlockPos startingPos = this.getStartingPos();
            int diameter = this.getDiameter();
            this.searcher.setChunkCache(new PathNavigationRegion(this.getLevel(), startingPos, startingPos.offset(diameter, this.getMaxY() - this.getMinY() + 1, diameter)));
            this.searcher.start();
        }
        this.running = true;
        this.markForSave();
    }

    public void stop() {
        if (this.searcher.state == ThreadMinerSearch.State.SEARCHING) {
            this.searcher.interrupt();
            this.reset();
        } else if (this.searcher.state == ThreadMinerSearch.State.FINISHED) {
            this.running = false;
            this.markForSave();
            this.updateTargetChunk(null);
        }
    }

    public void reset() {
        this.searcher = new ThreadMinerSearch(this);
        this.running = false;
        this.cachedToMine = 0;
        this.oresToMine = Long2ObjectMaps.emptyMap();
        this.missingStack = ItemStack.EMPTY;
        this.setActive(false);
        this.updateTargetChunk(null);
        this.markForSave();
    }

    public static boolean isSavedReplaceTarget(ItemStack stack, Item target) {
        if (((Boolean)stack.getOrDefault(MekanismDataComponents.INVERSE, (Object)false)).booleanValue()) {
            Item inverseReplaceTarget = (Item)stack.getOrDefault(MekanismDataComponents.REPLACE_STACK, (Object)Items.AIR);
            return inverseReplaceTarget != Items.AIR && inverseReplaceTarget == target;
        }
        FilterAware filterAware = (FilterAware)stack.get(MekanismDataComponents.FILTER_AWARE);
        return filterAware != null && filterAware.anyEnabledMatch(MinerFilter.class, filter -> filter.replaceTargetMatches(target));
    }

    public boolean isReplaceTarget(Item target) {
        if (this.inverse) {
            return this.inverseReplaceTargetMatches(target);
        }
        return this.filterManager.anyEnabledMatch(target, MinerFilter::replaceTargetMatches);
    }

    private boolean inverseReplaceTargetMatches(Item target) {
        return this.inverseReplaceTarget != Items.AIR && this.inverseReplaceTarget == target;
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.running = nbt.getBoolean("running");
        this.delay = nbt.getInt("delay");
        this.numPowering = nbt.getInt("num_powering");
        NBTUtils.setEnumIfPresent(nbt, "state", ThreadMinerSearch.State.BY_ID, s -> {
            if (!this.initCalc && s == ThreadMinerSearch.State.SEARCHING) {
                s = ThreadMinerSearch.State.FINISHED;
            }
            this.searcher.state = s;
        });
        this.energyContainer.updateMinerEnergyPerTick();
    }

    @Override
    @Deprecated
    public void removeComponentsFromTag(@NotNull CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("num_powering");
        tag.remove("state");
    }

    @Override
    public void setLevel(@NotNull Level world) {
        super.setLevel(world);
        this.energyContainer.updateMinerEnergyPerTick();
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag nbtTags, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(nbtTags, provider);
        nbtTags.putBoolean("running", this.running);
        nbtTags.putInt("delay", this.delay);
        nbtTags.putInt("num_powering", this.numPowering);
        NBTUtils.writeEnum(nbtTags, "state", this.searcher.state);
        if (!this.overflow.isEmpty()) {
            nbtTags.put("overflow", (Tag)OverflowAware.writeOverflow(provider, this.overflow));
        }
    }

    public int getTotalSize() {
        int diameter = this.getDiameter();
        return diameter * diameter * (this.getMaxY() - this.getMinY() + 1);
    }

    public int getDiameter() {
        return this.radius * 2 + 1;
    }

    public BlockPos getStartingPos() {
        return new BlockPos(this.getBlockPos().getX() - this.radius, this.getMinY(), this.getBlockPos().getZ() - this.radius);
    }

    public static BlockPos getOffsetForIndex(BlockPos start, int diameter, int index) {
        return start.offset(index % diameter, index / diameter / diameter, index / diameter % diameter);
    }

    @Override
    public boolean isPowered() {
        return this.redstone || this.numPowering > 0;
    }

    @Override
    public boolean isClientRendering() {
        return this.clientRendering;
    }

    @Override
    public void toggleClientRendering() {
        this.clientRendering = !this.clientRendering;
    }

    @Override
    public boolean canDisplayVisuals() {
        return this.getRadius() <= 64;
    }

    @Override
    public void onBoundingBlockPowerChange(BlockPos boundingPos, int oldLevel, int newLevel) {
        if (oldLevel > 0) {
            if (newLevel == 0) {
                --this.numPowering;
            }
        } else if (newLevel > 0) {
            ++this.numPowering;
        }
    }

    @Override
    public int getBoundingComparatorSignal(Vec3i offset) {
        Direction facing = this.getDirection();
        Direction back = facing.getOpposite();
        if (offset.equals((Object)new Vec3i(back.getStepX(), 1, back.getStepZ()))) {
            return this.getCurrentRedstoneLevel();
        }
        Direction left = MekanismUtils.getLeft(facing);
        if (offset.equals((Object)new Vec3i(left.getStepX(), 0, left.getStepZ()))) {
            return this.getCurrentRedstoneLevel();
        }
        Direction right = left.getOpposite();
        if (offset.equals((Object)new Vec3i(right.getStepX(), 0, right.getStepZ()))) {
            return this.getCurrentRedstoneLevel();
        }
        return 0;
    }

    @Override
    protected void notifyComparatorChange() {
        super.notifyComparatorChange();
        Direction facing = this.getDirection();
        Direction left = MekanismUtils.getLeft(facing);
        this.level.updateNeighbourForOutputSignal(this.worldPosition.relative(left), (Block)MekanismBlocks.BOUNDING_BLOCK.getBlock());
        this.level.updateNeighbourForOutputSignal(this.worldPosition.relative(left.getOpposite()), (Block)MekanismBlocks.BOUNDING_BLOCK.getBlock());
        this.level.updateNeighbourForOutputSignal(this.worldPosition.relative(facing.getOpposite()).above(), (Block)MekanismBlocks.BOUNDING_BLOCK.getBlock());
    }

    @Override
    public void configurationDataSet() {
        super.configurationDataSet();
        if (this.isRunning()) {
            this.stop();
            this.reset();
            this.start();
        }
    }

    @Override
    public void writeSustainedData(HolderLookup.Provider provider, CompoundTag dataMap) {
        super.writeSustainedData(provider, dataMap);
        dataMap.putInt("radius", this.getRadius());
        dataMap.putInt("min", this.getMinY());
        dataMap.putInt("max", this.getMaxY());
        dataMap.putBoolean("eject", this.doEject);
        dataMap.putBoolean("pull", this.doPull);
        dataMap.putBoolean("silk_touch", this.getSilkTouch());
        dataMap.putBoolean("inverse", this.inverse);
        if (this.inverseReplaceTarget != Items.AIR) {
            NBTUtils.writeRegistryEntry(dataMap, "replace_target", BuiltInRegistries.ITEM, this.inverseReplaceTarget);
        }
        dataMap.putBoolean("inverse_replace", this.inverseRequiresReplacement);
        this.filterManager.writeToNBT(provider, dataMap);
    }

    @Override
    public void readSustainedData(HolderLookup.Provider provider, @NotNull CompoundTag dataMap) {
        super.readSustainedData(provider, dataMap);
        this.setRadius(Math.min(dataMap.getInt("radius"), MekanismConfig.general.minerMaxRadius.get()));
        NBTUtils.setIntIfPresent(dataMap, "min", newMinY -> {
            if (this.hasLevel() && !this.isRemote()) {
                this.setMinY(Math.max(newMinY, this.level.getMinBuildHeight()));
            } else {
                this.setMinY(newMinY);
            }
        });
        NBTUtils.setIntIfPresent(dataMap, "max", newMaxY -> {
            if (this.hasLevel() && !this.isRemote()) {
                this.setMaxY(Math.min(newMaxY, this.level.getMaxBuildHeight() - 1));
            } else {
                this.setMaxY(newMaxY);
            }
        });
        NBTUtils.setBooleanIfPresent(dataMap, "eject", eject -> {
            this.doEject = eject;
        });
        NBTUtils.setBooleanIfPresent(dataMap, "pull", pull -> {
            this.doPull = pull;
        });
        NBTUtils.setBooleanIfPresent(dataMap, "silk_touch", this::setSilkTouch);
        NBTUtils.setBooleanIfPresent(dataMap, "inverse", inverse -> {
            this.inverse = inverse;
        });
        this.inverseReplaceTarget = NBTUtils.readRegistryEntry(dataMap, "replace_target", BuiltInRegistries.ITEM, Items.AIR);
        NBTUtils.setBooleanIfPresent(dataMap, "inverse_replace", requiresReplace -> {
            this.inverseRequiresReplacement = requiresReplace;
        });
        this.filterManager.readFromNBT(provider, dataMap);
        NBTUtils.setListIfPresent(dataMap, "overflow", 10, overflowTag -> {
            this.overflow.clear();
            OverflowAware.readOverflow(provider, this.overflow, overflowTag);
            this.recheckOverflow = this.hasOverflow = !this.overflow.isEmpty();
        });
    }

    @Override
    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(MekanismDataComponents.RADIUS, (Object)this.getRadius());
        builder.set(MekanismDataComponents.MIN_Y, (Object)this.getMinY());
        builder.set(MekanismDataComponents.MAX_Y, (Object)this.getMaxY());
        builder.set(MekanismDataComponents.EJECT, (Object)this.doEject);
        builder.set(MekanismDataComponents.PULL, (Object)this.doPull);
        builder.set(MekanismDataComponents.SILK_TOUCH, (Object)this.getSilkTouch());
        builder.set(MekanismDataComponents.INVERSE, (Object)this.inverse);
        builder.set(MekanismDataComponents.REPLACE_STACK, (Object)this.inverseReplaceTarget);
        builder.set(MekanismDataComponents.INVERSE_REQUIRES_REPLACE, (Object)this.inverseRequiresReplacement);
        builder.set(MekanismDataComponents.OVERFLOW_AWARE, (Object)new OverflowAware((Object2IntSortedMap<HashedItem>)new Object2IntLinkedOpenHashMap(this.overflow)));
    }

    @Override
    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.setRadius(Math.min((Integer)input.getOrDefault(MekanismDataComponents.RADIUS, (Object)this.radius), MekanismConfig.general.minerMaxRadius.get()));
        int newMinY = (Integer)input.getOrDefault(MekanismDataComponents.MIN_Y, (Object)this.minY);
        int newMaxY = (Integer)input.getOrDefault(MekanismDataComponents.MAX_Y, (Object)this.minY);
        if (this.level != null && !this.isRemote()) {
            this.setMinY(Math.max(newMinY, this.level.getMinBuildHeight()));
            this.setMaxY(Math.min(newMaxY, this.level.getMaxBuildHeight() - 1));
        } else {
            this.setMinY(newMinY);
            this.setMaxY(newMaxY);
        }
        this.doEject = (Boolean)input.getOrDefault(MekanismDataComponents.EJECT, (Object)this.doEject);
        this.doPull = (Boolean)input.getOrDefault(MekanismDataComponents.PULL, (Object)this.doPull);
        this.setSilkTouch((Boolean)input.getOrDefault(MekanismDataComponents.SILK_TOUCH, (Object)this.silkTouch));
        this.inverse = (Boolean)input.getOrDefault(MekanismDataComponents.INVERSE, (Object)this.inverse);
        this.inverseReplaceTarget = (Item)input.getOrDefault(MekanismDataComponents.REPLACE_STACK, (Object)this.inverseReplaceTarget);
        this.inverseRequiresReplacement = (Boolean)input.getOrDefault(MekanismDataComponents.INVERSE_REQUIRES_REPLACE, (Object)this.inverseRequiresReplacement);
        this.overflow.clear();
        this.overflow.putAll(((OverflowAware)input.getOrDefault(MekanismDataComponents.OVERFLOW_AWARE, (Object)OverflowAware.EMPTY)).overflow());
        this.recheckOverflow = this.hasOverflow = !this.overflow.isEmpty();
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.delayLength = MekanismUtils.getTicks(this, MekanismConfig.general.minerTicksPerMine.get());
        }
    }

    @Override
    @NotNull
    public List<Component> getInfo(@NotNull Upgrade upgrade) {
        return UpgradeUtils.getMultScaledInfo(this, upgrade);
    }

    @Override
    @Nullable
    public <T> T getOffsetCapabilityIfEnabled(@NotNull BlockCapability<T, @Nullable Direction> capability, Direction side, @NotNull Vec3i offset) {
        if (capability == Capabilities.ITEM.block()) {
            return Objects.requireNonNull(this.itemHandlerManager, "Expected to have item handler").resolve(capability, side);
        }
        return WorldUtils.getCapability(this.level, capability, this.worldPosition, null, this, side);
    }

    @Override
    public boolean isOffsetCapabilityDisabled(@NotNull BlockCapability<?, @Nullable Direction> capability, Direction side, @NotNull Vec3i offset) {
        if (capability == Capabilities.ITEM.block()) {
            return this.notItemPort(side, offset);
        }
        if (EnergyCompatUtils.isEnergyCapability(capability)) {
            return this.notEnergyPort(side, offset);
        }
        return this.notItemPort(side, offset) && this.notEnergyPort(side, offset);
    }

    private boolean notItemPort(Direction side, Vec3i offset) {
        if (offset.equals((Object)new Vec3i(0, 1, 0))) {
            return side != Direction.UP;
        }
        Direction back = this.getOppositeDirection();
        if (offset.equals((Object)new Vec3i(back.getStepX(), 1, back.getStepZ()))) {
            return side != back;
        }
        return true;
    }

    private boolean notEnergyPort(Direction side, Vec3i offset) {
        if (offset.equals((Object)Vec3i.ZERO)) {
            return side != Direction.DOWN;
        }
        Direction left = this.getLeftSide();
        if (offset.equals((Object)new Vec3i(left.getStepX(), 0, left.getStepZ()))) {
            return side != left;
        }
        Direction right = left.getOpposite();
        if (offset.equals((Object)new Vec3i(right.getStepX(), 0, right.getStepZ()))) {
            return side != right;
        }
        return true;
    }

    public TileComponentChunkLoader<TileEntityDigitalMiner> getChunkLoader() {
        return this.chunkLoaderComponent;
    }

    private void updateTargetChunk(@Nullable ChunkPos target) {
        if (!Objects.equals(this.targetChunk, target)) {
            this.targetChunk = target;
            this.getChunkLoader().refreshChunkTickets();
        }
    }

    @Override
    public Set<ChunkPos> getChunkSet() {
        ChunkPos minerChunk = new ChunkPos(this.worldPosition);
        if (this.targetChunk != null && SectionPos.blockToSectionCoord((int)(this.worldPosition.getX() - this.radius)) <= this.targetChunk.x && this.targetChunk.x <= SectionPos.blockToSectionCoord((int)(this.worldPosition.getX() + this.radius)) && SectionPos.blockToSectionCoord((int)(this.worldPosition.getZ() - this.radius)) <= this.targetChunk.z && this.targetChunk.z <= SectionPos.blockToSectionCoord((int)(this.worldPosition.getZ() + this.radius))) {
            if (minerChunk.equals((Object)this.targetChunk)) {
                return Set.of(minerChunk);
            }
            return Set.of(minerChunk, this.targetChunk);
        }
        return Collections.singleton(minerChunk);
    }

    @Override
    public SortableFilterManager<MinerFilter<?>> getFilterManager() {
        return this.filterManager;
    }

    public MinerEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }

    @ComputerMethod(methodDescription="Get the count of block found but not yet mined")
    public int getToMine() {
        return !this.isRemote() && this.searcher.state == ThreadMinerSearch.State.SEARCHING ? this.searcher.found : this.cachedToMine;
    }

    @ComputerMethod(methodDescription="Whether the miner is currently running")
    public boolean isRunning() {
        return this.running;
    }

    @ComputerMethod(nameOverride="getAutoEject", methodDescription="Whether Auto Eject is turned on")
    public boolean getDoEject() {
        return this.doEject;
    }

    @ComputerMethod(nameOverride="getAutoPull", methodDescription="Whether Auto Pull is turned on")
    public boolean getDoPull() {
        return this.doPull;
    }

    public boolean hasOverflow() {
        return this.hasOverflow;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        this.addConfigContainerTrackers(container);
        container.track(SyncableBoolean.create(this::getDoEject, value -> {
            this.doEject = value;
        }));
        container.track(SyncableBoolean.create(this::getDoPull, value -> {
            this.doPull = value;
        }));
        container.track(SyncableBoolean.create(this::isRunning, value -> {
            this.running = value;
        }));
        container.track(SyncableBoolean.create(this::getSilkTouch, this::setSilkTouch));
        container.track(SyncableEnum.create(ThreadMinerSearch.State.BY_ID, ThreadMinerSearch.State.IDLE, () -> this.searcher.state, value -> {
            this.searcher.state = value;
        }));
        container.track(SyncableInt.create(this::getToMine, value -> {
            this.cachedToMine = value;
        }));
        container.track(SyncableItemStack.create(() -> this.missingStack, value -> {
            this.missingStack = value;
        }));
        container.track(SyncableBoolean.create(this::hasOverflow, value -> {
            this.hasOverflow = value;
        }));
    }

    public void addConfigContainerTrackers(MekanismContainer container) {
        container.track(SyncableInt.create(this::getRadius, this::setRadius));
        container.track(SyncableInt.create(this::getMinY, this::setMinY));
        container.track(SyncableInt.create(this::getMaxY, this::setMaxY));
        container.track(SyncableBoolean.create(this::getInverse, value -> {
            this.inverse = value;
        }));
        container.track(SyncableBoolean.create(this::getInverseRequiresReplacement, value -> {
            this.inverseRequiresReplacement = value;
        }));
        container.track(SyncableRegistryEntry.create(BuiltInRegistries.ITEM, this::getInverseReplaceTarget, value -> {
            this.inverseReplaceTarget = value;
        }));
        this.filterManager.addContainerTrackers(container);
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getReducedUpdateTag(provider);
        updateTag.putInt("radius", this.getRadius());
        updateTag.putInt("min", this.getMinY());
        updateTag.putInt("max", this.getMaxY());
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        NBTUtils.setIntIfPresent(tag, "radius", this::setRadius);
        NBTUtils.setIntIfPresent(tag, "min", this::setMinY);
        NBTUtils.setIntIfPresent(tag, "max", this::setMaxY);
    }

    private List<ItemStack> getDrops(ServerLevel level, BlockState state, BlockPos pos) {
        if (state.isAir()) {
            return Collections.emptyList();
        }
        ItemStack stack = ItemAtomicDisassembler.fullyChargedStack();
        if (this.getSilkTouch()) {
            stack.enchant(level.holderOrThrow(Enchantments.SILK_TOUCH), 1);
        }
        MekFakePlayer dummy = MekFakePlayer.setupFakePlayer(level, this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ());
        dummy.setEmulatingUUID(this.getOwnerUUID());
        List<ItemStack> drops = WorldUtils.getDrops(state, level, pos, WorldUtils.getTileEntity((BlockGetter)level, pos), (Entity)dummy, stack);
        dummy.cleanupFakePlayer(level);
        return drops;
    }

    @ComputerMethod(methodDescription="Get the energy used in the last tick by the machine")
    FloatingLong getEnergyUsage() {
        return this.getActive() ? this.energyContainer.getEnergyPerTick() : FloatingLong.ZERO;
    }

    @ComputerMethod(methodDescription="Get the size of the Miner's internal inventory")
    int getSlotCount() {
        return this.mainSlots.size();
    }

    @ComputerMethod(methodDescription="Get the contents of the internal inventory slot. 0 based.")
    ItemStack getItemInSlot(int slot) throws ComputerException {
        int slots = this.getSlotCount();
        if (slot < 0 || slot >= slots) {
            throw new ComputerException("Slot: '%d' is out of bounds, as this digital miner only has '%d' slots (zero indexed).", slot, slots);
        }
        return this.mainSlots.get(slot).getStack();
    }

    @ComputerMethod(methodDescription="Get the state of the Miner's search")
    ThreadMinerSearch.State getState() {
        return this.searcher.state;
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Update the Auto Eject setting")
    void setAutoEject(boolean eject) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.doEject != eject) {
            this.toggleAutoEject();
        }
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Update the Auto Pull setting")
    void setAutoPull(boolean pull) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.doPull != pull) {
            this.toggleAutoPull();
        }
    }

    @ComputerMethod(nameOverride="setSilkTouch", requiresPublicSecurity=true, methodDescription="Update the Silk Touch setting")
    void computerSetSilkTouch(boolean silk) throws ComputerException {
        this.validateSecurityIsPublic();
        this.setSilkTouch(silk);
    }

    @ComputerMethod(nameOverride="start", requiresPublicSecurity=true, methodDescription="Attempt to start the mining process")
    void computerStart() throws ComputerException {
        this.validateSecurityIsPublic();
        this.start();
    }

    @ComputerMethod(nameOverride="stop", requiresPublicSecurity=true, methodDescription="Attempt to stop the mining process")
    void computerStop() throws ComputerException {
        this.validateSecurityIsPublic();
        this.stop();
    }

    @ComputerMethod(nameOverride="reset", requiresPublicSecurity=true, methodDescription="Stop the mining process and reset the Miner to be able to change settings")
    void computerReset() throws ComputerException {
        this.validateSecurityIsPublic();
        this.reset();
    }

    @ComputerMethod(methodDescription="Get the maximum allowable Radius value, determined from the mod's config")
    int getMaxRadius() {
        return MekanismConfig.general.minerMaxRadius.get();
    }

    private void validateCanChangeConfiguration() throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.searcher.state != ThreadMinerSearch.State.IDLE) {
            throw new ComputerException("Miner must be stopped and reset before its targeting configuration is changed.");
        }
    }

    @ComputerMethod(nameOverride="setRadius", requiresPublicSecurity=true, methodDescription="Update the mining radius (blocks). Requires miner to be stopped/reset first")
    void computerSetRadius(int radius) throws ComputerException {
        this.validateCanChangeConfiguration();
        if (radius < 0 || radius > MekanismConfig.general.minerMaxRadius.get()) {
            throw new ComputerException("Radius '%d' is out of range must be between 0 and %d. (Inclusive)", radius, MekanismConfig.general.minerMaxRadius.get());
        }
        this.setRadiusFromPacket(radius);
    }

    @ComputerMethod(nameOverride="setMinY", requiresPublicSecurity=true, methodDescription="Update the minimum Y level for mining. Requires miner to be stopped/reset first")
    void computerSetMinY(int minY) throws ComputerException {
        this.validateCanChangeConfiguration();
        if (this.level != null) {
            int min = this.level.getMinBuildHeight();
            if (minY < min || minY > this.getMaxY()) {
                throw new ComputerException("Min Y '%d' is out of range must be between %d and %d. (Inclusive)", minY, min, this.getMaxY());
            }
            this.setMinYFromPacket(minY);
        }
    }

    @ComputerMethod(nameOverride="setMaxY", requiresPublicSecurity=true, methodDescription="Update the maximum Y level for mining. Requires miner to be stopped/reset first")
    void computerSetMaxY(int maxY) throws ComputerException {
        this.validateCanChangeConfiguration();
        if (this.level != null) {
            int max = this.level.getMaxBuildHeight() - 1;
            if (maxY < this.getMinY() || maxY > max) {
                throw new ComputerException("Max Y '%d' is out of range must be between %d and %d. (Inclusive)", maxY, this.getMinY(), max);
            }
            this.setMaxYFromPacket(maxY);
        }
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Update the Inverse Mode setting. Requires miner to be stopped/reset first")
    void setInverseMode(boolean enabled) throws ComputerException {
        this.validateCanChangeConfiguration();
        if (this.inverse != enabled) {
            this.toggleInverse();
        }
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Update the Inverse Mode Requires Replacement setting. Requires miner to be stopped/reset first")
    void setInverseModeRequiresReplacement(boolean requiresReplacement) throws ComputerException {
        this.validateCanChangeConfiguration();
        if (this.inverseRequiresReplacement != requiresReplacement) {
            this.toggleInverseRequiresReplacement();
        }
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Update the target for Replacement in Inverse Mode. Requires miner to be stopped/reset first")
    void setInverseModeReplaceTarget(Item target) throws ComputerException {
        this.validateCanChangeConfiguration();
        this.setInverseReplaceTarget(target);
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Remove the target for Replacement in Inverse Mode. Requires miner to be stopped/reset first")
    void clearInverseModeReplaceTarget() throws ComputerException {
        this.setInverseModeReplaceTarget(Items.AIR);
    }

    @ComputerMethod(methodDescription="Get the current list of Miner Filters")
    Collection<MinerFilter<?>> getFilters() {
        return this.filterManager.getFilters();
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Add a new filter to the miner. Requires miner to be stopped/reset first")
    boolean addFilter(MinerFilter<?> filter) throws ComputerException {
        this.validateCanChangeConfiguration();
        return this.filterManager.addFilter(filter);
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Removes the exactly matching filter from the miner. Requires miner to be stopped/reset first")
    boolean removeFilter(MinerFilter<?> filter) throws ComputerException {
        this.validateCanChangeConfiguration();
        return this.filterManager.removeFilter(filter);
    }

    private static class ItemCount {
        private final ItemStack stack;
        private int count;

        public ItemCount(ItemStack stack, int count) {
            this.stack = stack;
            this.count = count;
        }
    }
}

