/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.interfaces.chemical;

import java.util.Collections;
import java.util.List;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.common.capabilities.chemical.dynamic.ISlurryTracker;
import mekanism.common.capabilities.chemical.dynamic.SimpleDynamicChemicalHandler;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.resolver.manager.ChemicalHandlerManager;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
public interface ISlurryTile
extends ISlurryTracker {
    @Nullable
    public ChemicalHandlerManager.SlurryHandlerManager getSlurryManager();

    @Nullable
    default public ChemicalHandlerManager.SlurryHandlerManager getInitialSlurryManager(IContentsListener listener) {
        IChemicalTankHolder<Slurry, SlurryStack, ISlurryTank> initialSlurryTanks = this.getInitialSlurryTanks(listener);
        if (initialSlurryTanks == null) {
            return null;
        }
        return new ChemicalHandlerManager.SlurryHandlerManager(initialSlurryTanks, new SimpleDynamicChemicalHandler.SimpleDynamicSlurryHandler(this::getSlurryTanks, listener));
    }

    @Nullable
    default public IChemicalTankHolder<Slurry, SlurryStack, ISlurryTank> getInitialSlurryTanks(IContentsListener listener) {
        return null;
    }

    default public boolean canHandleSlurry() {
        ChemicalHandlerManager.SlurryHandlerManager slurryManager = this.getSlurryManager();
        return slurryManager != null && slurryManager.canHandle();
    }

    @Override
    default public List<ISlurryTank> getSlurryTanks(@Nullable Direction side) {
        ChemicalHandlerManager.SlurryHandlerManager slurryManager = this.getSlurryManager();
        return slurryManager != null ? slurryManager.getContainers(side) : Collections.emptyList();
    }
}

