/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.Collections;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.IConfigurable;
import mekanism.api.IContentsListener;
import mekanism.api.MekanismAPITags;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.chemical.StackedWasteBarrel;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityRadioactiveWasteBarrel
extends TileEntityMekanism
implements IConfigurable {
    private long lastProcessTick;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getStored", "getCapacity", "getNeeded", "getFilledPercentage"}, docPlaceholder="barrel")
    StackedWasteBarrel gasTank;
    private int processTicks;
    private List<BlockCapabilityCache<IGasHandler, @Nullable Direction>> gasHandlerBelow = Collections.emptyList();

    public TileEntityRadioactiveWasteBarrel(BlockPos pos, BlockState state) {
        super(MekanismBlocks.RADIOACTIVE_WASTE_BARREL, pos, state);
        this.delaySupplier = NO_DELAY;
    }

    @Override
    @NotNull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSide(this::getDirection);
        this.gasTank = StackedWasteBarrel.create(this, listener);
        builder.addTank(this.gasTank, RelativeSide.TOP, RelativeSide.BOTTOM);
        return builder.build();
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        if (this.level.getGameTime() > this.lastProcessTick) {
            this.lastProcessTick = this.level.getGameTime();
            if (MekanismConfig.general.radioactiveWasteBarrelDecayAmount.get() > 0L && !this.gasTank.isEmpty() && !((Gas)this.gasTank.getType()).is(MekanismAPITags.Gases.WASTE_BARREL_DECAY_BLACKLIST) && ++this.processTicks >= MekanismConfig.general.radioactiveWasteBarrelProcessTicks.get()) {
                this.processTicks = 0;
                this.gasTank.shrinkStack(MekanismConfig.general.radioactiveWasteBarrelDecayAmount.get(), Action.EXECUTE);
            }
            if (this.getActive()) {
                if (this.gasHandlerBelow.isEmpty()) {
                    this.gasHandlerBelow = List.of(BlockCapabilityCache.create(Capabilities.GAS.block(), (ServerLevel)((ServerLevel)this.level), (BlockPos)this.worldPosition.below(), (Object)Direction.UP));
                }
                ChemicalUtil.emit(this.gasHandlerBelow, this.gasTank);
            }
        }
        return sendUpdatePacket;
    }

    public StackedWasteBarrel getGasTank() {
        return this.gasTank;
    }

    public double getGasScale() {
        return (double)this.gasTank.getStored() / (double)this.gasTank.getCapacity();
    }

    public GasStack getGas() {
        return (GasStack)this.gasTank.getStack();
    }

    @Override
    public InteractionResult onSneakRightClick(Player player) {
        if (!this.isRemote()) {
            this.setActive(!this.getActive());
            Level world = this.getLevel();
            if (world != null) {
                world.playSound(null, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 0.3f, 1.0f);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult onRightClick(Player player) {
        return InteractionResult.PASS;
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getReducedUpdateTag(provider);
        updateTag.put("gas", (Tag)this.gasTank.serializeNBT(provider));
        updateTag.putInt("progress", this.processTicks);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        NBTUtils.setCompoundIfPresent(tag, "gas", nbt -> this.gasTank.deserializeNBT(provider, (CompoundTag)nbt));
        NBTUtils.setIntIfPresent(tag, "progress", val -> {
            this.processTicks = val;
        });
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.gasTank.getStored(), this.gasTank.getCapacity());
    }

    @Override
    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return type == ContainerType.GAS;
    }
}

