/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.gear.ModuleData;
import mekanism.api.math.FloatingLong;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.content.gear.IModuleItem;
import mekanism.common.content.gear.ModuleContainer;
import mekanism.common.content.gear.ModuleHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityModificationStation
extends TileEntityMekanism
implements IBoundingBlock {
    private static final int BASE_TICKS_REQUIRED = 10;
    public int ticksRequired = 10;
    public int operatingTicks;
    private boolean usedEnergy = false;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy slot")
    EnergyInventorySlot energySlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getModuleItem"}, docPlaceholder="module slot")
    InputInventorySlot moduleSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getContainerItem"}, docPlaceholder="module holder slot (suit, tool, etc)")
    public InputInventorySlot containerSlot;
    private MachineEnergyContainer<TileEntityModificationStation> energyContainer;

    public TileEntityModificationStation(BlockPos pos, BlockState state) {
        super(MekanismBlocks.MODIFICATION_STATION, pos, state);
    }

    @Override
    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = MachineEnergyContainer.input(this, listener);
        builder.addContainer(this.energyContainer, RelativeSide.BACK);
        return builder.build();
    }

    public MachineEnergyContainer<TileEntityModificationStation> getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.moduleSlot = InputInventorySlot.at(stack -> stack.getItem() instanceof IModuleItem, listener, 35, 118);
        builder.addSlot(this.moduleSlot);
        this.containerSlot = InputInventorySlot.at(IModuleHelper.INSTANCE::isModuleContainer, listener, 125, 118);
        builder.addSlot(this.containerSlot);
        this.moduleSlot.setSlotType(ContainerSlotType.NORMAL);
        this.moduleSlot.setSlotOverlay(SlotOverlay.MODULE);
        this.containerSlot.setSlotType(ContainerSlotType.NORMAL);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityModificationStation)this).getLevel(), listener, 149, 21);
        builder.addSlot(this.energySlot);
        return builder.build();
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        FloatingLong clientEnergyUsed = FloatingLong.ZERO;
        if (this.canFunction()) {
            boolean operated = false;
            if (this.energyContainer.getEnergy().greaterOrEqual(this.energyContainer.getEnergyPerTick()) && !this.moduleSlot.isEmpty() && !this.containerSlot.isEmpty()) {
                ModuleData<?> data = ((IModuleItem)this.moduleSlot.getStack().getItem()).getModuleData();
                ItemStack stack = this.containerSlot.getStack();
                ModuleContainer container = ModuleHelper.get().getModuleContainer(stack);
                if (container != null && container.canInstall(stack, data)) {
                    operated = true;
                    ++this.operatingTicks;
                    clientEnergyUsed = this.energyContainer.extract(this.energyContainer.getEnergyPerTick(), Action.EXECUTE, AutomationType.INTERNAL);
                    if (this.operatingTicks == this.ticksRequired) {
                        this.operatingTicks = 0;
                        int added = container.addModule((HolderLookup.Provider)this.level.registryAccess(), stack, data, this.moduleSlot.getCount());
                        if (added > 0) {
                            this.containerSlot.setStack(stack);
                            MekanismUtils.logMismatchedStackSize(this.moduleSlot.shrinkStack(added, Action.EXECUTE), added);
                        }
                    }
                }
            }
            if (!operated) {
                this.operatingTicks = 0;
            }
        }
        this.usedEnergy = !clientEnergyUsed.isZero();
        return sendUpdatePacket;
    }

    public boolean usedEnergy() {
        return this.usedEnergy;
    }

    public void removeModule(Player player, ModuleData<?> type, boolean removeAll) {
        int installed;
        ItemStack stack = this.containerSlot.getStack();
        ModuleContainer container = ModuleHelper.get().getModuleContainer(stack);
        if (container != null && (installed = container.installedCount(type)) > 0) {
            int toRemove;
            int n = toRemove = removeAll ? installed : 1;
            if (player.getInventory().add(type.getItemProvider().getItemStack(toRemove))) {
                container.removeModule((HolderLookup.Provider)player.level().registryAccess(), stack, type, toRemove);
                this.containerSlot.setStack(stack);
            }
        }
    }

    public double getScaledProgress() {
        return (double)this.operatingTicks / (double)this.ticksRequired;
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.operatingTicks = nbt.getInt("progress");
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag nbtTags, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(nbtTags, provider);
        nbtTags.putInt("progress", this.operatingTicks);
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableInt.create(() -> this.operatingTicks, value -> {
            this.operatingTicks = value;
        }));
        container.track(SyncableBoolean.create(this::usedEnergy, value -> {
            this.usedEnergy = value;
        }));
    }
}

