/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tags;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.gas.Gas;
import mekanism.common.Mekanism;
import mekanism.common.resource.BlockResourceInfo;
import mekanism.common.resource.IResource;
import mekanism.common.resource.PrimaryResource;
import mekanism.common.resource.ResourceType;
import mekanism.common.resource.ore.OreType;
import mekanism.common.util.EnumUtils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class MekanismTags {
    private MekanismTags() {
    }

    public static class Gases {
        public static final TagKey<Gas> WATER_VAPOR = Gases.tag("water_vapor");

        private Gases() {
        }

        private static TagKey<Gas> tag(String name) {
            return TagKey.create(MekanismAPI.GAS_REGISTRY_NAME, (ResourceLocation)Mekanism.rl(name));
        }
    }

    public static class Fluids {
        public static final TagKey<Fluid> BRINE = Fluids.commonTag("brine");
        public static final TagKey<Fluid> CHLORINE = Fluids.commonTag("chlorine");
        public static final TagKey<Fluid> ETHENE = Fluids.commonTag("ethene");
        public static final TagKey<Fluid> HEAVY_WATER = Fluids.commonTag("heavy_water");
        public static final TagKey<Fluid> HYDROGEN = Fluids.commonTag("hydrogen");
        public static final TagKey<Fluid> HYDROGEN_CHLORIDE = Fluids.commonTag("hydrogen_chloride");
        public static final TagKey<Fluid> URANIUM_OXIDE = Fluids.commonTag("uranium_oxide");
        public static final TagKey<Fluid> URANIUM_HEXAFLUORIDE = Fluids.commonTag("uranium_hexafluoride");
        public static final TagKey<Fluid> LITHIUM = Fluids.commonTag("lithium");
        public static final TagKey<Fluid> OXYGEN = Fluids.commonTag("oxygen");
        public static final TagKey<Fluid> SODIUM = Fluids.commonTag("sodium");
        public static final TagKey<Fluid> SUPERHEATED_SODIUM = Fluids.commonTag("superheated_sodium");
        public static final TagKey<Fluid> STEAM = Fluids.commonTag("steam");
        public static final TagKey<Fluid> SULFUR_DIOXIDE = Fluids.commonTag("sulfur_dioxide");
        public static final TagKey<Fluid> SULFUR_TRIOXIDE = Fluids.commonTag("sulfur_trioxide");
        public static final TagKey<Fluid> SULFURIC_ACID = Fluids.commonTag("sulfuric_acid");
        public static final TagKey<Fluid> HYDROFLUORIC_ACID = Fluids.commonTag("hydrofluoric_acid");
        public static final TagKey<Fluid> NUTRITIONAL_PASTE = Fluids.commonTag("nutritional_paste");

        private Fluids() {
        }

        private static TagKey<Fluid> commonTag(String name) {
            return FluidTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }
    }

    public static class Biomes {
        public static final TagKey<Biome> SPAWN_ORES = Biomes.tag("spawn_ores");

        private Biomes() {
        }

        private static TagKey<Biome> tag(String name) {
            return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)Mekanism.rl(name));
        }
    }

    public static class Blocks {
        public static final Map<IResource, TagKey<Block>> RESOURCE_STORAGE_BLOCKS = new HashMap<IResource, TagKey<Block>>();
        public static final Map<OreType, TagKey<Block>> ORES = new EnumMap<OreType, TagKey<Block>>(OreType.class);
        public static final TagKey<Block> CARDBOARD_BLACKLIST;
        public static final TagKey<Block> MINER_BLACKLIST;
        public static final TagKey<Block> ATOMIC_DISASSEMBLER_ORE;
        public static final TagKey<Block> INCORRECT_FOR_DISASSEMBLER;
        public static final TagKey<Block> INCORRECT_FOR_MEKA_TOOL;
        public static final TagKey<Block> FARMING_OVERRIDE;
        public static final TagKey<Block> CHESTS_ELECTRIC;
        public static final TagKey<Block> CHESTS_PERSONAL;
        public static final TagKey<Block> BARRELS_PERSONAL;
        public static final TagKey<Block> PERSONAL_STORAGE;
        public static final TagKey<Block> STORAGE_BLOCKS_BRONZE;
        public static final TagKey<Block> STORAGE_BLOCKS_CHARCOAL;
        public static final TagKey<Block> STORAGE_BLOCKS_REFINED_GLOWSTONE;
        public static final TagKey<Block> STORAGE_BLOCKS_REFINED_OBSIDIAN;
        public static final TagKey<Block> STORAGE_BLOCKS_STEEL;
        public static final TagKey<Block> STORAGE_BLOCKS_FLUORITE;

        private Blocks() {
        }

        private static TagKey<Block> commonTag(String name) {
            return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }

        private static TagKey<Block> tag(String name) {
            return BlockTags.create((ResourceLocation)Mekanism.rl(name));
        }

        static {
            for (PrimaryResource primaryResource : EnumUtils.PRIMARY_RESOURCES) {
                if (primaryResource.isVanilla()) continue;
                RESOURCE_STORAGE_BLOCKS.put(primaryResource, Blocks.commonTag("storage_blocks/" + primaryResource.getRegistrySuffix()));
                BlockResourceInfo rawResource = primaryResource.getRawResourceBlockInfo();
                if (rawResource == null) continue;
                RESOURCE_STORAGE_BLOCKS.put(rawResource, Blocks.commonTag("storage_blocks/" + rawResource.getRegistrySuffix()));
            }
            for (Enum enum_ : EnumUtils.ORE_TYPES) {
                ORES.put((OreType)enum_, Blocks.commonTag("ores/" + ((OreType)enum_).getResource().getRegistrySuffix()));
            }
            CARDBOARD_BLACKLIST = Blocks.tag("cardboard_blacklist");
            MINER_BLACKLIST = Blocks.tag("miner_blacklist");
            ATOMIC_DISASSEMBLER_ORE = Blocks.tag("atomic_disassembler_ore");
            INCORRECT_FOR_DISASSEMBLER = Blocks.tag("incorrect_for_disassembler");
            INCORRECT_FOR_MEKA_TOOL = Blocks.tag("incorrect_for_meka_tool");
            FARMING_OVERRIDE = Blocks.tag("farming_override");
            CHESTS_ELECTRIC = Blocks.commonTag("chests/electric");
            CHESTS_PERSONAL = Blocks.commonTag("chests/personal");
            BARRELS_PERSONAL = Blocks.commonTag("barrels/personal");
            PERSONAL_STORAGE = Blocks.tag("personal_storage");
            STORAGE_BLOCKS_BRONZE = Blocks.commonTag("storage_blocks/bronze");
            STORAGE_BLOCKS_CHARCOAL = Blocks.commonTag("storage_blocks/charcoal");
            STORAGE_BLOCKS_REFINED_GLOWSTONE = Blocks.commonTag("storage_blocks/refined_glowstone");
            STORAGE_BLOCKS_REFINED_OBSIDIAN = Blocks.commonTag("storage_blocks/refined_obsidian");
            STORAGE_BLOCKS_STEEL = Blocks.commonTag("storage_blocks/steel");
            STORAGE_BLOCKS_FLUORITE = Blocks.commonTag("storage_blocks/fluorite");
        }
    }

    public static class Items {
        public static final Table<ResourceType, PrimaryResource, TagKey<Item>> PROCESSED_RESOURCES = HashBasedTable.create();
        public static final Map<IResource, TagKey<Item>> PROCESSED_RESOURCE_BLOCKS = new HashMap<IResource, TagKey<Item>>();
        public static final Map<OreType, TagKey<Item>> ORES = new EnumMap<OreType, TagKey<Item>>(OreType.class);
        public static final TagKey<Item> CONFIGURATORS;
        public static final TagKey<Item> TOOLS_WRENCH;
        public static final TagKey<Item> PERSONAL_STORAGE;
        public static final TagKey<Item> RODS_PLASTIC;
        public static final TagKey<Item> FUELS;
        public static final TagKey<Item> FUELS_BIO;
        public static final TagKey<Item> FUELS_BLOCK_BIO;
        public static final TagKey<Item> PELLETS_ANTIMATTER;
        public static final TagKey<Item> PELLETS_PLUTONIUM;
        public static final TagKey<Item> PELLETS_POLONIUM;
        public static final TagKey<Item> DUSTS_BRONZE;
        public static final TagKey<Item> DUSTS_CHARCOAL;
        public static final TagKey<Item> DUSTS_COAL;
        public static final TagKey<Item> DUSTS_DIAMOND;
        public static final TagKey<Item> DUSTS_EMERALD;
        public static final TagKey<Item> DUSTS_NETHERITE;
        public static final TagKey<Item> DUSTS_LAPIS;
        public static final TagKey<Item> DUSTS_LITHIUM;
        public static final TagKey<Item> DUSTS_OBSIDIAN;
        public static final TagKey<Item> DUSTS_QUARTZ;
        public static final TagKey<Item> DUSTS_REFINED_OBSIDIAN;
        public static final TagKey<Item> DUSTS_SALT;
        public static final TagKey<Item> DUSTS_STEEL;
        public static final TagKey<Item> DUSTS_SULFUR;
        public static final TagKey<Item> DUSTS_WOOD;
        public static final TagKey<Item> DUSTS_FLUORITE;
        public static final TagKey<Item> NUGGETS_BRONZE;
        public static final TagKey<Item> NUGGETS_REFINED_GLOWSTONE;
        public static final TagKey<Item> NUGGETS_REFINED_OBSIDIAN;
        public static final TagKey<Item> NUGGETS_STEEL;
        public static final TagKey<Item> INGOTS_BRONZE;
        public static final TagKey<Item> INGOTS_REFINED_GLOWSTONE;
        public static final TagKey<Item> INGOTS_REFINED_OBSIDIAN;
        public static final TagKey<Item> INGOTS_STEEL;
        public static final TagKey<Item> STORAGE_BLOCKS_BRONZE;
        public static final TagKey<Item> STORAGE_BLOCKS_CHARCOAL;
        public static final TagKey<Item> STORAGE_BLOCKS_REFINED_GLOWSTONE;
        public static final TagKey<Item> STORAGE_BLOCKS_REFINED_OBSIDIAN;
        public static final TagKey<Item> STORAGE_BLOCKS_STEEL;
        public static final TagKey<Item> STORAGE_BLOCKS_FLUORITE;
        public static final TagKey<Item> CIRCUITS;
        public static final TagKey<Item> CIRCUITS_BASIC;
        public static final TagKey<Item> CIRCUITS_ADVANCED;
        public static final TagKey<Item> CIRCUITS_ELITE;
        public static final TagKey<Item> CIRCUITS_ULTIMATE;
        public static final TagKey<Item> ALLOYS;
        public static final TagKey<Item> ALLOYS_BASIC;
        public static final TagKey<Item> ALLOYS_INFUSED;
        public static final TagKey<Item> ALLOYS_REINFORCED;
        public static final TagKey<Item> ALLOYS_ATOMIC;
        public static final TagKey<Item> COMMON_ALLOYS;
        public static final TagKey<Item> ALLOYS_ADVANCED;
        public static final TagKey<Item> ALLOYS_ELITE;
        public static final TagKey<Item> ALLOYS_ULTIMATE;
        public static final TagKey<Item> ENRICHED;
        public static final TagKey<Item> ENRICHED_CARBON;
        public static final TagKey<Item> ENRICHED_DIAMOND;
        public static final TagKey<Item> ENRICHED_OBSIDIAN;
        public static final TagKey<Item> ENRICHED_REDSTONE;
        public static final TagKey<Item> ENRICHED_GOLD;
        public static final TagKey<Item> ENRICHED_TIN;
        public static final TagKey<Item> DIRTY_DUSTS;
        public static final TagKey<Item> CLUMPS;
        public static final TagKey<Item> SHARDS;
        public static final TagKey<Item> CRYSTALS;
        public static final TagKey<Item> GEMS_FLUORITE;
        public static final TagKey<Item> MEKASUIT_HUD_RENDERER;
        public static final TagKey<Item> STONE_CRAFTING_MATERIALS;
        public static final TagKey<Item> MUFFLING_CENTER;
        public static final TagKey<Item> COLORABLE_WOOL;
        public static final TagKey<Item> COLORABLE_CARPETS;
        public static final TagKey<Item> COLORABLE_BEDS;
        public static final TagKey<Item> COLORABLE_GLASS;
        public static final TagKey<Item> COLORABLE_GLASS_PANES;
        public static final TagKey<Item> COLORABLE_TERRACOTTA;
        public static final TagKey<Item> COLORABLE_CANDLE;
        public static final TagKey<Item> COLORABLE_CONCRETE;
        public static final TagKey<Item> COLORABLE_CONCRETE_POWDER;
        public static final TagKey<Item> COLORABLE_BANNERS;

        private Items() {
        }

        private static TagKey<Item> commonTag(String name) {
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }

        private static TagKey<Item> tag(String name) {
            return ItemTags.create((ResourceLocation)Mekanism.rl(name));
        }

        static {
            for (PrimaryResource primaryResource : EnumUtils.PRIMARY_RESOURCES) {
                for (ResourceType type : EnumUtils.RESOURCE_TYPES) {
                    if (!type.usedByPrimary(primaryResource)) continue;
                    if (type.isVanilla() || type == ResourceType.DUST) {
                        PROCESSED_RESOURCES.put((Object)type, (Object)primaryResource, Items.commonTag(type.getBaseTagPath() + "/" + primaryResource.getRegistrySuffix()));
                        continue;
                    }
                    PROCESSED_RESOURCES.put((Object)type, (Object)primaryResource, Items.commonTag(type.getBaseTagPath() + "/" + primaryResource.getRegistrySuffix()));
                }
                if (primaryResource.isVanilla()) continue;
                PROCESSED_RESOURCE_BLOCKS.put(primaryResource, Items.commonTag("storage_blocks/" + primaryResource.getRegistrySuffix()));
                BlockResourceInfo rawResource = primaryResource.getRawResourceBlockInfo();
                if (rawResource == null) continue;
                PROCESSED_RESOURCE_BLOCKS.put(rawResource, Items.commonTag("storage_blocks/" + rawResource.getRegistrySuffix()));
            }
            for (Enum enum_ : EnumUtils.ORE_TYPES) {
                ORES.put((OreType)enum_, Items.commonTag("ores/" + ((OreType)enum_).getResource().getRegistrySuffix()));
            }
            CONFIGURATORS = Items.tag("configurators");
            TOOLS_WRENCH = Items.commonTag("tools/wrench");
            PERSONAL_STORAGE = Items.tag("personal_storage");
            RODS_PLASTIC = Items.commonTag("rods/plastic");
            FUELS = Items.commonTag("fuels");
            FUELS_BIO = Items.commonTag("fuels/bio");
            FUELS_BLOCK_BIO = Items.commonTag("fuels/block/bio");
            PELLETS_ANTIMATTER = Items.commonTag("pellets/antimatter");
            PELLETS_PLUTONIUM = Items.commonTag("pellets/plutonium");
            PELLETS_POLONIUM = Items.commonTag("pellets/polonium");
            DUSTS_BRONZE = Items.commonTag("dusts/bronze");
            DUSTS_CHARCOAL = Items.commonTag("dusts/charcoal");
            DUSTS_COAL = Items.commonTag("dusts/coal");
            DUSTS_DIAMOND = Items.commonTag("dusts/diamond");
            DUSTS_EMERALD = Items.commonTag("dusts/emerald");
            DUSTS_NETHERITE = Items.commonTag("dusts/netherite");
            DUSTS_LAPIS = Items.commonTag("dusts/lapis");
            DUSTS_LITHIUM = Items.commonTag("dusts/lithium");
            DUSTS_OBSIDIAN = Items.commonTag("dusts/obsidian");
            DUSTS_QUARTZ = Items.commonTag("dusts/quartz");
            DUSTS_REFINED_OBSIDIAN = Items.commonTag("dusts/refined_obsidian");
            DUSTS_SALT = Items.commonTag("dusts/salt");
            DUSTS_STEEL = Items.commonTag("dusts/steel");
            DUSTS_SULFUR = Items.commonTag("dusts/sulfur");
            DUSTS_WOOD = Items.commonTag("dusts/wood");
            DUSTS_FLUORITE = Items.commonTag("dusts/fluorite");
            NUGGETS_BRONZE = Items.commonTag("nuggets/bronze");
            NUGGETS_REFINED_GLOWSTONE = Items.commonTag("nuggets/refined_glowstone");
            NUGGETS_REFINED_OBSIDIAN = Items.commonTag("nuggets/refined_obsidian");
            NUGGETS_STEEL = Items.commonTag("nuggets/steel");
            INGOTS_BRONZE = Items.commonTag("ingots/bronze");
            INGOTS_REFINED_GLOWSTONE = Items.commonTag("ingots/refined_glowstone");
            INGOTS_REFINED_OBSIDIAN = Items.commonTag("ingots/refined_obsidian");
            INGOTS_STEEL = Items.commonTag("ingots/steel");
            STORAGE_BLOCKS_BRONZE = Items.commonTag("storage_blocks/bronze");
            STORAGE_BLOCKS_CHARCOAL = Items.commonTag("storage_blocks/charcoal");
            STORAGE_BLOCKS_REFINED_GLOWSTONE = Items.commonTag("storage_blocks/refined_glowstone");
            STORAGE_BLOCKS_REFINED_OBSIDIAN = Items.commonTag("storage_blocks/refined_obsidian");
            STORAGE_BLOCKS_STEEL = Items.commonTag("storage_blocks/steel");
            STORAGE_BLOCKS_FLUORITE = Items.commonTag("storage_blocks/fluorite");
            CIRCUITS = Items.commonTag("circuits");
            CIRCUITS_BASIC = Items.commonTag("circuits/basic");
            CIRCUITS_ADVANCED = Items.commonTag("circuits/advanced");
            CIRCUITS_ELITE = Items.commonTag("circuits/elite");
            CIRCUITS_ULTIMATE = Items.commonTag("circuits/ultimate");
            ALLOYS = Items.tag("alloys");
            ALLOYS_BASIC = Items.tag("alloys/basic");
            ALLOYS_INFUSED = Items.tag("alloys/infused");
            ALLOYS_REINFORCED = Items.tag("alloys/reinforced");
            ALLOYS_ATOMIC = Items.tag("alloys/atomic");
            COMMON_ALLOYS = Items.commonTag("alloys");
            ALLOYS_ADVANCED = Items.commonTag("alloys/advanced");
            ALLOYS_ELITE = Items.commonTag("alloys/elite");
            ALLOYS_ULTIMATE = Items.commonTag("alloys/ultimate");
            ENRICHED = Items.tag("enriched");
            ENRICHED_CARBON = Items.tag("enriched/carbon");
            ENRICHED_DIAMOND = Items.tag("enriched/diamond");
            ENRICHED_OBSIDIAN = Items.tag("enriched/obsidian");
            ENRICHED_REDSTONE = Items.tag("enriched/redstone");
            ENRICHED_GOLD = Items.tag("enriched/gold");
            ENRICHED_TIN = Items.tag("enriched/tin");
            DIRTY_DUSTS = Items.tag("dirty_dusts");
            CLUMPS = Items.tag("clumps");
            SHARDS = Items.tag("shards");
            CRYSTALS = Items.tag("crystals");
            GEMS_FLUORITE = Items.commonTag("gems/fluorite");
            MEKASUIT_HUD_RENDERER = Items.tag("mekasuit_hud_renderer");
            STONE_CRAFTING_MATERIALS = Items.tag("stone_crafting_materials");
            MUFFLING_CENTER = Items.tag("muffling_center");
            COLORABLE_WOOL = Items.tag("colorable/wool");
            COLORABLE_CARPETS = Items.tag("colorable/carpets");
            COLORABLE_BEDS = Items.tag("colorable/beds");
            COLORABLE_GLASS = Items.tag("colorable/glass");
            COLORABLE_GLASS_PANES = Items.tag("colorable/glass_panes");
            COLORABLE_TERRACOTTA = Items.tag("colorable/terracotta");
            COLORABLE_CANDLE = Items.tag("colorable/candle");
            COLORABLE_CONCRETE = Items.tag("colorable/concrete");
            COLORABLE_CONCRETE_POWDER = Items.tag("colorable/concrete_powder");
            COLORABLE_BANNERS = Items.tag("colorable/banners");
        }
    }
}

