/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registration.impl;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import mekanism.api.security.SecurityMode;
import mekanism.common.attachments.component.UpgradeAware;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.registration.DoubleDeferredRegister;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.interfaces.IRedstoneControl;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class BlockDeferredRegister
extends DoubleDeferredRegister<Block, Item> {
    public BlockDeferredRegister(String modid) {
        super(modid, Registries.BLOCK, new ItemDeferredRegister(modid));
    }

    public BlockRegistryObject<Block, BlockItem> register(String name, BlockBehaviour.Properties properties) {
        return this.register(name, () -> new Block(BlockStateHelper.applyLightLevelAdjustments(properties)), BlockItem::new);
    }

    public <BLOCK extends Block> BlockRegistryObject<BLOCK, BlockItem> register(String name, Supplier<? extends BLOCK> blockSupplier) {
        return this.register(name, blockSupplier, BlockItem::new);
    }

    public <BLOCK extends Block> BlockRegistryObject<BLOCK, ItemBlockTooltip<BLOCK>> registerDetails(String name, Supplier<? extends BLOCK> blockSupplier) {
        return this.register(name, blockSupplier, (block, properties) -> new ItemBlockTooltip<Block>((Block)block, true, (Item.Properties)properties));
    }

    public <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> register(String name, Supplier<? extends BLOCK> blockSupplier, BiFunction<BLOCK, Item.Properties, ITEM> itemCreator) {
        return this.register(name, blockSupplier, (P block) -> {
            Item.Properties properties = new Item.Properties();
            if (Attribute.has(block, Attributes.AttributeSecurity.class)) {
                properties.component(MekanismDataComponents.SECURITY, (Object)SecurityMode.PUBLIC);
            }
            if (Attribute.has(block, Attributes.AttributeRedstone.class)) {
                properties.component(MekanismDataComponents.REDSTONE_CONTROL, (Object)IRedstoneControl.RedstoneControl.DISABLED);
            }
            if (Attribute.has(block, AttributeUpgradeSupport.class)) {
                properties.component(MekanismDataComponents.UPGRADES, (Object)UpgradeAware.EMPTY);
            }
            return (BlockItem)itemCreator.apply(block, properties);
        }, BlockRegistryObject::new);
    }
}

