/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongTransferUtils;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class EnergyRecipeData
implements RecipeUpgradeData<EnergyRecipeData> {
    private final List<IEnergyContainer> energyContainers;

    EnergyRecipeData(List<IEnergyContainer> energyContainers) {
        this.energyContainers = energyContainers;
    }

    @Override
    @Nullable
    public EnergyRecipeData merge(EnergyRecipeData other) {
        ArrayList<IEnergyContainer> allContainers = new ArrayList<IEnergyContainer>(this.energyContainers);
        allContainers.addAll(other.energyContainers);
        return new EnergyRecipeData(allContainers);
    }

    @Override
    public boolean applyToStack(HolderLookup.Provider provider, ItemStack stack) {
        if (this.energyContainers.isEmpty()) {
            return true;
        }
        IMekanismStrictEnergyHandler outputHandler = ContainerType.ENERGY.createHandler(stack);
        if (outputHandler == null) {
            return false;
        }
        for (IEnergyContainer energyContainer : this.energyContainers) {
            if (!energyContainer.isEmpty() && !this.insertManualIntoOutputContainer(outputHandler, energyContainer.getEnergy()).isZero()) break;
        }
        return true;
    }

    private FloatingLong insertManualIntoOutputContainer(IMekanismStrictEnergyHandler outputHandler, FloatingLong energy) {
        return FloatingLongTransferUtils.insert(energy, null, outputHandler::getEnergyContainers, Action.EXECUTE, AutomationType.MANUAL);
    }
}

