/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.lookup.cache.type;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.common.recipe.lookup.cache.type.BaseInputCache;

public abstract class ComponentSensitiveInputCache<KEY, INPUT, INGREDIENT extends InputIngredient<INPUT>, RECIPE extends MekanismRecipe<?>>
extends BaseInputCache<KEY, INPUT, INGREDIENT, RECIPE> {
    private final Map<INPUT, Set<RECIPE>> componentInputCache;

    protected ComponentSensitiveInputCache(Hash.Strategy<? super INPUT> componentHashStrategy) {
        this.componentInputCache = new Object2ObjectOpenCustomHashMap(componentHashStrategy);
    }

    @Override
    public void clear() {
        super.clear();
        this.componentInputCache.clear();
    }

    @Override
    public boolean contains(INPUT input) {
        return this.componentInputCache.containsKey(input) || super.contains(input);
    }

    @Override
    public Iterable<RECIPE> getRecipes(INPUT input) {
        Set nbtRecipes = this.componentInputCache.getOrDefault(input, Collections.emptySet());
        if (nbtRecipes.isEmpty()) {
            return super.getRecipes(input);
        }
        Collection basicRecipes = (Collection)super.getRecipes(input);
        if (basicRecipes.isEmpty()) {
            return nbtRecipes;
        }
        return Iterables.concat(nbtRecipes, (Iterable)basicRecipes);
    }

    protected void addNbtInputCache(INPUT input, RECIPE recipe) {
        this.componentInputCache.computeIfAbsent(input, i -> new HashSet()).add(recipe);
    }
}

