/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import io.netty.buffer.ByteBuf;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.PacketUtils;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.laser.TileEntityLaserAmplifier;
import mekanism.common.tile.machine.TileEntityResistiveHeater;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketGuiSetEnergy(GuiEnergyValue interaction, BlockPos pos, FloatingLong value) implements IMekanismPacket
{
    public static final CustomPacketPayload.Type<PacketGuiSetEnergy> TYPE = new CustomPacketPayload.Type(Mekanism.rl("set_energy"));
    public static final StreamCodec<ByteBuf, PacketGuiSetEnergy> STREAM_CODEC = StreamCodec.composite(GuiEnergyValue.STREAM_CODEC, PacketGuiSetEnergy::interaction, (StreamCodec)BlockPos.STREAM_CODEC, PacketGuiSetEnergy::pos, FloatingLong.STREAM_CODEC, PacketGuiSetEnergy::value, PacketGuiSetEnergy::new);

    @NotNull
    public CustomPacketPayload.Type<PacketGuiSetEnergy> type() {
        return TYPE;
    }

    @Override
    public void handle(IPayloadContext context) {
        BlockEntity blockEntity = PacketUtils.blockEntity(context, this.pos);
        if (blockEntity instanceof TileEntityMekanism) {
            TileEntityMekanism tile = (TileEntityMekanism)blockEntity;
            this.interaction.consume(tile, this.value);
        }
    }

    public static enum GuiEnergyValue {
        MIN_THRESHOLD((tile, value) -> {
            if (tile instanceof TileEntityLaserAmplifier) {
                TileEntityLaserAmplifier amplifier = (TileEntityLaserAmplifier)tile;
                amplifier.setMinThresholdFromPacket((FloatingLong)value);
            }
        }),
        MAX_THRESHOLD((tile, value) -> {
            if (tile instanceof TileEntityLaserAmplifier) {
                TileEntityLaserAmplifier amplifier = (TileEntityLaserAmplifier)tile;
                amplifier.setMaxThresholdFromPacket((FloatingLong)value);
            }
        }),
        ENERGY_USAGE((tile, value) -> {
            if (tile instanceof TileEntityResistiveHeater) {
                TileEntityResistiveHeater heater = (TileEntityResistiveHeater)tile;
                heater.setEnergyUsageFromPacket((FloatingLong)value);
            }
        });

        public static final IntFunction<GuiEnergyValue> BY_ID;
        public static final StreamCodec<ByteBuf, GuiEnergyValue> STREAM_CODEC;
        private final BiConsumer<TileEntityMekanism, FloatingLong> consumerForTile;

        private GuiEnergyValue(BiConsumer<TileEntityMekanism, FloatingLong> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, FloatingLong value) {
            this.consumerForTile.accept(tile, value);
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])GuiEnergyValue.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

