/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_client;

import io.netty.buffer.ByteBuf;
import mekanism.common.Mekanism;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.base.TileEntityUpdateable;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketUpdateTile(BlockPos pos, CompoundTag updateTag) implements IMekanismPacket
{
    public static final CustomPacketPayload.Type<PacketUpdateTile> TYPE = new CustomPacketPayload.Type(Mekanism.rl("update_tile"));
    public static final StreamCodec<ByteBuf, PacketUpdateTile> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketUpdateTile::pos, (StreamCodec)ByteBufCodecs.TRUSTED_COMPOUND_TAG, PacketUpdateTile::updateTag, PacketUpdateTile::new);

    public PacketUpdateTile(TileEntityUpdateable tile) {
        this(tile.getBlockPos(), tile.getReducedUpdateTag((HolderLookup.Provider)tile.getLevel().registryAccess()));
    }

    @NotNull
    public CustomPacketPayload.Type<PacketUpdateTile> type() {
        return TYPE;
    }

    @Override
    public void handle(IPayloadContext context) {
        Level world = context.player().level();
        if (WorldUtils.isBlockLoaded((BlockGetter)world, this.pos)) {
            TileEntityUpdateable tile = WorldUtils.getTileEntity(TileEntityUpdateable.class, (BlockGetter)world, this.pos, true);
            if (tile == null) {
                Mekanism.logger.warn("Update tile packet received for position: {} in world: {}, but no valid tile was found.", (Object)this.pos, (Object)world.dimension().location());
            } else {
                tile.handleUpdatePacket(this.updateTag, (HolderLookup.Provider)world.registryAccess());
            }
        }
    }
}

