/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.transmitter;

import mekanism.api.chemical.merged.BoxedChemical;
import mekanism.common.capabilities.chemical.BoxedChemicalHandler;
import mekanism.common.content.network.BoxedChemicalNetwork;
import mekanism.common.content.network.FluidNetwork;
import mekanism.common.content.network.transmitter.BoxedPressurizedTube;
import mekanism.common.content.network.transmitter.MechanicalPipe;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.transmitter.DynamicNetwork;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class CompatibleTransmitterValidator<ACCEPTOR, NETWORK extends DynamicNetwork<ACCEPTOR, NETWORK, TRANSMITTER>, TRANSMITTER extends Transmitter<ACCEPTOR, NETWORK, TRANSMITTER>> {
    public boolean isNetworkCompatible(NETWORK net) {
        return true;
    }

    public boolean isTransmitterCompatible(Transmitter<?, ?, ?> transmitter) {
        return true;
    }

    public static class CompatibleFluidTransmitterValidator
    extends CompatibleTransmitterValidator<IFluidHandler, FluidNetwork, MechanicalPipe> {
        private FluidStack buffer;

        public CompatibleFluidTransmitterValidator(MechanicalPipe transmitter) {
            this.buffer = transmitter.getBufferWithFallback();
        }

        private boolean compareBuffers(FluidStack otherBuffer) {
            if (this.buffer.isEmpty()) {
                this.buffer = otherBuffer;
                return true;
            }
            return otherBuffer.isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)this.buffer, (FluidStack)otherBuffer);
        }

        @Override
        public boolean isNetworkCompatible(FluidNetwork network) {
            if (super.isNetworkCompatible(network)) {
                FluidStack otherBuffer;
                CompatibleTransmitterValidator compatibleTransmitterValidator = network.getTransmitterValidator();
                if (compatibleTransmitterValidator instanceof CompatibleFluidTransmitterValidator) {
                    CompatibleFluidTransmitterValidator validator = (CompatibleFluidTransmitterValidator)compatibleTransmitterValidator;
                    otherBuffer = validator.buffer;
                } else {
                    otherBuffer = network.getBuffer();
                    if (otherBuffer.isEmpty() && network.getPrevTransferAmount() > 0) {
                        otherBuffer = network.lastFluid;
                    }
                }
                return this.compareBuffers(otherBuffer);
            }
            return false;
        }

        @Override
        public boolean isTransmitterCompatible(Transmitter<?, ?, ?> transmitter) {
            MechanicalPipe pipe;
            return super.isTransmitterCompatible(transmitter) && transmitter instanceof MechanicalPipe && this.compareBuffers((pipe = (MechanicalPipe)transmitter).getBufferWithFallback());
        }
    }

    public static class CompatibleChemicalTransmitterValidator
    extends CompatibleTransmitterValidator<BoxedChemicalHandler, BoxedChemicalNetwork, BoxedPressurizedTube> {
        private BoxedChemical buffer;

        public CompatibleChemicalTransmitterValidator(BoxedPressurizedTube transmitter) {
            this.buffer = transmitter.getBufferWithFallback().getType();
        }

        private boolean compareBuffers(BoxedChemical otherBuffer) {
            if (this.buffer.isEmpty()) {
                this.buffer = otherBuffer;
                return true;
            }
            return otherBuffer.isEmpty() || this.buffer.equals(otherBuffer);
        }

        @Override
        public boolean isNetworkCompatible(BoxedChemicalNetwork network) {
            if (super.isNetworkCompatible(network)) {
                BoxedChemical otherBuffer;
                CompatibleTransmitterValidator compatibleTransmitterValidator = network.getTransmitterValidator();
                if (compatibleTransmitterValidator instanceof CompatibleChemicalTransmitterValidator) {
                    CompatibleChemicalTransmitterValidator validator = (CompatibleChemicalTransmitterValidator)compatibleTransmitterValidator;
                    otherBuffer = validator.buffer;
                } else {
                    otherBuffer = network.getBuffer().getType();
                    if (otherBuffer.isEmpty() && network.getPrevTransferAmount() > 0L) {
                        otherBuffer = network.lastChemical;
                    }
                }
                return this.compareBuffers(otherBuffer);
            }
            return false;
        }

        @Override
        public boolean isTransmitterCompatible(Transmitter<?, ?, ?> transmitter) {
            BoxedPressurizedTube tube;
            return super.isTransmitterCompatible(transmitter) && transmitter instanceof BoxedPressurizedTube && this.compareBuffers((tube = (BoxedPressurizedTube)transmitter).getBufferWithFallback().getType());
        }
    }
}

