/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.multiblock;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IMekanismHeatHandler;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.math.FloatingLong;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.chemical.dynamic.IGasTracker;
import mekanism.common.capabilities.chemical.dynamic.IInfusionTracker;
import mekanism.common.capabilities.chemical.dynamic.IPigmentTracker;
import mekanism.common.capabilities.chemical.dynamic.ISlurryTracker;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.util.StackUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiblockCache<T extends MultiblockData>
implements IMekanismInventory,
IMekanismFluidHandler,
IMekanismStrictEnergyHandler,
IMekanismHeatHandler,
IGasTracker,
IInfusionTracker,
IPigmentTracker,
ISlurryTracker {
    private final List<IInventorySlot> inventorySlots = new ArrayList<IInventorySlot>();
    private final List<IExtendedFluidTank> fluidTanks = new ArrayList<IExtendedFluidTank>();
    private final List<IGasTank> gasTanks = new ArrayList<IGasTank>();
    private final List<IInfusionTank> infusionTanks = new ArrayList<IInfusionTank>();
    private final List<IPigmentTank> pigmentTanks = new ArrayList<IPigmentTank>();
    private final List<ISlurryTank> slurryTanks = new ArrayList<ISlurryTank>();
    private final List<IEnergyContainer> energyContainers = new ArrayList<IEnergyContainer>();
    private final List<IHeatCapacitor> heatCapacitors = new ArrayList<IHeatCapacitor>();

    public void apply(HolderLookup.Provider provider, T data) {
        for (CacheSubstance<?, INBTSerializable<CompoundTag>> type : CacheSubstance.VALUES) {
            List<INBTSerializable<CompoundTag>> containers = type.getContainerList(data);
            if (containers == null) continue;
            List<INBTSerializable<CompoundTag>> cacheContainers = type.getContainerList(this);
            for (int i = 0; i < cacheContainers.size(); ++i) {
                if (i >= containers.size()) continue;
                containers.get(i).deserializeNBT(provider, (Tag)((CompoundTag)cacheContainers.get(i).serializeNBT(provider)));
            }
        }
    }

    public void sync(T data) {
        for (CacheSubstance<?, INBTSerializable<CompoundTag>> type : CacheSubstance.VALUES) {
            List<INBTSerializable<CompoundTag>> containersToCopy = type.getContainerList(data);
            if (containersToCopy == null) continue;
            List<INBTSerializable<CompoundTag>> cacheContainers = type.getContainerList(this);
            if (cacheContainers.isEmpty()) {
                type.prefab(this, containersToCopy.size());
            }
            for (int i = 0; i < containersToCopy.size(); ++i) {
                type.sync(cacheContainers.get(i), containersToCopy.get(i));
            }
        }
    }

    public void load(HolderLookup.Provider provider, CompoundTag nbtTags) {
        for (CacheSubstance<?, INBTSerializable<CompoundTag>> type : CacheSubstance.VALUES) {
            type.readFrom(provider, nbtTags, this);
        }
    }

    public void save(HolderLookup.Provider provider, CompoundTag nbtTags) {
        for (CacheSubstance<?, INBTSerializable<CompoundTag>> type : CacheSubstance.VALUES) {
            type.saveTo(provider, nbtTags, this);
        }
    }

    public void merge(MultiblockCache<T> mergeCache, RejectContents rejectContents) {
        for (CacheSubstance<T, INBTSerializable<CompoundTag>> cacheSubstance : CacheSubstance.VALUES) {
            cacheSubstance.preHandleMerge(this, mergeCache);
        }
        StackUtils.merge(this.getInventorySlots(null), mergeCache.getInventorySlots(null), rejectContents.rejectedItems);
        StorageUtils.mergeFluidTanks(this.getFluidTanks(null), mergeCache.getFluidTanks(null), rejectContents.rejectedFluids);
        StorageUtils.mergeTanks(this.getGasTanks(null), mergeCache.getGasTanks(null), rejectContents.rejectedGases);
        StorageUtils.mergeTanks(this.getInfusionTanks(null), mergeCache.getInfusionTanks(null), rejectContents.rejectedInfuseTypes);
        StorageUtils.mergeTanks(this.getPigmentTanks(null), mergeCache.getPigmentTanks(null), rejectContents.rejectedPigments);
        StorageUtils.mergeTanks(this.getSlurryTanks(null), mergeCache.getSlurryTanks(null), rejectContents.rejectedSlurries);
        StorageUtils.mergeEnergyContainers(this.getEnergyContainers(null), mergeCache.getEnergyContainers(null));
        StorageUtils.mergeHeatCapacitors(this.getHeatCapacitors(null), mergeCache.getHeatCapacitors(null));
    }

    @Override
    public void onContentsChanged() {
    }

    @Override
    @NotNull
    public List<IInventorySlot> getInventorySlots(@Nullable Direction side) {
        return this.inventorySlots;
    }

    @Override
    @NotNull
    public List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.fluidTanks;
    }

    @Override
    @NotNull
    public List<IGasTank> getGasTanks(@Nullable Direction side) {
        return this.gasTanks;
    }

    @Override
    @NotNull
    public List<IInfusionTank> getInfusionTanks(@Nullable Direction side) {
        return this.infusionTanks;
    }

    @Override
    @NotNull
    public List<IPigmentTank> getPigmentTanks(@Nullable Direction side) {
        return this.pigmentTanks;
    }

    @Override
    @NotNull
    public List<ISlurryTank> getSlurryTanks(@Nullable Direction side) {
        return this.slurryTanks;
    }

    @Override
    @NotNull
    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.energyContainers;
    }

    @Override
    @NotNull
    public List<IHeatCapacitor> getHeatCapacitors(Direction side) {
        return this.heatCapacitors;
    }

    public static abstract class CacheSubstance<HANDLER, ELEMENT extends INBTSerializable<CompoundTag>> {
        public static final CacheSubstance<IMekanismInventory, IInventorySlot> ITEMS = new CacheSubstance<IMekanismInventory, IInventorySlot>(ContainerType.ITEM){

            @Override
            protected void defaultPrefab(MultiblockCache<?> cache) {
                cache.inventorySlots.add(BasicInventorySlot.at(cache, 0, 0));
            }

            @Override
            protected List<IInventorySlot> containerList(IMekanismInventory inventory) {
                return inventory.getInventorySlots(null);
            }

            @Override
            public void sync(IInventorySlot cache, IInventorySlot data) {
                cache.setStack(data.getStack());
            }
        };
        public static final CacheSubstance<IMekanismFluidHandler, IExtendedFluidTank> FLUID = new CacheSubstance<IMekanismFluidHandler, IExtendedFluidTank>(ContainerType.FLUID){

            @Override
            protected void defaultPrefab(MultiblockCache<?> cache) {
                cache.fluidTanks.add(BasicFluidTank.create(Integer.MAX_VALUE, cache));
            }

            @Override
            protected List<IExtendedFluidTank> containerList(IMekanismFluidHandler fluidHandler) {
                return fluidHandler.getFluidTanks(null);
            }

            @Override
            public void sync(IExtendedFluidTank cache, IExtendedFluidTank data) {
                cache.setStack(data.getFluid());
            }
        };
        public static final CacheSubstance<IGasTracker, IGasTank> GAS = new CacheSubstance<IGasTracker, IGasTank>(ContainerType.GAS){

            @Override
            protected void defaultPrefab(MultiblockCache<?> cache) {
                cache.gasTanks.add(ChemicalTankBuilder.GAS.createAllValid(Long.MAX_VALUE, cache));
            }

            @Override
            protected List<IGasTank> containerList(IGasTracker tracker) {
                return tracker.getGasTanks(null);
            }

            @Override
            public void sync(IGasTank cache, IGasTank data) {
                cache.setStack((GasStack)data.getStack());
            }
        };
        public static final CacheSubstance<IInfusionTracker, IInfusionTank> INFUSION = new CacheSubstance<IInfusionTracker, IInfusionTank>(ContainerType.INFUSION){

            @Override
            protected void defaultPrefab(MultiblockCache<?> cache) {
                cache.infusionTanks.add(ChemicalTankBuilder.INFUSION.createAllValid(Long.MAX_VALUE, cache));
            }

            @Override
            protected List<IInfusionTank> containerList(IInfusionTracker tracker) {
                return tracker.getInfusionTanks(null);
            }

            @Override
            public void sync(IInfusionTank cache, IInfusionTank data) {
                cache.setStack((InfusionStack)data.getStack());
            }
        };
        public static final CacheSubstance<IPigmentTracker, IPigmentTank> PIGMENT = new CacheSubstance<IPigmentTracker, IPigmentTank>(ContainerType.PIGMENT){

            @Override
            protected void defaultPrefab(MultiblockCache<?> cache) {
                cache.pigmentTanks.add(ChemicalTankBuilder.PIGMENT.createAllValid(Long.MAX_VALUE, cache));
            }

            @Override
            protected List<IPigmentTank> containerList(IPigmentTracker tracker) {
                return tracker.getPigmentTanks(null);
            }

            @Override
            public void sync(IPigmentTank cache, IPigmentTank data) {
                cache.setStack((PigmentStack)data.getStack());
            }
        };
        public static final CacheSubstance<ISlurryTracker, ISlurryTank> SLURRY = new CacheSubstance<ISlurryTracker, ISlurryTank>(ContainerType.SLURRY){

            @Override
            protected void defaultPrefab(MultiblockCache<?> cache) {
                cache.slurryTanks.add(ChemicalTankBuilder.SLURRY.createAllValid(Long.MAX_VALUE, cache));
            }

            @Override
            protected List<ISlurryTank> containerList(ISlurryTracker tracker) {
                return tracker.getSlurryTanks(null);
            }

            @Override
            public void sync(ISlurryTank cache, ISlurryTank data) {
                cache.setStack((SlurryStack)data.getStack());
            }
        };
        public static final CacheSubstance<IMekanismStrictEnergyHandler, IEnergyContainer> ENERGY = new CacheSubstance<IMekanismStrictEnergyHandler, IEnergyContainer>(ContainerType.ENERGY){

            @Override
            protected void defaultPrefab(MultiblockCache<?> cache) {
                cache.energyContainers.add(BasicEnergyContainer.create(FloatingLong.MAX_VALUE, cache));
            }

            @Override
            protected List<IEnergyContainer> containerList(IMekanismStrictEnergyHandler handler) {
                return handler.getEnergyContainers(null);
            }

            @Override
            public void sync(IEnergyContainer cache, IEnergyContainer data) {
                cache.setEnergy(data.getEnergy());
            }
        };
        public static final CacheSubstance<IMekanismHeatHandler, IHeatCapacitor> HEAT = new CacheSubstance<IMekanismHeatHandler, IHeatCapacitor>(ContainerType.HEAT){

            @Override
            protected void defaultPrefab(MultiblockCache<?> cache) {
                cache.heatCapacitors.add(BasicHeatCapacitor.create(1.0, null, cache));
            }

            @Override
            protected List<IHeatCapacitor> containerList(IMekanismHeatHandler handler) {
                return handler.getHeatCapacitors(null);
            }

            @Override
            public void sync(IHeatCapacitor cache, IHeatCapacitor data) {
                cache.setHeat(data.getHeat());
                if (cache instanceof BasicHeatCapacitor) {
                    BasicHeatCapacitor heatCapacitor = (BasicHeatCapacitor)cache;
                    heatCapacitor.setHeatCapacity(data.getHeatCapacity(), false);
                }
            }
        };
        public static final CacheSubstance<?, INBTSerializable<CompoundTag>>[] VALUES = new CacheSubstance[]{ITEMS, FLUID, GAS, INFUSION, PIGMENT, SLURRY, ENERGY, HEAT};
        private final ContainerType<ELEMENT, ?, ?> containerType;

        public CacheSubstance(ContainerType<ELEMENT, ?, ?> containerType) {
            this.containerType = containerType;
        }

        protected abstract void defaultPrefab(MultiblockCache<?> var1);

        protected abstract List<ELEMENT> containerList(HANDLER var1);

        private void prefab(MultiblockCache<?> cache, int count) {
            for (int i = 0; i < count; ++i) {
                this.defaultPrefab(cache);
            }
        }

        public List<ELEMENT> getContainerList(Object holder) {
            return this.containerList(holder);
        }

        public abstract void sync(ELEMENT var1, ELEMENT var2);

        public void preHandleMerge(MultiblockCache<?> cache, MultiblockCache<?> merge) {
            int diff = this.getContainerList(merge).size() - this.getContainerList(cache).size();
            if (diff > 0) {
                this.prefab(cache, diff);
            }
        }

        private String getStoredTagKey() {
            return this.containerType.getTag() + "_stored";
        }

        public void readFrom(HolderLookup.Provider provider, CompoundTag tag, MultiblockCache<?> cache) {
            int stored = tag.getInt(this.getStoredTagKey());
            if (stored > 0) {
                this.prefab(cache, stored);
                this.containerType.readFrom(provider, tag, this.getContainerList(cache));
            }
        }

        public void saveTo(HolderLookup.Provider provider, CompoundTag tag, MultiblockCache<?> holder) {
            List<ELEMENT> containers = this.getContainerList(holder);
            if (!containers.isEmpty()) {
                tag.putInt(this.getStoredTagKey(), containers.size());
                this.containerType.saveTo(provider, tag, this.getContainerList(holder));
            }
        }
    }

    public static class RejectContents {
        public final List<ItemStack> rejectedItems = new ArrayList<ItemStack>();
        public final List<FluidStack> rejectedFluids = new ArrayList<FluidStack>();
        public final List<GasStack> rejectedGases = new ArrayList<GasStack>();
        public final List<InfusionStack> rejectedInfuseTypes = new ArrayList<InfusionStack>();
        public final List<PigmentStack> rejectedPigments = new ArrayList<PigmentStack>();
        public final List<SlurryStack> rejectedSlurries = new ArrayList<SlurryStack>();
    }
}

