/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.multiblock;

import java.util.UUID;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.lib.multiblock.IMultiblockBase;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.lib.multiblock.Structure;
import org.jetbrains.annotations.Nullable;

public interface IMultiblock<T extends MultiblockData>
extends IMultiblockBase {
    public T createMultiblock();

    default public T getMultiblock() {
        MultiblockData data = this.getStructure().getMultiblockData();
        if (data != null && data.isFormed()) {
            return (T)data;
        }
        return this.getDefaultData();
    }

    public T getDefaultData();

    public MultiblockManager<T> getManager();

    @Nullable
    public UUID getCacheID();

    public void resetCache();

    public boolean isMaster();

    public boolean canBeMaster();

    public Structure getStructure();

    public void setStructure(Structure var1);

    @Override
    default public void setStructure(MultiblockManager<?> manager, Structure structure) {
        if (manager == this.getManager()) {
            this.setStructure(structure);
        }
    }

    @Override
    default public Structure getStructure(MultiblockManager<?> manager) {
        if (manager == this.getManager()) {
            return this.getStructure();
        }
        return null;
    }

    @Override
    default public boolean hasStructure(Structure structure) {
        return this.getStructure() == structure;
    }

    default public FormationProtocol<T> createFormationProtocol() {
        return new FormationProtocol(this, this.getStructure());
    }
}

