/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.multiblock;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.radiation.IRadiationManager;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.lib.multiblock.IMultiblock;
import mekanism.common.lib.multiblock.IStructureValidator;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.lib.multiblock.Structure;
import mekanism.common.util.EnumUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.Vec3;

public class FormationProtocol<T extends MultiblockData> {
    public static final int MAX_SIZE = 18;
    private final IMultiblock<T> pointer;
    private final Structure structure;
    private final MultiblockManager<T> manager;
    public final Set<BlockPos> locations = new ObjectOpenHashSet();
    public final Set<BlockPos> internalLocations = new ObjectOpenHashSet();
    public final Set<IValveHandler.ValveData> valves = new ObjectOpenHashSet();
    public final Map<UUID, MultiblockCache<T>> idsFound = new HashMap<UUID, MultiblockCache<T>>();

    public FormationProtocol(IMultiblock<T> tile, Structure structure) {
        this.pointer = tile;
        this.structure = structure;
        this.manager = tile.getManager();
    }

    private StructureResult<T> buildStructure(IStructureValidator<T> validator) {
        T structure = this.pointer.createMultiblock();
        if (!((MultiblockData)structure).setShape(validator.getShape())) {
            return this.fail(FormationResult.FAIL);
        }
        Long2ObjectOpenHashMap chunkMap = new Long2ObjectOpenHashMap();
        FormationResult result = validator.validate(this, (Long2ObjectMap<ChunkAccess>)chunkMap);
        if (!result.isFormed()) {
            return this.fail(result);
        }
        ((MultiblockData)structure).locations = this.locations;
        ((MultiblockData)structure).internalLocations = this.internalLocations;
        ((MultiblockData)structure).valves = this.valves;
        result = validator.postcheck(structure, (Long2ObjectMap<ChunkAccess>)chunkMap);
        return result.isFormed() ? this.form(structure, this.idsFound) : this.fail(result);
    }

    public FormationResult doUpdate() {
        IStructureValidator<T> validator = this.manager.createValidator();
        Level world = this.pointer.getLevel();
        validator.init(world, this.manager, this.structure);
        if (!validator.precheck()) {
            return FormationResult.FAIL;
        }
        StructureResult<T> result = this.buildStructure(validator);
        Object structureFound = result.structureFound;
        BlockPos pointerPos = this.pointer.getBlockPos();
        if (structureFound != null && ((MultiblockData)structureFound).locations.contains(pointerPos)) {
            boolean trackCache;
            this.pointer.setMultiblockData(this.manager, (MultiblockData)structureFound);
            ((MultiblockData)structureFound).setFormedForce(true);
            MultiblockCache cache = null;
            UUID idToUse = this.manager.getUniqueInventoryID();
            if (!result.idsFound().isEmpty()) {
                MultiblockCache.RejectContents rejectContents = new MultiblockCache.RejectContents();
                for (Map.Entry<UUID, MultiblockCache<T>> entry : result.idsFound().entrySet()) {
                    if (cache == null) {
                        cache = entry.getValue();
                        continue;
                    }
                    cache.merge(entry.getValue(), rejectContents);
                }
                this.manager.replaceCaches(result.idsFound().keySet(), idToUse, cache);
                if (!rejectContents.rejectedItems.isEmpty()) {
                    Vec3 dropPosition = pointerPos.getCenter();
                    Player nearestPlayer = world.getNearestPlayer(dropPosition.x, dropPosition.y, dropPosition.z, 25.0, true);
                    if (nearestPlayer != null) {
                        dropPosition = nearestPlayer.position();
                    }
                    for (ItemStack rejectedItem : rejectContents.rejectedItems) {
                        world.addFreshEntity((Entity)new ItemEntity(world, dropPosition.x, dropPosition.y, dropPosition.z, rejectedItem));
                    }
                }
                if (!rejectContents.rejectedGases.isEmpty() && IRadiationManager.INSTANCE.isRadiationEnabled()) {
                    double radiation = 0.0;
                    for (GasStack rejectedGas : rejectContents.rejectedGases) {
                        radiation += rejectedGas.mapAttributeToDouble(GasAttributes.Radiation.class, (stored, attribute) -> (double)stored.getAmount() * attribute.getRadioactivity());
                    }
                    if (radiation > 0.0) {
                        GlobalPos dumpLocation = GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)((MultiblockData)structureFound).getBounds().getCenter());
                        IRadiationManager.INSTANCE.radiate(dumpLocation, radiation);
                    }
                }
            }
            boolean bl = trackCache = cache == null;
            if (trackCache) {
                cache = this.manager.createCache();
            }
            cache.apply((HolderLookup.Provider)world.registryAccess(), structureFound);
            ((MultiblockData)structureFound).inventoryID = idToUse;
            ((MultiblockData)structureFound).onCreated(world);
            if (trackCache) {
                cache.sync(structureFound);
                this.manager.trackCache(idToUse, cache);
            }
            return FormationResult.SUCCESS;
        }
        this.pointer.getStructure().removeMultiblock(world);
        return result.result();
    }

    protected static Component text(BlockPos pos) {
        return MekanismLang.GENERIC_PARENTHESIS.translate(MekanismLang.GENERIC_BLOCK_POS.translate(pos.getX(), pos.getY(), pos.getZ()));
    }

    public static <NODE> int explore(Level level, Long2ObjectMap<ChunkAccess> chunkMap, BlockPos start, NODE node, FormationChecker<NODE> checker) {
        return FormationProtocol.explore(level, chunkMap, start, node, checker, 5832);
    }

    public static <NODE> int explore(Level level, Long2ObjectMap<ChunkAccess> chunkMap, BlockPos start, NODE node, FormationChecker<NODE> checker, int maxCount) {
        if (!checker.check(level, chunkMap, start, node, start)) {
            return 0;
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        LinkedList<BlockPos> openSet = new LinkedList<BlockPos>();
        ObjectOpenHashSet traversed = new ObjectOpenHashSet();
        openSet.add(start);
        traversed.add(start);
        while (!openSet.isEmpty()) {
            BlockPos ptr = (BlockPos)openSet.poll();
            int traversedSize = traversed.size();
            if (traversedSize >= maxCount) {
                return traversedSize;
            }
            for (Direction side : EnumUtils.DIRECTIONS) {
                mutable.setWithOffset((Vec3i)ptr, side);
                if (traversed.contains(mutable) || !checker.check(level, chunkMap, start, node, (BlockPos)mutable)) continue;
                BlockPos offset = mutable.immutable();
                openSet.add(offset);
                traversed.add(offset);
            }
        }
        return traversed.size();
    }

    private StructureResult<T> fail(FormationResult result) {
        return new StructureResult<Object>(result, null, null);
    }

    private StructureResult<T> form(T structureFound, Map<UUID, MultiblockCache<T>> idsFound) {
        return new StructureResult<T>(FormationResult.SUCCESS, structureFound, idsFound);
    }

    public static class FormationResult {
        public static final FormationResult SUCCESS = new FormationResult(true, null, false);
        public static final FormationResult FAIL = new FormationResult(false, null, false);
        private final Component resultText;
        private final boolean formed;
        private final boolean noIgnore;

        private FormationResult(boolean formed, Component resultText, boolean noIgnore) {
            this.formed = formed;
            this.resultText = resultText;
            this.noIgnore = noIgnore;
        }

        public static FormationResult fail(ILangEntry text, BlockPos pos) {
            return FormationResult.fail(text, pos, false);
        }

        public static FormationResult fail(ILangEntry text, BlockPos pos, boolean noIgnore) {
            return FormationResult.fail((Component)text.translateColored(EnumColor.GRAY, EnumColor.INDIGO, FormationProtocol.text(pos)), noIgnore);
        }

        public static FormationResult fail(ILangEntry text) {
            return FormationResult.fail(text, false);
        }

        public static FormationResult fail(ILangEntry text, boolean noIgnore) {
            return FormationResult.fail((Component)text.translateColored(EnumColor.GRAY), noIgnore);
        }

        public static FormationResult fail(Component text) {
            return FormationResult.fail(text, false);
        }

        public static FormationResult fail(Component text, boolean noIgnore) {
            return new FormationResult(false, text, noIgnore);
        }

        public boolean isFormed() {
            return this.formed;
        }

        public boolean isNoIgnore() {
            return this.noIgnore;
        }

        public Component getResultText() {
            return this.resultText;
        }
    }

    private record StructureResult<T extends MultiblockData>(FormationResult result, T structureFound, Map<UUID, MultiblockCache<T>> idsFound) {
    }

    @FunctionalInterface
    public static interface FormationChecker<NODE> {
        public boolean check(Level var1, Long2ObjectMap<ChunkAccess> var2, BlockPos var3, NODE var4, BlockPos var5);
    }

    public static enum StructureRequirement {
        IGNORED,
        FRAME,
        OTHER,
        INNER;

        public static final StructureRequirement[] REQUIREMENTS;

        boolean needsFrame() {
            return this == FRAME;
        }

        boolean isCasing() {
            return this != INNER;
        }

        static {
            REQUIREMENTS = StructureRequirement.values();
        }
    }

    public static enum CasingType {
        FRAME,
        VALVE,
        OTHER,
        INVALID;


        boolean isFrame() {
            return this == FRAME;
        }

        boolean isValve() {
            return this == VALVE;
        }
    }
}

