/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.frequency;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import mekanism.api.security.SecurityMode;
import mekanism.common.content.entangloporter.InventoryFrequency;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.content.teleporter.TeleporterFrequency;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyManager;
import mekanism.common.lib.frequency.FrequencyManagerWrapper;
import mekanism.common.lib.frequency.IdentitySerializer;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.lib.security.SecurityUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class FrequencyType<FREQ extends Frequency> {
    private static final Map<String, FrequencyType<?>> registryMap = new HashMap();
    private static int maxNameLength = 0;
    public static final Codec<FrequencyType<?>> CODEC = Codec.stringResolver(FrequencyType::getName, registryMap::get);
    public static final StreamCodec<ByteBuf, FrequencyType<?>> STREAM_CODEC = NeoForgeStreamCodecs.lazy(() -> ByteBufCodecs.stringUtf8((int)maxNameLength).map(name -> {
        FrequencyType<?> type = registryMap.get(name);
        if (type == null) {
            throw new DecoderException("Unable to find frequency type for name: " + name);
        }
        return type;
    }, FrequencyType::getName));
    public static final FrequencyType<TeleporterFrequency> TELEPORTER = FrequencyType.register("Teleporter", (key, uuid, securityMode) -> new TeleporterFrequency((String)key, uuid, securityMode), TeleporterFrequency.CODEC, TeleporterFrequency.STREAM_CODEC, FrequencyManagerWrapper.Type.PUBLIC_PRIVATE_TRUSTED, IdentitySerializer.NAME);
    public static final FrequencyType<InventoryFrequency> INVENTORY = FrequencyType.register("Inventory", (key, uuid, securityMode) -> new InventoryFrequency((String)key, uuid, securityMode), InventoryFrequency.CODEC, InventoryFrequency.STREAM_CODEC, FrequencyManagerWrapper.Type.PUBLIC_PRIVATE_TRUSTED, IdentitySerializer.NAME);
    public static final FrequencyType<SecurityFrequency> SECURITY = FrequencyType.register("Security", (key, uuid, securityMode) -> new SecurityFrequency(uuid, securityMode), SecurityFrequency.CODEC, SecurityFrequency.STREAM_CODEC, FrequencyManagerWrapper.Type.PUBLIC_ONLY, IdentitySerializer.UUID);
    public static final FrequencyType<QIOFrequency> QIO = FrequencyType.register("QIO", (key, uuid, securityMode) -> new QIOFrequency((String)key, uuid, securityMode), QIOFrequency.CODEC, QIOFrequency.STREAM_CODEC, FrequencyManagerWrapper.Type.PUBLIC_PRIVATE_TRUSTED, IdentitySerializer.NAME);
    private final String name;
    private final FrequencyConstructor<FREQ> creationFunction;
    private final Codec<FREQ> codec;
    private final StreamCodec<? super RegistryFriendlyByteBuf, FREQ> streamCodec;
    private final IdentitySerializer identitySerializer;
    private final FrequencyManagerWrapper<FREQ> managerWrapper;

    public static void init() {
    }

    private static <FREQ extends Frequency> FrequencyType<FREQ> register(String name, FrequencyConstructor<FREQ> creationFunction, Codec<FREQ> codec, StreamCodec<? super RegistryFriendlyByteBuf, FREQ> streamCodec, FrequencyManagerWrapper.Type managerType, IdentitySerializer identitySerializer) {
        FrequencyType<FREQ> type = new FrequencyType<FREQ>(name, creationFunction, codec, streamCodec, managerType, identitySerializer);
        registryMap.put(name, type);
        maxNameLength = Math.max(maxNameLength, name.length());
        return type;
    }

    private FrequencyType(String name, FrequencyConstructor<FREQ> creationFunction, Codec<FREQ> codec, StreamCodec<? super RegistryFriendlyByteBuf, FREQ> streamCodec, FrequencyManagerWrapper.Type managerType, IdentitySerializer identitySerializer) {
        this.name = name;
        this.creationFunction = creationFunction;
        this.codec = codec;
        this.streamCodec = streamCodec;
        this.managerWrapper = FrequencyManagerWrapper.create(this, managerType);
        this.identitySerializer = identitySerializer;
    }

    public String getName() {
        return this.name;
    }

    public StreamCodec<? super RegistryFriendlyByteBuf, FREQ> streamCodec() {
        return this.streamCodec;
    }

    public Codec<FREQ> codec() {
        return this.codec;
    }

    public FREQ create(HolderLookup.Provider provider, CompoundTag identityTag) {
        Frequency.FrequencyIdentity identity = (Frequency.FrequencyIdentity)((Pair)this.getIdentitySerializer().codec().decode((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)identityTag).getOrThrow()).getFirst();
        FREQ frequency = this.create(identity.key(), identity.ownerUUID(), identity.securityMode());
        ((Frequency)frequency).setValid(false);
        return frequency;
    }

    public FREQ create(Object key, UUID ownerUUID, SecurityMode securityMode) {
        return this.creationFunction.create(key, ownerUUID, securityMode);
    }

    public FREQ create(RegistryFriendlyByteBuf buffer) {
        return (FREQ)((Frequency)this.streamCodec.decode((Object)buffer));
    }

    public FrequencyManagerWrapper<FREQ> getManagerWrapper() {
        return this.managerWrapper;
    }

    public FrequencyManager<FREQ> getManager(@Nullable UUID owner, SecurityMode securityMode) {
        return switch (securityMode) {
            default -> throw new MatchException(null, null);
            case SecurityMode.PUBLIC -> this.getManagerWrapper().getPublicManager();
            case SecurityMode.PRIVATE -> this.getManagerWrapper().getPrivateManager(owner);
            case SecurityMode.TRUSTED -> this.getManagerWrapper().getTrustedManager(owner);
        };
    }

    @Nullable
    @Contract(value="null -> null")
    public FrequencyManager<FREQ> getFrequencyManager(@Nullable FREQ freq) {
        if (freq == null) {
            return null;
        }
        FrequencyManagerWrapper<FREQ> manager = this.getManagerWrapper();
        if (((Frequency)freq).getType() == SECURITY) {
            return manager.getPublicManager();
        }
        return switch (((Frequency)freq).getSecurity()) {
            default -> throw new MatchException(null, null);
            case SecurityMode.PUBLIC -> manager.getPublicManager();
            case SecurityMode.PRIVATE -> manager.getPrivateManager(((Frequency)freq).getOwner());
            case SecurityMode.TRUSTED -> manager.getTrustedManager(((Frequency)freq).getOwner());
        };
    }

    public FrequencyManager<FREQ> getManager(Frequency.FrequencyIdentity identity, UUID owner) {
        return switch (identity.securityMode()) {
            default -> throw new MatchException(null, null);
            case SecurityMode.PUBLIC -> this.getManagerWrapper().getPublicManager();
            case SecurityMode.PRIVATE -> this.getManagerWrapper().getPrivateManager(owner);
            case SecurityMode.TRUSTED -> this.getManagerWrapper().getTrustedManager(owner);
        };
    }

    @Nullable
    public FREQ getFrequency(Frequency.FrequencyIdentity identity, UUID owner) {
        FrequencyManager<FREQ> manager = !Objects.equals(identity.ownerUUID(), owner) && SecurityUtils.get().isTrusted(identity.securityMode(), identity.ownerUUID(), owner) ? this.getManager(identity, identity.ownerUUID()) : this.getManager(identity, owner);
        return manager.getFrequency(identity.key());
    }

    public IdentitySerializer getIdentitySerializer() {
        return this.identitySerializer;
    }

    public static <FREQ extends Frequency> FrequencyType<FREQ> load(CompoundTag tag) {
        return registryMap.get(tag.getString("type"));
    }

    public static void clear() {
        for (FrequencyType<?> type : registryMap.values()) {
            type.managerWrapper.clear();
        }
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (super.equals(obj)) return true;
        if (!(obj instanceof FrequencyType)) return false;
        FrequencyType other = (FrequencyType)obj;
        if (!Objects.equals(this.name, other.name)) return false;
        return true;
    }

    @FunctionalInterface
    private static interface FrequencyConstructor<FREQ extends Frequency> {
        public FREQ create(Object var1, UUID var2, SecurityMode var3);
    }
}

