/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib;

import java.util.List;
import mekanism.common.content.transporter.TransporterPathfinder;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import org.jetbrains.annotations.Nullable;

public record SidedBlockPos(BlockPos pos, Direction side) {
    public SidedBlockPos(BlockPos pos, Direction side) {
        this.pos = pos = pos.immutable();
        this.side = side;
    }

    public static SidedBlockPos get(TransporterPathfinder.Destination destination) {
        List<BlockPos> path = destination.getPath();
        BlockPos pos = path.get(0);
        Direction sideOfDest = WorldUtils.sideDifference(path.get(1), pos);
        return new SidedBlockPos(pos, sideOfDest);
    }

    @Nullable
    public static SidedBlockPos deserialize(CompoundTag tag) {
        BlockPos pos;
        if (tag.contains("side", 3) && (pos = (BlockPos)NbtUtils.readBlockPos((CompoundTag)tag, (String)"position").orElse(null)) != null) {
            return new SidedBlockPos(pos, Direction.from3DDataValue((int)tag.getInt("side")));
        }
        return null;
    }

    public CompoundTag serialize() {
        CompoundTag target = new CompoundTag();
        target.put("position", NbtUtils.writeBlockPos((BlockPos)this.pos));
        NBTUtils.writeEnum(target, "side", this.side);
        return target;
    }
}

