/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib;

import java.io.File;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.function.Supplier;
import mekanism.common.Mekanism;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public abstract class MekanismSavedData
extends SavedData {
    public abstract void load(@NotNull CompoundTag var1, @NotNull HolderLookup.Provider var2);

    public void save(@NotNull File file, @NotNull HolderLookup.Provider provider) {
        if (this.isDirty()) {
            Path targetPath = file.toPath();
            Path tempPath = file.toPath().getParent().resolve(file.getName() + ".tmp");
            File tempFile = tempPath.toFile();
            super.save(tempFile, provider);
            if (tempFile.exists()) {
                try {
                    try {
                        Files.move(tempPath, targetPath, StandardCopyOption.ATOMIC_MOVE);
                    }
                    catch (AtomicMoveNotSupportedException ignored) {
                        Files.move(tempPath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (IOException e) {
                    Mekanism.logger.error("Could not replace save data {} with new value", (Object)this, (Object)e);
                }
            }
        }
    }

    public static <DATA extends MekanismSavedData> DATA createSavedData(Supplier<DATA> createFunction, String name) {
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        if (currentServer == null) {
            throw new IllegalStateException("Current server is null");
        }
        DimensionDataStorage dataStorage = currentServer.overworld().getDataStorage();
        return MekanismSavedData.createSavedData(dataStorage, new SavedData.Factory(createFunction, (tag, provider) -> {
            MekanismSavedData handler = (MekanismSavedData)((Object)((Object)createFunction.get()));
            handler.load((CompoundTag)tag, (HolderLookup.Provider)provider);
            return handler;
        }), name);
    }

    public static <DATA extends MekanismSavedData> DATA createSavedData(DimensionDataStorage dataStorage, SavedData.Factory<DATA> factory, String name) {
        return (DATA)((Object)((MekanismSavedData)dataStorage.computeIfAbsent(factory, "mekanism_" + name)));
    }
}

