/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.interfaces;

import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.util.ChemicalUtil;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface IGasItem {
    @NotNull
    default public GasStack useGas(ItemStack stack, long amount) {
        IGasHandler gasHandlerItem = (IGasHandler)Capabilities.GAS.getCapability(stack);
        if (gasHandlerItem != null) {
            IGasHandler.IMekanismGasHandler gasHandler;
            IGasTank gasTank;
            if (gasHandlerItem instanceof IGasHandler.IMekanismGasHandler && (gasTank = (IGasTank)(gasHandler = (IGasHandler.IMekanismGasHandler)gasHandlerItem).getChemicalTank(0, null)) != null) {
                return (GasStack)gasTank.extract(amount, Action.EXECUTE, AutomationType.MANUAL);
            }
            return (GasStack)gasHandlerItem.extractChemical(amount, Action.EXECUTE);
        }
        return GasStack.EMPTY;
    }

    default public boolean hasGas(ItemStack stack) {
        return ChemicalUtil.hasGas(stack);
    }
}

