/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import mekanism.api.IIncrementalEnum;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.client.render.RenderPropertiesProvider;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.entity.EntityFlame;
import mekanism.common.item.interfaces.IGasItem;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.registration.impl.CreativeTabDeferredRegister;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.registries.MekanismGases;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.stats.Stats;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class ItemFlamethrower
extends Item
implements IItemHUDProvider,
IGasItem,
CreativeTabDeferredRegister.ICustomCreativeTabContents,
IModeItem.IAttachmentBasedModeItem<FlamethrowerMode> {
    public ItemFlamethrower(Item.Properties properties) {
        super(properties.stacksTo(1).rarity(Rarity.RARE).setNoRepair().component(MekanismDataComponents.FLAMETHROWER_MODE, (Object)FlamethrowerMode.COMBAT));
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(RenderPropertiesProvider.flamethrower());
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        StorageUtils.addStoredGas(stack, tooltip, true, false);
        tooltip.add((Component)MekanismLang.MODE.translateColored(EnumColor.GRAY, this.getMode(stack)));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.getItem() != newStack.getItem();
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return 72000;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null && this.hasGas(context.getItemInHand())) {
            player.startUsingItem(context.getHand());
            return InteractionResult.CONSUME;
        }
        return super.useOn(context);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.hasGas(stack)) {
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void onUseTick(@NotNull Level level, @NotNull LivingEntity entity, @NotNull ItemStack stack, int remainingDuration) {
        if (remainingDuration >= 0 && entity instanceof Player) {
            Player player = (Player)entity;
            if (this.hasGas(stack)) {
                EntityFlame flame;
                if (!level.isClientSide && (flame = EntityFlame.create(level, entity, entity.getUsedItemHand(), (FlamethrowerMode)this.getMode(stack))) != null) {
                    if (flame.isAlive()) {
                        level.addFreshEntity((Entity)flame);
                    }
                    if (MekanismUtils.isPlayingMode(player)) {
                        this.useGas(stack, 1L);
                    }
                }
            } else {
                entity.releaseUsingItem();
            }
        } else {
            entity.releaseUsingItem();
        }
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return true;
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        return StorageUtils.getBarWidth(stack);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return ChemicalUtil.getRGBDurabilityForDisplay(stack);
    }

    @Override
    public void addItems(Consumer<ItemStack> tabOutput) {
        tabOutput.accept(ChemicalUtil.getFilledVariant((ItemLike)this, MekanismGases.HYDROGEN));
    }

    @Override
    public DataComponentType<FlamethrowerMode> getModeDataType() {
        return (DataComponentType)MekanismDataComponents.FLAMETHROWER_MODE.get();
    }

    @Override
    public FlamethrowerMode getDefaultMode() {
        return FlamethrowerMode.COMBAT;
    }

    @Override
    public void addHUDStrings(List<Component> list, Player player, ItemStack stack, EquipmentSlot slotType) {
        GasStack storedGas;
        boolean hasGas = false;
        IGasHandler gasHandlerItem = (IGasHandler)Capabilities.GAS.getCapability(stack);
        if (gasHandlerItem != null && gasHandlerItem.getTanks() > 0 && !(storedGas = (GasStack)gasHandlerItem.getChemicalInTank(0)).isEmpty()) {
            list.add((Component)MekanismLang.FLAMETHROWER_STORED.translateColored(EnumColor.GRAY, EnumColor.ORANGE, storedGas.getAmount()));
            hasGas = true;
        }
        if (!hasGas) {
            list.add((Component)MekanismLang.FLAMETHROWER_STORED.translateColored(EnumColor.GRAY, EnumColor.ORANGE, MekanismLang.NO_GAS));
        }
        list.add((Component)MekanismLang.MODE.translate(this.getMode(stack)));
    }

    @Override
    public void changeMode(@NotNull Player player, @NotNull ItemStack stack, int shift, IModeItem.DisplayChange displayChange) {
        FlamethrowerMode newMode;
        FlamethrowerMode mode = (FlamethrowerMode)this.getMode(stack);
        if (mode != (newMode = (FlamethrowerMode)mode.adjust(shift))) {
            this.setMode(stack, player, newMode);
            displayChange.sendMessage(player, newMode, xva$0 -> MekanismLang.FLAMETHROWER_MODE_CHANGE.translate(xva$0));
        }
    }

    @Override
    @NotNull
    public Component getScrollTextComponent(@NotNull ItemStack stack) {
        return ((FlamethrowerMode)this.getMode(stack)).getTextComponent();
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean isPrimaryItemFor(ItemStack stack, Holder<Enchantment> enchantment) {
        return false;
    }

    public static boolean isIdleFlamethrower(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        return !stack.isEmpty() && stack.getItem() instanceof ItemFlamethrower && ChemicalUtil.hasGas(stack);
    }

    @NothingNullByDefault
    public static enum FlamethrowerMode implements IIncrementalEnum<FlamethrowerMode>,
    IHasTextComponent,
    StringRepresentable
    {
        COMBAT(MekanismLang.FLAMETHROWER_COMBAT, EnumColor.YELLOW),
        HEAT(MekanismLang.FLAMETHROWER_HEAT, EnumColor.ORANGE),
        INFERNO(MekanismLang.FLAMETHROWER_INFERNO, EnumColor.DARK_RED);

        public static final Codec<FlamethrowerMode> CODEC;
        public static final IntFunction<FlamethrowerMode> BY_ID;
        public static final StreamCodec<ByteBuf, FlamethrowerMode> STREAM_CODEC;
        private final ILangEntry langEntry;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);
        private final EnumColor color;

        private FlamethrowerMode(ILangEntry langEntry, EnumColor color) {
            this.langEntry = langEntry;
            this.color = color;
        }

        @Override
        public Component getTextComponent() {
            return this.langEntry.translateColored(this.color);
        }

        @Override
        public FlamethrowerMode byIndex(int index) {
            return BY_ID.apply(index);
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(FlamethrowerMode::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])FlamethrowerMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

