/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.registration.impl.CreativeTabDeferredRegister;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemElectricBow
extends BowItem
implements IItemHUDProvider,
CreativeTabDeferredRegister.ICustomCreativeTabContents,
IModeItem.IAttachmentBasedModeItem<Boolean> {
    public ItemElectricBow(Item.Properties properties) {
        super(properties.rarity(Rarity.RARE).setNoRepair().stacksTo(1).component(MekanismDataComponents.ELECTRIC_BOW_MODE, (Object)false));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        StorageUtils.addStoredEnergy(stack, tooltip, true);
        tooltip.add((Component)MekanismLang.FIRE_MODE.translateColored(EnumColor.PINK, BooleanStateDisplay.OnOff.of((Boolean)this.getMode(stack))));
    }

    public void releaseUsing(@NotNull ItemStack bow, @NotNull Level world, @NotNull LivingEntity entity, int timeLeft) {
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).isCreative()) {
            FloatingLong energyNeeded;
            IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(bow, 0);
            FloatingLong floatingLong = energyNeeded = (Boolean)this.getMode(bow) != false ? (FloatingLong)MekanismConfig.gear.electricBowEnergyUsageFire.get() : (FloatingLong)MekanismConfig.gear.electricBowEnergyUsage.get();
            if (energyContainer == null || energyContainer.extract(energyNeeded, Action.SIMULATE, AutomationType.MANUAL).smallerThan(energyNeeded)) {
                return;
            }
        }
        super.releaseUsing(bow, world, entity, timeLeft);
    }

    protected void shoot(@NotNull ServerLevel world, @NotNull LivingEntity entity, @NotNull InteractionHand hand, @NotNull ItemStack bow, @NotNull List<ItemStack> potentialAmmo, float velocity, float inaccuracy, boolean critical, @Nullable LivingEntity target) {
        IEnergyContainer energyContainer;
        Player player;
        super.shoot(world, entity, hand, bow, potentialAmmo, velocity, inaccuracy, critical, target);
        if (entity instanceof Player && !(player = (Player)entity).isCreative() && !potentialAmmo.isEmpty() && (energyContainer = StorageUtils.getEnergyContainer(bow, 0)) != null) {
            FloatingLong energyNeeded = (Boolean)this.getMode(bow) != false ? (FloatingLong)MekanismConfig.gear.electricBowEnergyUsageFire.get() : (FloatingLong)MekanismConfig.gear.electricBowEnergyUsage.get();
            energyContainer.extract(energyNeeded, Action.EXECUTE, AutomationType.MANUAL);
        }
    }

    public boolean isPrimaryItemFor(@NotNull ItemStack stack, @NotNull Holder<Enchantment> enchantment) {
        return !enchantment.is(Enchantments.FLAME) && super.isPrimaryItemFor(stack, enchantment);
    }

    public int getEnchantmentLevel(@NotNull ItemStack stack, @NotNull Holder<Enchantment> enchantment) {
        if (stack.isEmpty()) {
            return 0;
        }
        if (enchantment.is(Enchantments.FLAME) && ((Boolean)this.getMode(stack)).booleanValue()) {
            return Math.max(1, super.getEnchantmentLevel(stack, enchantment));
        }
        return super.getEnchantmentLevel(stack, enchantment);
    }

    @NotNull
    public ItemEnchantments getAllEnchantments(@NotNull ItemStack stack, @NotNull HolderLookup.RegistryLookup<Enchantment> lookup) {
        Holder flame;
        Optional enchantment;
        ItemEnchantments enchantments = super.getAllEnchantments(stack, lookup);
        if (((Boolean)this.getMode(stack)).booleanValue() && (enchantment = lookup.get(Enchantments.FLAME)).isPresent() && enchantments.getLevel(flame = (Holder)enchantment.get()) == 0) {
            ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(enchantments);
            mutable.set(flame, 1);
            return mutable.toImmutable();
        }
        return enchantments;
    }

    @Override
    public DataComponentType<Boolean> getModeDataType() {
        return (DataComponentType)MekanismDataComponents.ELECTRIC_BOW_MODE.get();
    }

    @Override
    public Boolean getDefaultMode() {
        return Boolean.FALSE;
    }

    @Override
    public void addHUDStrings(List<Component> list, Player player, ItemStack stack, EquipmentSlot slotType) {
        list.add((Component)MekanismLang.FIRE_MODE.translateColored(EnumColor.PINK, BooleanStateDisplay.OnOff.of((Boolean)this.getMode(stack))));
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return true;
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        return StorageUtils.getEnergyBarWidth(stack);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return MekanismConfig.client.energyColor.get();
    }

    @Override
    public void addItems(Consumer<ItemStack> tabOutput) {
        tabOutput.accept(StorageUtils.getFilledEnergyVariant((ItemLike)this));
    }

    @Override
    public void changeMode(@NotNull Player player, @NotNull ItemStack stack, int shift, IModeItem.DisplayChange displayChange) {
        if (Math.abs(shift) % 2 == 1) {
            boolean newState = (Boolean)this.getMode(stack) == false;
            this.setMode(stack, player, newState);
            displayChange.sendMessage(player, newState, s -> MekanismLang.FIRE_MODE.translate(BooleanStateDisplay.OnOff.of(s, true)));
        }
    }

    @Override
    @NotNull
    public Component getScrollTextComponent(@NotNull ItemStack stack) {
        return MekanismLang.FIRE_MODE.translateColored(EnumColor.PINK, BooleanStateDisplay.OnOff.of((Boolean)this.getMode(stack), true));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.getItem() != newStack.getItem();
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return oldStack.getItem() != newStack.getItem();
    }
}

