/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.IntFunction;
import mekanism.api.IIncrementalEnum;
import mekanism.api.RelativeSide;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.radial.IRadialDataHelper;
import mekanism.api.radial.RadialData;
import mekanism.api.radial.mode.IRadialMode;
import mekanism.api.security.IBlockSecurityUtils;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeStateFacing;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.lib.radial.IRadialModeItem;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tier.BinTier;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemConfigurator
extends Item
implements IRadialModeItem<ConfiguratorMode>,
IItemHUDProvider {
    public static final Lazy<RadialData<ConfiguratorMode>> LAZY_RADIAL_DATA = Lazy.of(() -> IRadialDataHelper.INSTANCE.dataForEnum(Mekanism.rl("configurator_mode"), ConfiguratorMode.class));

    public ItemConfigurator(Item.Properties properties) {
        super(properties.rarity(Rarity.UNCOMMON).component(MekanismDataComponents.CONFIGURATOR_MODE, (Object)ConfiguratorMode.CONFIGURATE_ITEMS));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.add((Component)MekanismLang.STATE.translateColored(EnumColor.PINK, this.getMode(stack)));
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        return TextComponentUtil.build(EnumColor.AQUA, super.getName(stack));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        Level world = context.getLevel();
        if (!world.isClientSide && player != null) {
            BlockPos pos = context.getClickedPos();
            Direction side = context.getClickedFace();
            ItemStack stack = context.getItemInHand();
            BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)world, pos);
            ConfiguratorMode mode = (ConfiguratorMode)this.getMode(stack);
            if (mode.isConfigurating()) {
                Object config;
                TransmissionType transmissionType = Objects.requireNonNull(mode.getTransmission(), "Configurating state requires transmission type");
                if (tile instanceof ISideConfiguration && (config = (ISideConfiguration)tile).getConfig().supports(transmissionType)) {
                    ConfigInfo info = config.getConfig().getConfig(transmissionType);
                    if (info != null) {
                        RelativeSide relativeSide = RelativeSide.fromDirections(config.getDirection(), side);
                        DataType dataType = info.getDataType(relativeSide);
                        if (!player.isShiftKeyDown()) {
                            player.displayClientMessage((Component)MekanismLang.CONFIGURATOR_VIEW_MODE.translateColored(EnumColor.GRAY, transmissionType, dataType.getColor(), dataType, dataType.getColor().getColoredName()), true);
                        } else {
                            if (!IBlockSecurityUtils.INSTANCE.canAccessOrDisplayError(player, world, pos, tile)) {
                                return InteractionResult.FAIL;
                            }
                            DataType old = dataType;
                            dataType = info.incrementDataType(relativeSide);
                            if (dataType != old) {
                                player.displayClientMessage((Component)MekanismLang.CONFIGURATOR_TOGGLE_MODE.translateColored(EnumColor.GRAY, transmissionType, dataType.getColor(), dataType, dataType.getColor().getColoredName()), true);
                                config.getConfig().sideChanged(transmissionType, relativeSide);
                            }
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
                if (!IBlockSecurityUtils.INSTANCE.canAccessOrDisplayError(player, world, pos, tile)) {
                    return InteractionResult.FAIL;
                }
                config = WorldUtils.getCapability(world, Capabilities.CONFIGURABLE, pos, null, tile, side);
                if (config != null) {
                    if (player.isShiftKeyDown()) {
                        return config.onSneakRightClick(player);
                    }
                    return config.onRightClick(player);
                }
            } else if (mode == ConfiguratorMode.EMPTY) {
                IMekanismInventory inv;
                if (tile instanceof IMekanismInventory && (inv = (IMekanismInventory)tile).hasInventory()) {
                    TileEntityBin bin;
                    if (!IBlockSecurityUtils.INSTANCE.canAccessOrDisplayError(player, world, pos, tile)) {
                        return InteractionResult.FAIL;
                    }
                    boolean creative = player.isCreative();
                    if (tile instanceof TileEntityBin && (bin = (TileEntityBin)tile).getTier() == BinTier.CREATIVE) {
                        if (creative) {
                            bin.getBinSlot().setEmpty();
                            return InteractionResult.SUCCESS;
                        }
                        return InteractionResult.FAIL;
                    }
                    for (IInventorySlot inventorySlot : inv.getInventorySlots(null)) {
                        if (inventorySlot.isEmpty()) continue;
                        InventoryUtils.dropStack(world, pos, side, inventorySlot.getStack().copy(), Block::popResourceFromFace);
                        inventorySlot.setEmpty();
                    }
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (mode == ConfiguratorMode.ROTATE) {
                    if (tile instanceof TileEntityMekanism) {
                        TileEntityMekanism tileMekanism = (TileEntityMekanism)tile;
                        if (!tileMekanism.isDirectional()) {
                            return InteractionResult.PASS;
                        }
                        if (!IBlockSecurityUtils.INSTANCE.canAccessOrDisplayError(player, world, pos, tile)) {
                            return InteractionResult.FAIL;
                        }
                        if (Attribute.matches(tileMekanism.getBlockType(), AttributeStateFacing.class, AttributeStateFacing::canRotate)) {
                            tileMekanism.setFacing(player.isShiftKeyDown() ? side.getOpposite() : side);
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
                if (mode == ConfiguratorMode.WRENCH) {
                    return InteractionResult.PASS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return this.getMode(stack) == ConfiguratorMode.WRENCH;
    }

    @Override
    public void addHUDStrings(List<Component> list, Player player, ItemStack stack, EquipmentSlot slotType) {
        list.add((Component)MekanismLang.MODE.translateColored(EnumColor.PINK, this.getMode(stack)));
    }

    @Override
    public void changeMode(@NotNull Player player, @NotNull ItemStack stack, int shift, IModeItem.DisplayChange displayChange) {
        ConfiguratorMode newMode;
        ConfiguratorMode mode = (ConfiguratorMode)this.getMode(stack);
        if (mode != (newMode = (ConfiguratorMode)mode.adjust(shift))) {
            this.setMode(stack, player, newMode);
            displayChange.sendMessage(player, newMode, xva$0 -> MekanismLang.CONFIGURE_STATE.translate(xva$0));
        }
    }

    @Override
    @NotNull
    public Component getScrollTextComponent(@NotNull ItemStack stack) {
        return ((ConfiguratorMode)this.getMode(stack)).getTextComponent();
    }

    @Override
    @NotNull
    public RadialData<ConfiguratorMode> getRadialData(ItemStack stack) {
        return (RadialData)LAZY_RADIAL_DATA.get();
    }

    @Override
    public DataComponentType<ConfiguratorMode> getModeDataType() {
        return (DataComponentType)MekanismDataComponents.CONFIGURATOR_MODE.get();
    }

    @Override
    public ConfiguratorMode getDefaultMode() {
        return ConfiguratorMode.CONFIGURATE_ITEMS;
    }

    @NothingNullByDefault
    public static enum ConfiguratorMode implements IIncrementalEnum<ConfiguratorMode>,
    IHasTextComponent,
    IRadialMode,
    StringRepresentable
    {
        CONFIGURATE_ITEMS(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.ITEM, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_FLUIDS(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.FLUID, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_GASES(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.GAS, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_INFUSE_TYPES(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.INFUSION, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_PIGMENTS(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.PIGMENT, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_SLURRIES(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.SLURRY, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_ENERGY(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.ENERGY, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_HEAT(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.HEAT, EnumColor.BRIGHT_GREEN, true, null),
        EMPTY(MekanismLang.CONFIGURATOR_EMPTY, null, EnumColor.DARK_RED, false, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_RADIAL, "empty.png")),
        ROTATE(MekanismLang.CONFIGURATOR_ROTATE, null, EnumColor.YELLOW, false, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_RADIAL, "rotate.png")),
        WRENCH(MekanismLang.CONFIGURATOR_WRENCH, null, EnumColor.PINK, false, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_RADIAL, "wrench.png"));

        public static final Codec<ConfiguratorMode> CODEC;
        public static final IntFunction<ConfiguratorMode> BY_ID;
        public static final StreamCodec<ByteBuf, ConfiguratorMode> STREAM_CODEC;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);
        private final ILangEntry langEntry;
        @Nullable
        private final TransmissionType transmissionType;
        private final EnumColor color;
        private final boolean configurating;
        private final ResourceLocation icon;

        private ConfiguratorMode(ILangEntry langEntry, TransmissionType transmissionType, @Nullable EnumColor color, boolean configurating, ResourceLocation icon) {
            this.langEntry = langEntry;
            this.transmissionType = transmissionType;
            this.color = color;
            this.configurating = configurating;
            this.icon = transmissionType == null ? Objects.requireNonNull(icon, "Icon should only be null if there is a transmission type present.") : MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, transmissionType.getTransmission() + ".png");
        }

        @Override
        public Component getTextComponent() {
            if (this.transmissionType == null) {
                return this.langEntry.translateColored(this.color);
            }
            return this.langEntry.translateColored(this.color, this.transmissionType);
        }

        @Override
        public EnumColor color() {
            return this.color;
        }

        public boolean isConfigurating() {
            return this.configurating;
        }

        @Nullable
        public TransmissionType getTransmission() {
            return this.transmissionType;
        }

        @Override
        @NotNull
        public ConfiguratorMode byIndex(int index) {
            return BY_ID.apply(index);
        }

        @Override
        @NotNull
        public Component sliceName() {
            return this.configurating && this.transmissionType != null ? this.transmissionType.getLangEntry().translateColored(this.color) : this.getTextComponent();
        }

        @Override
        @NotNull
        public ResourceLocation icon() {
            return this.icon;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(ConfiguratorMode::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])ConfiguratorMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

