/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.ItemStackToEnergyRecipe;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.util.MekanismUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class EnergyInventorySlot
extends BasicInventorySlot {
    public static final Predicate<ItemStack> DRAIN_VALIDATOR = EnergyCompatUtils::hasStrictEnergyHandler;
    private final Supplier<@Nullable Level> worldSupplier;
    private final IEnergyContainer energyContainer;

    public static FloatingLong getPotentialConversion(@Nullable Level world, ItemStack itemStack) {
        ItemStackToEnergyRecipe foundRecipe = (ItemStackToEnergyRecipe)((InputRecipeCache.SingleItem)MekanismRecipeType.ENERGY_CONVERSION.getInputCache()).findTypeBasedRecipe(world, itemStack);
        return foundRecipe == null ? FloatingLong.ZERO : foundRecipe.getOutput(itemStack);
    }

    public static EnergyInventorySlot fillOrConvert(IEnergyContainer energyContainer, Supplier<@Nullable Level> worldSupplier, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(energyContainer, "Energy container cannot be null");
        Objects.requireNonNull(worldSupplier, "World supplier cannot be null");
        return new EnergyInventorySlot(energyContainer, worldSupplier, stack -> !EnergyInventorySlot.fillInsertCheck(stack) && EnergyInventorySlot.getPotentialConversion((Level)worldSupplier.get(), stack).isZero(), stack -> {
            if (EnergyInventorySlot.fillInsertCheck(stack)) {
                return true;
            }
            return !EnergyInventorySlot.getPotentialConversion((Level)worldSupplier.get(), stack).isZero();
        }, stack -> EnergyCompatUtils.hasStrictEnergyHandler(stack) || !EnergyInventorySlot.getPotentialConversion((Level)worldSupplier.get(), stack).isZero(), listener, x, y);
    }

    public static EnergyInventorySlot fill(IEnergyContainer energyContainer, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(energyContainer, "Energy container cannot be null");
        return new EnergyInventorySlot(energyContainer, stack -> !EnergyInventorySlot.fillInsertCheck(stack), EnergyInventorySlot::fillInsertCheck, EnergyCompatUtils::hasStrictEnergyHandler, listener, x, y);
    }

    public static EnergyInventorySlot drain(IEnergyContainer energyContainer, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(energyContainer, "Energy container cannot be null");
        Predicate<@NotNull ItemStack> insertPredicate = stack -> {
            IStrictEnergyHandler itemEnergyHandler = EnergyCompatUtils.getStrictEnergyHandler(stack);
            if (itemEnergyHandler == null) {
                return false;
            }
            FloatingLong storedEnergy = energyContainer.getEnergy();
            if (storedEnergy.isZero()) {
                for (int container = 0; container < itemEnergyHandler.getEnergyContainerCount(); ++container) {
                    if (itemEnergyHandler.getNeededEnergy(container).isZero()) continue;
                    return true;
                }
                return false;
            }
            return itemEnergyHandler.insertEnergy(storedEnergy, Action.SIMULATE).smallerThan(storedEnergy);
        };
        return new EnergyInventorySlot(energyContainer, insertPredicate.negate(), insertPredicate, DRAIN_VALIDATOR, listener, x, y);
    }

    public static boolean fillInsertCheck(ItemStack stack) {
        IStrictEnergyHandler itemEnergyHandler = EnergyCompatUtils.getStrictEnergyHandler(stack);
        return itemEnergyHandler != null && !itemEnergyHandler.extractEnergy(FloatingLong.MAX_VALUE, Action.SIMULATE).isZero();
    }

    private EnergyInventorySlot(IEnergyContainer energyContainer, Predicate<@NotNull ItemStack> canExtract, Predicate<@NotNull ItemStack> canInsert, Predicate<@NotNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        this(energyContainer, () -> null, canExtract, canInsert, validator, listener, x, y);
    }

    private EnergyInventorySlot(IEnergyContainer energyContainer, Supplier<@Nullable Level> worldSupplier, Predicate<@NotNull ItemStack> canExtract, Predicate<@NotNull ItemStack> canInsert, Predicate<@NotNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        super(canExtract, canInsert, validator, listener, x, y);
        this.energyContainer = energyContainer;
        this.worldSupplier = worldSupplier;
        this.setSlotType(ContainerSlotType.POWER);
        this.setSlotOverlay(SlotOverlay.POWER);
    }

    public void fillContainerOrConvert() {
        FloatingLong output;
        ItemStack itemInput;
        ItemStackToEnergyRecipe foundRecipe;
        if (!(this.isEmpty() || this.energyContainer.getNeeded().isZero() || this.fillContainerFromItem() || (foundRecipe = (ItemStackToEnergyRecipe)((InputRecipeCache.SingleItem)MekanismRecipeType.ENERGY_CONVERSION.getInputCache()).findFirstRecipe(this.worldSupplier.get(), this.current)) == null || (itemInput = foundRecipe.getInput().getMatchingInstance(this.current)).isEmpty() || (output = foundRecipe.getOutput(itemInput)).isZero() || !this.energyContainer.insert(output, Action.SIMULATE, AutomationType.MANUAL).isZero())) {
            MekanismUtils.logExpectedZero(this.energyContainer.insert(output, Action.EXECUTE, AutomationType.MANUAL));
            int amountUsed = itemInput.getCount();
            MekanismUtils.logMismatchedStackSize(this.shrinkStack(amountUsed, Action.EXECUTE), amountUsed);
        }
    }

    public void fillContainer() {
        if (!this.isEmpty() && !this.energyContainer.getNeeded().isZero()) {
            this.fillContainerFromItem();
        }
    }

    private boolean fillContainerFromItem() {
        FloatingLong extractedEnergy;
        FloatingLong simulatedRemainder;
        FloatingLong energyInItem;
        IStrictEnergyHandler itemEnergyHandler = EnergyCompatUtils.getStrictEnergyHandler(this.current);
        if (itemEnergyHandler != null && !(energyInItem = itemEnergyHandler.extractEnergy(this.energyContainer.getNeeded(), Action.SIMULATE)).isZero() && (simulatedRemainder = this.energyContainer.insert(energyInItem, Action.SIMULATE, AutomationType.INTERNAL)).smallerThan(energyInItem) && !(extractedEnergy = itemEnergyHandler.extractEnergy(energyInItem.subtract(simulatedRemainder), Action.EXECUTE)).isZero()) {
            MekanismUtils.logExpectedZero(this.energyContainer.insert(extractedEnergy, Action.EXECUTE, AutomationType.INTERNAL));
            this.onContentsChanged();
            return true;
        }
        return false;
    }

    public void drainContainer() {
        FloatingLong extractedEnergy;
        FloatingLong storedEnergy;
        FloatingLong simulatedRemainder;
        IStrictEnergyHandler itemEnergyHandler;
        if (!this.isEmpty() && !this.energyContainer.isEmpty() && (itemEnergyHandler = EnergyCompatUtils.getStrictEnergyHandler(this.current)) != null && (simulatedRemainder = itemEnergyHandler.insertEnergy(storedEnergy = this.energyContainer.getEnergy(), Action.SIMULATE)).smallerThan(storedEnergy) && !(extractedEnergy = this.energyContainer.extract(storedEnergy.subtract(simulatedRemainder), Action.EXECUTE, AutomationType.INTERNAL)).isZero()) {
            MekanismUtils.logExpectedZero(itemEnergyHandler.insertEnergy(extractedEnergy, Action.EXECUTE));
            this.onContentsChanged();
        }
    }
}

