/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container;

import mekanism.api.gear.IModuleHelper;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.ArmorSlot;
import mekanism.common.inventory.container.slot.HotBarSlot;
import mekanism.common.inventory.container.slot.OffhandSlot;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.util.EnumUtils;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ModuleTweakerContainer
extends MekanismContainer {
    public ModuleTweakerContainer(int id, Inventory inv) {
        super(MekanismContainerTypes.MODULE_TWEAKER, id, inv);
        this.addSlotsAndOpen();
    }

    @Override
    protected void addInventorySlots(@NotNull Inventory inv) {
        int armorInventorySize = inv.armor.size();
        for (int index = 0; index < armorInventorySize; ++index) {
            EquipmentSlot slotType = EnumUtils.EQUIPMENT_SLOT_TYPES[2 + armorInventorySize - index - 1];
            this.addSlot(new ArmorSlot(this, inv, 36 + slotType.ordinal() - 2, 8, 8 + index * 18, slotType){

                @Override
                public boolean mayPickup(@NotNull Player player) {
                    return false;
                }

                @Override
                public boolean mayPlace(@NotNull ItemStack stack) {
                    return false;
                }
            });
        }
        for (int slotY = 0; slotY < Inventory.getSelectionSize(); ++slotY) {
            this.addSlot(new HotBarSlot(this, (Container)inv, slotY, 43 + slotY * 18, 161){

                public boolean mayPickup(@NotNull Player player) {
                    return false;
                }

                public boolean mayPlace(@NotNull ItemStack stack) {
                    return false;
                }
            });
        }
        this.addSlot(new OffhandSlot(this, (Container)inv, 40, 8, 88, inv.player){

            public boolean mayPickup(@NotNull Player player) {
                return false;
            }

            public boolean mayPlace(@NotNull ItemStack stack) {
                return false;
            }
        });
    }

    public static boolean isTweakableItem(ItemStack stack) {
        return IModuleHelper.INSTANCE.getModuleContainer(stack) != null;
    }

    public static boolean hasTweakableItem(Player player) {
        for (int slot = 0; slot < Inventory.getSelectionSize(); ++slot) {
            if (!ModuleTweakerContainer.isTweakableItem((ItemStack)player.getInventory().items.get(slot))) continue;
            return true;
        }
        return player.getInventory().armor.stream().anyMatch(ModuleTweakerContainer::isTweakableItem) || player.getInventory().offhand.stream().anyMatch(ModuleTweakerContainer::isTweakableItem);
    }

    @Override
    public boolean canPlayerAccess(@NotNull Player player) {
        return true;
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }
}

